/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffectLogiaOff;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilityReset;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.YamiProjectiles;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListExtraAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class YamiAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("darkmatter", new String[]{"desc", "Launches a ball of darkness that engulfs the opponent."});
        Values.abilityWebAppExtraParams.put("kurouzu", new String[]{"desc", "Creates a strong gravitational force, that pulls the opponent towards the user."});
        Values.abilityWebAppExtraParams.put("blackhole", new String[]{"desc", "The user spreads darkness over the target area, which engulfs anyone and anything inside of it."});
        Values.abilityWebAppExtraParams.put("liberation", new String[]{"desc", "The user expells everything sucked up by the 'Black Hole' at the target location."});
        Values.abilityWebAppExtraParams.put("blackworld", new String[]{"desc", "The user spreads darkness to the surroundings, blinding enemies and creating pillars made of Darkness."});
        abilitiesArray = new Ability[]{new Kurouzu(), new DarkMatter(), new Liberation(), new BlackHole(), new BlackWorld()};
    }

    public static class DarkMatter
    extends Ability {
        public DarkMatter() {
            super(ListAttributes.DARK_MATTER);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new YamiProjectiles.DarkMatter(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class Kurouzu
    extends Ability {
        private List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();

        public Kurouzu() {
            super(ListAttributes.KUROUZU);
        }

        @Override
        public void startCharging(EntityPlayer player) {
            super.startCharging(player);
        }

        @Override
        public void duringCharging(EntityPlayer player, int currentCharge) {
            MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
            this.entities.clear();
            if (mop != null) {
                double i = mop.field_72311_b;
                double j = mop.field_72312_c;
                double k = mop.field_72309_d;
                WyNetworkHelper.sendToAllAround(new PacketParticles("korouzu", i, j, k), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                for (EntityLivingBase target : WyHelper.getEntitiesNear((int)i, (int)j, (int)k, player.field_70170_p, 5.0)) {
                    this.entities.add(target);
                }
            }
        }

        @Override
        public void endCharging(EntityPlayer player) {
            if (this.entities.contains(player)) {
                this.entities.remove(player);
            }
            for (EntityLivingBase target : this.entities) {
                target.func_70634_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 5));
                target.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100, 5));
                target.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 5));
                new DFEffectLogiaOff(target, 100);
                if (!(target instanceof EntityPlayer)) continue;
                EntityPlayer playerTarget = (EntityPlayer)target;
                WyNetworkHelper.sendTo(new PacketAbilityReset(false), (EntityPlayerMP)playerTarget);
            }
            super.endCharging(player);
        }
    }

    public static class Liberation
    extends Ability {
        public int liberationCount = 0;

        public Liberation() {
            super(ListAttributes.LIBERATION);
        }

        @Override
        public void use(EntityPlayer player) {
            int libCount = 0;
            if (!this.isOnCooldown) {
                if (this.liberationCount > 0) {
                    MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
                    if (mop != null) {
                        double x = mop.field_72311_b;
                        double y = mop.field_72312_c;
                        double z = mop.field_72309_d;
                        while (this.liberationCount > 0) {
                            YamiProjectiles.Liberation liberation = new YamiProjectiles.Liberation(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.LIBERATION_BLOCK);
                            liberation.func_70012_b(x + WyMathHelper.randomWithRange(-3, 3), y + 14.0 + WyMathHelper.randomWithRange(0, 4), z + WyMathHelper.randomWithRange(-3, 3), 0.0f, 0.0f);
                            liberation.field_70159_w = 0.0;
                            liberation.field_70179_y = 0.0;
                            liberation.field_70181_x = -0.7 - player.field_70170_p.field_73012_v.nextDouble();
                            player.field_70170_p.func_72838_d((Entity)liberation);
                            --this.liberationCount;
                        }
                    }
                } else {
                    for (int x = -40; x < 40; ++x) {
                        for (int y = -40; y < 40; ++y) {
                            for (int z = -40; z < 40; ++z) {
                                if (player.field_70170_p.func_147439_a((int)player.field_70165_t + x, (int)player.field_70163_u + y, (int)player.field_70161_v + z) != ListMisc.Darkness) continue;
                                player.field_70170_p.func_147468_f((int)player.field_70165_t + x, (int)player.field_70163_u + y, (int)player.field_70161_v + z);
                                if (++libCount % 10 != 0) continue;
                                ++this.liberationCount;
                            }
                        }
                    }
                }
                super.use(player);
            }
        }
    }

    public static class BlackHole
    extends Ability {
        public BlackHole() {
            super(ListAttributes.BLACKHOLE);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    WyHelper.createFilledSphere(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 10, ListMisc.Darkness, "core", "foliage", "liquids", "ores");
                    WyNetworkHelper.sendToAllAround(new PacketParticles("blackHole", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                }
                super.use(player);
            }
        }
    }

    public static class BlackWorld
    extends Ability {
        public BlackWorld() {
            super(ListAttributes.BLACK_WORLD);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                WyNetworkHelper.sendToAllAround(new PacketParticles("blackWorld", (EntityLivingBase)player), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                if (MainConfig.enableGriefing) {
                    for (int i = 0; i < 8; ++i) {
                        int a1 = player.func_70681_au().nextInt(20) - 10;
                        int a2 = player.func_70681_au().nextInt(20) - 10;
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 1, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 2, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 3, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 4, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 1, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 2, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 3, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 4, (int)player.field_70161_v + a2, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 1, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 2, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 3, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1, (int)player.field_70163_u + 4, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 1, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 2, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 3, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                        DevilFruitsHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.field_70165_t + a1 + 1, (int)player.field_70163_u + 4, (int)player.field_70161_v + a2 + 1, ListMisc.Darkness, "core", "foliage", "liquid", "air");
                    }
                }
                super.use(player);
            }
        }
    }
}

