/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.ISphere;
import xyz.pixelatedw.MineMineNoMi3.api.math.Sphere;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.abilityprojectiles.YukiProjectiles;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class YukiAbilities {
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("fubuki", new String[]{"desc", "The user releases an extremely cold stream of snow that spreads into the air around them."});
        Values.abilityWebAppExtraParams.put("kamakura", new String[]{"desc", "Creates an igloo-like snow barrier around the user."});
        Values.abilityWebAppExtraParams.put("kamakurajussoshi", new String[]{"desc", "Like 'Kamakura', but creates a multi-layered snow barrier."});
        Values.abilityWebAppExtraParams.put("yukirabi", new String[]{"desc", "Launches numerous hardened snowballs, that have the shape of a rabbit's head."});
        Values.abilityWebAppExtraParams.put("tabirayuki", new String[]{"desc", "The user creates a sword made of solid hardened snow."});
        Values.abilityWebAppExtraParams.put("yukigaki", new String[]{"desc", "The user creates a huge wall of snow."});
        abilitiesArray = new Ability[]{new Kamakura(), new TabiraYuki(), new YukiRabi(), new KamakuraJussoshi(), new Fubuki(), new YukiGaki()};
    }

    public static class Kamakura
    extends Ability {
        public Kamakura() {
            super(ListAttributes.KAMAKURA);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
                    World world = player.field_70170_p;
                    if (player.func_70093_af()) {
                        WyHelper.createEmptySphere(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 4, Blocks.field_150433_aE, "air", "foliage", "liquids");
                    } else if (mop != null && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) != Blocks.field_150350_a) {
                        WyHelper.createEmptySphere(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 4, Blocks.field_150433_aE, "air", "foliage", "liquids");
                    }
                }
                super.use(player);
            }
        }
    }

    public static class YukiRabi
    extends Ability {
        public YukiRabi() {
            super(ListAttributes.YUKI_RABI);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new YukiProjectiles.YukiRabi(player.field_70170_p, (EntityLivingBase)player, this.attr);
            super.use(player);
        }
    }

    public static class KamakuraJussoshi
    extends Ability {
        public KamakuraJussoshi() {
            super(ListAttributes.KAMAKURA_JUSSOSHI);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    MovingObjectPosition mop = WyHelper.rayTraceBlocks((Entity)player);
                    World world = player.field_70170_p;
                    if (player.func_70093_af()) {
                        WyHelper.createEmptySphere(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 4, Blocks.field_150433_aE, "air", "foliage", "liquids");
                        WyHelper.createEmptySphere(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 6, Blocks.field_150433_aE, "air", "foliage", "liquids");
                        WyHelper.createEmptySphere(world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 8, Blocks.field_150433_aE, "air", "foliage", "liquids");
                    } else if (mop != null && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) != Blocks.field_150350_a) {
                        WyHelper.createEmptySphere(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 4, Blocks.field_150433_aE, "air", "foliage", "liquids");
                        WyHelper.createEmptySphere(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 6, Blocks.field_150433_aE, "air", "foliage", "liquids");
                        WyHelper.createEmptySphere(world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, 8, Blocks.field_150433_aE, "air", "foliage", "liquids");
                    }
                }
                super.use(player);
            }
        }
    }

    public static class Fubuki
    extends Ability {
        public Fubuki() {
            super(ListAttributes.FUBUKI);
        }

        @Override
        public void use(final EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    Sphere.generate((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, 25, new ISphere(){

                        @Override
                        public void call(int x, int y, int z) {
                            for (int i = -4; i <= 4; ++i) {
                                if (!player.field_70170_p.func_147437_c(x, y, z) || player.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150350_a || player.field_70170_p.func_147439_a(x, y - 1, z) == Blocks.field_150431_aC) continue;
                                player.field_70170_p.func_147449_b(x, y, z, Blocks.field_150431_aC);
                            }
                        }
                    });
                }
                for (EntityLivingBase e : WyHelper.getEntitiesNear((Entity)player, 25.0)) {
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 35.0f);
                    e.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
                }
                WyNetworkHelper.sendToAllAround(new PacketParticles("fubuki", player.field_70165_t, player.field_70163_u, player.field_70161_v), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 128.0);
                super.use(player);
            }
        }
    }

    public static class TabiraYuki
    extends Ability {
        public TabiraYuki() {
            super(ListAttributes.TABIRA_YUKI);
        }

        @Override
        public void startPassive(EntityPlayer player) {
            if (player.field_71071_by.func_70448_g() == null) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ListMisc.TabiraYuki));
            } else {
                WyHelper.sendMsgToPlayer(player, "Cannot equip " + this.getAttribute().getAttributeName() + " while holding another item in hand !");
                this.passive(player);
            }
        }

        @Override
        public void endPassive(EntityPlayer player) {
            player.field_71071_by.func_146027_a((Item)ListMisc.TabiraYuki, -1);
        }
    }

    public static class YukiGaki
    extends Ability {
        public YukiGaki() {
            super(ListAttributes.YUKI_GAKI);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                if (MainConfig.enableGriefing) {
                    int z;
                    int y;
                    int x;
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.NORTH) {
                        for (x = -3; x < 3; ++x) {
                            for (y = 0; y <= 3; ++y) {
                                for (z = -1; z <= 1; ++z) {
                                    player.field_70170_p.func_147449_b((int)player.field_70165_t - x, (int)player.field_70163_u + y, (int)player.field_70161_v - 3 - z, Blocks.field_150433_aE);
                                }
                            }
                        }
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.SOUTH) {
                        for (x = -3; x < 3; ++x) {
                            for (y = 0; y <= 3; ++y) {
                                for (z = -1; z <= 1; ++z) {
                                    player.field_70170_p.func_147449_b((int)player.field_70165_t - x, (int)player.field_70163_u + y, (int)player.field_70161_v + 2 - z, Blocks.field_150433_aE);
                                }
                            }
                        }
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.EAST) {
                        for (x = -1; x < 1; ++x) {
                            for (y = 0; y <= 3; ++y) {
                                for (z = -3; z <= 3; ++z) {
                                    player.field_70170_p.func_147449_b((int)player.field_70165_t + 2 - x, (int)player.field_70163_u + y, (int)player.field_70161_v - z, Blocks.field_150433_aE);
                                }
                            }
                        }
                    }
                    if (WyHelper.get4Directions((Entity)player) == WyHelper.Direction.WEST) {
                        for (x = -1; x < 1; ++x) {
                            for (y = 0; y <= 3; ++y) {
                                for (z = -3; z <= 3; ++z) {
                                    player.field_70170_p.func_147449_b((int)player.field_70165_t - 3 - x, (int)player.field_70163_u + y, (int)player.field_70161_v - z, Blocks.field_150433_aE);
                                }
                            }
                        }
                    }
                }
                super.use(player);
            }
        }
    }
}

