/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyRegistry;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.api.math.ISphere;
import xyz.pixelatedw.MineMineNoMi3.api.math.Sphere;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;

public class WyHelper {
    public static AxisAlignedBB NULL_AABB = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public static EntityLivingBase getEntityByUUID(World world, UUID uuid) {
        List entities = world.field_72996_f.stream().filter(x -> x instanceof EntityLivingBase).collect(Collectors.toList());
        for (EntityLivingBase entity : entities) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static boolean afterDate(String date) {
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        Calendar target = null;
        try {
            target = Calendar.getInstance();
            target.setTime(df.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        Calendar now = Calendar.getInstance();
        return now.after(target);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static AbilityExplosion newExplosion(Entity entity, double posX, double posY, double posZ, double size) {
        AbilityExplosion explosion = new AbilityExplosion(entity, posX, posY, posZ, size);
        return explosion;
    }

    public static void doExplosion(Entity entity, double posX, double posY, double posZ, double size) {
        AbilityExplosion explosion = new AbilityExplosion(entity, posX, posY, posZ, size);
        explosion.doExplosion();
    }

    public static boolean isBlockNearby(EntityLivingBase player, int radius, Block ... blocks) {
        for (Block b : blocks) {
            for (int x = -radius; x < radius; ++x) {
                for (int y = -radius; y < radius; ++y) {
                    for (int z = -radius; z < radius; ++z) {
                        if (player.field_70170_p.func_147439_a((int)player.field_70165_t + x, (int)player.field_70163_u + y, (int)player.field_70161_v + z) != b) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static Block getBlockNearby(EntityLivingBase entity, int radius, Block block) {
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    if (entity.field_70170_p.func_147439_a((int)entity.field_70165_t + x, (int)entity.field_70163_u + y, (int)entity.field_70161_v + z) != block) continue;
                    return entity.field_70170_p.func_147439_a((int)entity.field_70165_t + x, (int)entity.field_70163_u + y, (int)entity.field_70161_v + z);
                }
            }
        }
        return null;
    }

    public static List<int[]> getBlockLocationsNearby(EntityLivingBase entity, int[] radius) {
        ArrayList<int[]> nearbyBlocks = new ArrayList<int[]>();
        for (int x = -radius[0]; x < radius[0]; ++x) {
            for (int y = -radius[1]; y < radius[1]; ++y) {
                for (int z = -radius[2]; z < radius[2]; ++z) {
                    nearbyBlocks.add(new int[]{(int)entity.field_70165_t + x, (int)entity.field_70163_u + y, (int)entity.field_70161_v + z});
                }
            }
        }
        return nearbyBlocks;
    }

    public static List<int[]> getBlockLocationsNearby(EntityLivingBase entity, int radius) {
        ArrayList<int[]> nearbyBlocks = new ArrayList<int[]>();
        for (int x = -radius; x < radius; ++x) {
            for (int y = -radius; y < radius; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    nearbyBlocks.add(new int[]{(int)entity.field_70165_t + x, (int)entity.field_70163_u + y, (int)entity.field_70161_v + z});
                }
            }
        }
        return nearbyBlocks;
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortAlphabetically(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getKey()).compareTo(o2.getKey());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static void generateLangFiles() {
        Map sorted = WyHelper.sortAlphabetically(WyRegistry.getLangMap());
        Set set = sorted.entrySet();
        Iterator i = set.iterator();
        Map.Entry prevEntry = null;
        File langFolder = new File(Values.RESOURCES_FOLDER + "/assets/mineminenomi/lang/");
        langFolder.mkdirs();
        if (langFolder.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Values.RESOURCES_FOLDER + "/assets/mineminenomi/lang/en_US.lang"), "UTF-8"));){
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    if (prevEntry != null && !((String)prevEntry.getKey()).substring(0, 2).equals(((String)entry.getKey()).substring(0, 2))) {
                        writer.write("\n");
                    }
                    writer.write(entry.getKey() + "=" + entry.getValue() + "\n");
                    prevEntry = entry;
                }
                ((Writer)writer).close();
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
    }

    public static void setEntityFlag(Entity player, int id, boolean bool) {
        byte b0 = player.func_70096_w().func_75683_a(0);
        if (bool) {
            player.func_70096_w().func_75692_b(0, (Object)((byte)(b0 | 1 << id)));
        } else {
            player.func_70096_w().func_75692_b(0, (Object)((byte)(b0 & ~(1 << id))));
        }
    }

    public static Color hslToColor(float h, float s, float l) {
        float[] hsl = new float[]{h, s, l};
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, WyHelper.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, WyHelper.hueToRGB(p, q, h));
        float b = Math.max(0.0f, WyHelper.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color(r, g, b);
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public static Color hexToRGB(String hexColor) {
        if (hexColor.startsWith("#")) {
            return Color.decode(hexColor);
        }
        return Color.decode("#" + hexColor);
    }

    public static String formatBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void sendMsgToPlayer(EntityPlayer player, String text) {
        player.func_146105_b((IChatComponent)new ChatComponentText(text));
    }

    public static String upperCaseFirst(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1) + " ";
    }

    public static String getFancyName(String text) {
        return text.replaceAll("\\s+", "").toLowerCase().replaceAll("'", "").replaceAll("-", "").replaceAll(":", "").replaceAll("#", "").replace(",", "");
    }

    public static String getFancyNameNoLowerCase(String text) {
        return text.replaceAll("\\s+", "").replaceAll("'", "").replaceAll("-", "").replaceAll(":", "").replaceAll("#", "").replace(",", "");
    }

    public static List<EntityLivingBase> getEntitiesNear(int x, int y, int z, World world, double radius) {
        return WyHelper.getEntitiesNear(x, y, z, world, radius, EntityLivingBase.class);
    }

    public static List<EntityLivingBase> getEntitiesNear(int x, int y, int z, World world, double radius, Class<? extends Entity> classEntity) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(radius, radius, radius);
        List list = world.func_72872_a(classEntity, aabb);
        return list;
    }

    public static List<EntityLivingBase> getEntitiesNear(Entity e, double radius) {
        return WyHelper.getEntitiesNear(e, radius, EntityLivingBase.class);
    }

    public static List<EntityLivingBase> getEntitiesNear(Entity e, double radius, Class<? extends Entity> ... classEntities) {
        try {
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v, (double)(e.field_70165_t + 1.0), (double)(e.field_70163_u + 1.0), (double)(e.field_70161_v + 1.0)).func_72314_b(radius, radius, radius);
            ArrayList<EntityLivingBase> list = new ArrayList<EntityLivingBase>();
            for (Class<? extends Entity> clz : classEntities) {
                list.addAll(e.field_70170_p.func_72872_a(clz, aabb));
            }
            list.remove(e);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> getEntitiesNear(Entity e, double[] radius, Class<? extends T> ... classEntities) {
        try {
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v, (double)(e.field_70165_t + 1.0), (double)(e.field_70163_u + 1.0), (double)(e.field_70161_v + 1.0)).func_72314_b(radius[0], radius[1], radius[2]);
            ArrayList list = new ArrayList();
            for (Class<? extends T> clz : classEntities) {
                list.addAll(e.field_70170_p.func_72872_a(clz, aabb));
            }
            list.remove(e);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static List<EntityLivingBase> getEntitiesNear(TileEntity e, double radius) {
        return WyHelper.getEntitiesNear(e, radius, EntityLivingBase.class);
    }

    public static List<EntityLivingBase> getEntitiesNear(TileEntity e, double radius, Class<? extends Entity> classEntity) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)e.field_145851_c, (double)e.field_145848_d, (double)e.field_145849_e, (double)(e.field_145851_c + 1), (double)(e.field_145848_d + 1), (double)(e.field_145849_e + 1)).func_72314_b(radius, radius, radius);
        List list = e.func_145831_w().func_72872_a(classEntity, aabb);
        return list;
    }

    public static Direction get4Directions(Entity e) {
        switch (MathHelper.func_76128_c((double)((double)(e.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.WEST;
            }
            case 2: {
                return Direction.NORTH;
            }
            case 3: {
                return Direction.EAST;
            }
        }
        return null;
    }

    public static Direction get8Directions(Entity e) {
        switch (MathHelper.func_76128_c((double)((double)(e.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0: {
                return Direction.SOUTH;
            }
            case 1: {
                return Direction.SOUTH_WEST;
            }
            case 2: {
                return Direction.WEST;
            }
            case 3: {
                return Direction.NORTH_WEST;
            }
            case 4: {
                return Direction.NORTH;
            }
            case 5: {
                return Direction.NORTH_EAST;
            }
            case 6: {
                return Direction.EAST;
            }
            case 7: {
                return Direction.SOUTH_EAST;
            }
        }
        return null;
    }

    public static MovingObjectPosition rayTraceBlocks(Entity e) {
        float f = 1.0f;
        float f1 = e.field_70127_C + (e.field_70125_A - e.field_70127_C) * f;
        float f2 = e.field_70126_B + (e.field_70177_z - e.field_70126_B) * f;
        double d = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)f;
        double d1 = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)f + 1.62 - e.func_70033_W();
        double d2 = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - 3.141593f));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f));
        float f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f));
        float f7 = f4 * f5;
        float f9 = f3 * f5;
        double d3 = 5000.0;
        Vec3 vec3 = vec3d.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f9 * d3);
        MovingObjectPosition ray = e.field_70170_p.func_72901_a(vec3d, vec3, false);
        return ray;
    }

    public static List<int[]> createEmptyCube(Entity entity, int[] sizes, Block blockToPlace, String ... blockRules) {
        return WyHelper.createEmptyCube(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, sizes, blockToPlace, blockRules);
    }

    public static List<int[]> createEmptyCube(World world, double posX, double posY, double posZ, int[] sizes, Block blockToPlace, String ... blockRules) {
        ArrayList<int[]> blocks = new ArrayList<int[]>();
        for (int x = sizes[0] * 0 - sizes[0]; x <= sizes[0]; ++x) {
            for (int y = sizes[1] * 0 - sizes[1]; y <= sizes[1]; ++y) {
                for (int z = sizes[2] * 0 - sizes[2]; z <= sizes[2]; ++z) {
                    if (x != -sizes[0] && x != sizes[0] && y != -sizes[1] && y != sizes[1] && z != -sizes[2] && z != sizes[2]) continue;
                    DevilFruitsHelper.placeBlockIfAllowed(world, (int)posX + x, (int)posY + y, (int)posZ + z, blockToPlace, blockRules);
                    blocks.add(new int[]{(int)posX + x, (int)posY + y, (int)posZ + z});
                }
            }
        }
        return blocks;
    }

    public static List<int[]> createFilledCube(Entity entity, int[] sizes, Block blockToPlace, String ... blockRules) {
        return WyHelper.createFilledCube(entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, sizes, blockToPlace, blockRules);
    }

    public static List<int[]> createFilledCube(World world, double posX, double posY, double posZ, int[] sizes, Block blockToPlace, String ... blockRules) {
        ArrayList<int[]> blocks = new ArrayList<int[]>();
        for (int x = sizes[0] * 0 - sizes[0]; x <= sizes[0]; ++x) {
            for (int y = sizes[1] * 0 - sizes[1]; y <= sizes[1]; ++y) {
                for (int z = sizes[2] * 0 - sizes[2]; z <= sizes[2]; ++z) {
                    DevilFruitsHelper.placeBlockIfAllowed(world, (int)posX + x, (int)posY + y, (int)posZ + z, blockToPlace, blockRules);
                    blocks.add(new int[]{(int)posX + x, (int)posY + y, (int)posZ + z});
                }
            }
        }
        return blocks;
    }

    public static List<int[]> createEmptySphere(final World world, final int posX, final int posY, final int posZ, final int size, final Block block, final String ... blockRules) {
        final ArrayList<int[]> blocks = new ArrayList<int[]>();
        try {
            Thread sphereGenerator = new Thread("Sphere Generator"){

                @Override
                public void run() {
                    Sphere.generate(posX, posY, posZ, size, new ISphere(){

                        @Override
                        public void call(int x, int y, int z) {
                            DevilFruitsHelper.placeBlockIfAllowed(world, x, y, z, block, blockRules);
                            blocks.add(new int[]{x, y, z});
                        }
                    });
                }
            };
            sphereGenerator.start();
            sphereGenerator.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return blocks;
    }

    public static List<int[]> createFilledSphere(final World world, final int posX, final int posY, final int posZ, final int size, final Block block, final String ... blockRules) {
        final ArrayList<int[]> blocks = new ArrayList<int[]>();
        try {
            Thread sphereGenerator = new Thread("Sphere Generator"){

                @Override
                public void run() {
                    Sphere.generateFilled(posX, posY, posZ, size, new ISphere(){

                        @Override
                        public void call(int x, int y, int z) {
                            DevilFruitsHelper.placeBlockIfAllowed(world, x, y, z, block, blockRules);
                            blocks.add(new int[]{x, y, z});
                        }
                    });
                }
            };
            sphereGenerator.start();
            sphereGenerator.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return blocks;
    }

    public static void removeStackFromArmorSlots(EntityPlayer player, ItemStack stack) {
        int x;
        for (int i = x = player.field_71071_by.field_70462_a.length; i < x + player.field_71071_by.field_70460_b.length; ++i) {
            if (stack != player.field_71071_by.func_70301_a(i)) continue;
            player.field_71071_by.func_70299_a(i, null);
            break;
        }
    }

    public static void removeStackFromInventory(EntityPlayer player, ItemStack stack) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            if (stack != player.field_71071_by.func_70301_a(i)) continue;
            player.field_71071_by.func_70299_a(i, null);
            break;
        }
    }

    public static void removeStackFromSlot(EntityPlayer player, int index) {
        if (player.field_71071_by.field_70462_a[index] != null) {
            player.field_71071_by.field_70462_a[index] = null;
        }
    }

    public static int getPatreonLevel(EntityPlayer player) {
        boolean flag = false;
        String apiURL = "/patreon?uuid=" + player.func_110124_au().toString();
        String result = WyTelemetry.sendGET(apiURL);
        if (!WyHelper.isNullOrEmpty(result)) {
            int patreonLevel = Integer.parseInt(result);
            return patreonLevel;
        }
        return 1;
    }

    public static boolean isCelestialDragon(EntityPlayer player) {
        return WyHelper.getPatreonLevel(player) == 4;
    }

    public static boolean isSupernova(EntityPlayer player) {
        return WyHelper.getPatreonLevel(player) == 3;
    }

    public static boolean isRookie(EntityPlayer player) {
        return WyHelper.getPatreonLevel(player) == 2;
    }

    public static boolean isDevBuild() {
        return "RELEASE".equalsIgnoreCase("DEV");
    }

    public static boolean isEarlyAccessBuild() {
        return "RELEASE".equalsIgnoreCase("EARLY_ACCESS");
    }

    public static boolean isReleaseBuild() {
        return "RELEASE".equalsIgnoreCase("RELEASE");
    }

    public static boolean hasPatreonAccess(EntityPlayer player) {
        int patreon = WyHelper.getPatreonLevel(player);
        if (WyHelper.isDevBuild() && WyDebug.isDebug()) {
            return true;
        }
        if (WyHelper.isDevBuild() && patreon >= 4) {
            return true;
        }
        return WyHelper.isEarlyAccessBuild() && patreon >= 3;
    }

    public static enum Direction {
        SOUTH,
        SOUTH_EAST,
        EAST,
        NORTH,
        NORTH_EAST,
        NORTH_WEST,
        WEST,
        SOUTH_WEST;

    }
}

