/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;
import xyz.pixelatedw.MineMineNoMi3.MainMod;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.blocks.BlockSakeFeast;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class WyRegistry {
    private static int entityID = 200;
    private static int packetID = 0;
    protected static HashMap lang = new HashMap();
    protected static HashMap items = new HashMap();

    public static HashMap getLangMap() {
        return lang;
    }

    public static HashMap getItemsMap() {
        return items;
    }

    public static void registerName(String key, String localizedName) {
        if (WyDebug.isDebug()) {
            WyRegistry.getLangMap().put(key, localizedName);
        }
    }

    public static void registerBlock(Block block, String localizedName, float hard, CreativeTabs tab, Class<? extends TileEntity> tile) {
        WyRegistry.registerBlock(block, null, localizedName, hard, tab, tile);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlock, String localizedName, float hard, CreativeTabs tab, Class<? extends TileEntity> tile) {
        String truename = WyHelper.getFancyName(localizedName);
        block.func_149663_c(truename).func_149658_d("mineminenomi:" + truename).func_149711_c(hard).func_149752_b(hard);
        if (itemBlock == null) {
            GameRegistry.registerBlock((Block)block, (String)truename);
        } else if (block == ListMisc.SakeBottleBlock) {
            BlockSakeFeast blk = (BlockSakeFeast)block;
            GameRegistry.registerBlock((Block)blk, itemBlock, (String)truename);
        }
        if (tab != null) {
            block.func_149647_a(tab);
        }
        if (tile != null) {
            GameRegistry.registerTileEntity(tile, (String)truename);
        }
        WyRegistry.getItemsMap().put(block, localizedName);
        WyRegistry.registerName("tile." + truename + ".name", localizedName);
    }

    public static void registerItem(Item item, String localizedName) {
        WyRegistry.registerItem(item, localizedName, null);
    }

    public static void registerItem(Item item, String localizedName, CreativeTabs tab) {
        String truename = WyHelper.getFancyName(localizedName);
        item.func_77655_b(truename).func_111206_d("mineminenomi:" + truename);
        if (tab != null) {
            item.func_77637_a(tab);
        }
        GameRegistry.registerItem((Item)item, (String)truename);
        WyRegistry.getItemsMap().put(item, localizedName);
        WyRegistry.registerName("item." + truename + ".name", localizedName);
    }

    public static void registerMob(String name, Class<? extends Entity> entity) {
        WyRegistry.registerMob(name, entity, -1, -1);
    }

    public static void registerMob(String name, Class<? extends Entity> entity, int color1, int color2) {
        EntityRegistry.registerModEntity(entity, (String)name, (int)entityID++, (Object)MainMod.getMineMineNoMi(), (int)128, (int)3, (boolean)true);
        if (color1 != -1 && color2 != -1) {
            EntityList.func_75614_a(entity, (String)name, (int)entityID++, (int)color1, (int)color2);
        }
        WyRegistry.registerName("entity." + name + ".name", name);
    }

    public static void registerSpawnBiomesFor(Class<? extends EntityLiving> entity, int rarity, int min, int max, BiomeDictionary.Type ... biomeTypes) {
        BiomeGenBase[] biomes = new BiomeGenBase[]{};
        for (BiomeDictionary.Type t : biomeTypes) {
            biomes = (BiomeGenBase[])ArrayUtils.addAll((Object[])biomes, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t));
        }
        EntityRegistry.addSpawn(entity, (int)rarity, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.creature, (BiomeGenBase[])biomes);
    }

    public static void registerEnchantment(Enchantment enc, String name) {
        String truename = WyHelper.getFancyName(name);
        enc.func_77322_b(truename);
        WyRegistry.registerName("enchantment." + truename, name);
    }
}

