/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;

public class WyRenderHelper {
    public static void drawStringWithBorder(String text, int posX, int posY, int color) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.func_78276_b(text, posX, posY - 1, 1);
        font.func_78276_b(text, posX, posY + 1, 1);
        font.func_78276_b(text, posX + 1, posY, 1);
        font.func_78276_b(text, posX - 1, posY, 1);
        font.func_78276_b(text, posX, posY, color);
    }

    public static double[] generateAnimationArray(double startPos, double minPos, double maxPos, double frameSkip, int framesPerSlot) {
        double i;
        int framesCount = 0;
        double currentFrame = startPos;
        boolean hasReachedMaxPos = false;
        boolean hasReachedMinPos = false;
        for (i = startPos; i <= maxPos; i += frameSkip) {
            ++framesCount;
        }
        for (i = maxPos; i > minPos; i -= frameSkip) {
            ++framesCount;
        }
        for (i = minPos; i <= startPos; i += frameSkip) {
            ++framesCount;
        }
        framesCount *= framesPerSlot;
        double[] animation = new double[framesCount -= 1 * framesPerSlot];
        for (int j = 0; j < framesCount; ++j) {
            for (int k = 0; k < framesPerSlot; ++k) {
                if (j + 1 >= framesCount) continue;
                if (k > 0) {
                    ++j;
                }
                animation[j] = currentFrame;
            }
            if (!hasReachedMaxPos && currentFrame < maxPos) {
                currentFrame += frameSkip;
            } else if (!hasReachedMinPos && hasReachedMaxPos && currentFrame > minPos) {
                currentFrame -= frameSkip;
            } else if (hasReachedMinPos && currentFrame < startPos) {
                currentFrame += frameSkip;
            }
            if (currentFrame >= maxPos) {
                hasReachedMaxPos = true;
            }
            if (!(currentFrame <= minPos)) continue;
            hasReachedMinPos = true;
        }
        return animation;
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        WyRenderHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78370_a(r, g, b, alpha);
        tessellator.func_78377_a(posX, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY + height, zLevel);
        tessellator.func_78377_a(posX + width, posY, zLevel);
        tessellator.func_78377_a(posX, posY, zLevel);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    public static void renderTestStencil() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        EntityClientPlayerMP entityClientPlayerMP = mc.field_71439_g;
        GL11.glEnable((int)2960);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GL11.glClear((int)1024);
        GL11.glColor3d((double)255.0, (double)0.0, (double)0.0);
        WyRenderHelper.drawEntityOnScreen((int)reso.func_78327_c() / 2, (int)reso.func_78324_d() / 2, 64, 0.0f, 0.0f, (EntityLivingBase)mc.field_71439_g);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glColor3d((double)255.0, (double)0.0, (double)0.0);
        WyRenderHelper.drawEntityOnScreen((int)reso.func_78327_c() / 2, (int)reso.func_78324_d() / 2, 64, 0.0f, 0.0f, (EntityLivingBase)mc.field_71439_g);
        GL11.glDisable((int)2960);
    }

    public static void drawAbilityIcon(String iconName, int x, int y, int u, int v) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("mineminenomi", "textures/abilities/" + WyHelper.getFancyName(iconName) + ".png"));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + v), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + u), (double)(y + v), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + u), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawDevilFruitIcon(String iconName, int x, int y, int u, int v) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("mineminenomi", "textures/items/" + WyHelper.getFancyName(iconName) + ".png"));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + v), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + u), (double)(y + v), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + u), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase entity) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        entity.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        entity.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)entity.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledRes = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        double scaleW = (double)mc.field_71443_c / scaledRes.func_78327_c();
        double scaleH = (double)mc.field_71440_d / scaledRes.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }
}

