/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api;

import com.google.common.primitives.UnsignedBytes;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.Schematic;

public class WySchematicHelper {
    public static Schematic load(String name) {
        try {
            InputStream is = WySchematicHelper.class.getClassLoader().getResourceAsStream("assets/mineminenomi/schematics/" + name + ".schematic");
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            short width = nbt.func_74765_d("Width");
            short height = nbt.func_74765_d("Height");
            short length = nbt.func_74765_d("Length");
            byte[] blocks = nbt.func_74770_j("Blocks");
            byte[] data = nbt.func_74770_j("Data");
            NBTTagList tiles = nbt.func_150295_c("TileEntities", 10);
            is.close();
            return new Schematic(name, tiles, width, height, length, blocks, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void build(Schematic sch, World world, int posX, int posY, int posZ) {
        WySchematicHelper.build(sch, world, posX, posY, posZ, null);
    }

    public static void build(Schematic sch, World world, int posX, int posY, int posZ, Block airReplacement) {
        try {
            int i = 0;
            ArrayList tiles = new ArrayList();
            for (int sy = 0; sy < sch.getHeight(); ++sy) {
                for (int sz = 0; sz < sch.getLength(); ++sz) {
                    for (int sx = 0; sx < sch.getWidth(); ++sx) {
                        Block b = Block.func_149729_e((int)UnsignedBytes.toInt((byte)sch.getBlocks()[i]));
                        if (b != Blocks.field_150350_a && world.func_147439_a(posX + sx, posY + sy, posZ + sz) != b) {
                            if (b != airReplacement) {
                                world.func_147465_d(posX + sx, posY + sy, posZ + sz, b, (int)sch.getData()[i], 2);
                            } else {
                                world.func_147449_b(posX + sx, posY + sy, posZ + sz, Blocks.field_150350_a);
                            }
                            if (world.func_147439_a(posX + sx, posY + sy, posZ + sz) == Blocks.field_150355_j || world.func_147439_a(posX + sx, posY + sy, posZ + sz) == Blocks.field_150358_i) {
                                world.func_147471_g(posX + sx, posY + sy, posZ + sz);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("[ERROR] The .schematic could not be built due to : " + e.toString());
            e.printStackTrace();
        }
    }
}

