/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityAttribute;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityProjectile;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityExplosion;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketAbilitySync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketShounenScream;

public class Ability {
    protected AbilityProjectile projectile;
    protected String originalDisplayName = "n/a";
    protected AbilityAttribute attr;
    protected boolean isOnCooldown = false;
    protected boolean isCharging = false;
    protected boolean isRepeating = false;
    protected boolean passiveActive = false;
    protected boolean isDisabled = false;
    private int ticksForCooldown;
    private int ticksForCharge;
    private int ticksForRepeater;
    private int ticksForRepeaterFreq;
    private int currentSpawn = 0;

    public Ability(AbilityAttribute attr) {
        this.attr = new AbilityAttribute(attr);
        this.ticksForCooldown = this.attr.getAbilityCooldown();
        this.ticksForCharge = this.attr.getAbilityCharges();
        this.ticksForRepeater = this.attr.getAbilityCooldown();
        this.ticksForRepeaterFreq = this.attr.getAbilityRepeaterFrequency();
        this.originalDisplayName = this.attr.getAbilityDisplayName();
    }

    public AbilityAttribute getAttribute() {
        return this.attr;
    }

    public void use(EntityPlayer player) {
        if (!this.isOnCooldown) {
            if (this.projectile != null) {
                if (this.attr.isRepeater()) {
                    this.startRepeater(player);
                } else {
                    player.field_70170_p.func_72838_d((Entity)this.projectile);
                }
            }
            if (this.attr.getPotionEffectsForUser() != null) {
                for (PotionEffect p : this.attr.getPotionEffectsForUser()) {
                    player.func_70690_d(new PotionEffect(p));
                }
            }
            if (this.attr.getPotionEffectsForAoE() != null) {
                for (PotionEffect p : this.attr.getPotionEffectsForAoE()) {
                    for (EntityLivingBase l : WyHelper.getEntitiesNear((Entity)player, (double)this.attr.getEffectRadius())) {
                        l.func_70690_d(new PotionEffect(p));
                    }
                }
            }
            if (this.attr.getAbilityCharges() <= 0 && this.attr.getAbilityExplosionPower() > 0) {
                AbilityExplosion explosion = WyHelper.newExplosion((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.attr.getAbilityExplosionPower());
                explosion.setDamageOwner(false);
                explosion.setFireAfterExplosion(this.attr.canAbilityExplosionSetFire());
                explosion.setDestroyBlocks(this.attr.canAbilityExplosionDestroyBlocks());
                explosion.doExplosion();
            }
            if (!player.field_71075_bZ.field_75098_d) {
                WyTelemetry.addAbilityStat(this.getAttribute().getAbilityTexture(), this.getAttribute().getAttributeName(), 1);
            }
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            props.setTempPreviousAbility(WyHelper.getFancyName(this.attr.getAttributeName()));
            if (!this.attr.isPassive()) {
                this.sendShounenScream(player);
            }
            this.duringRepeater(player);
            this.startCooldown();
            WyNetworkHelper.sendTo(new PacketAbilitySync(abilityProps), (EntityPlayerMP)player);
            new Update(player, this.attr).start();
        }
    }

    public void duringRepeater(EntityPlayer player) {
        if (this.isRepeating) {
            try {
                if (!player.field_70170_p.field_72995_K && this.currentSpawn % this.ticksForRepeaterFreq == 0) {
                    player.field_70170_p.func_72838_d((Entity)((Object)((Object)this.projectile)).getClass().getDeclaredConstructor(World.class, EntityLivingBase.class, AbilityAttribute.class).newInstance(player.field_70170_p, player, this.attr));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++this.currentSpawn;
        }
    }

    protected void startRepeater(EntityPlayer player) {
        this.isRepeating = true;
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public void passive(EntityPlayer player) {
        if (!this.isOnCooldown) {
            if (this.passiveActive) {
                this.passiveActive = false;
                WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
                if (this.attr.getPotionEffectsForUser() != null) {
                    for (PotionEffect p : this.attr.getPotionEffectsForUser()) {
                        player.func_82170_o(p.func_76456_a());
                    }
                }
                this.endPassive(player);
            } else {
                this.passiveActive = true;
                WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
                if (this.attr.getPotionEffectsForUser() != null) {
                    for (PotionEffect p : this.attr.getPotionEffectsForUser()) {
                        player.func_70690_d(new PotionEffect(p.func_76456_a(), Integer.MAX_VALUE, p.func_76458_c(), true));
                    }
                }
                this.sendShounenScream(player);
                this.startPassive(player);
                new Update(player, this.attr).start();
            }
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void disable(EntityPlayer player, boolean bool) {
        this.isDisabled = bool;
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
    }

    public void endPassive(EntityPlayer player) {
        if (this.attr.getPotionEffectsForUser() != null) {
            for (PotionEffect p : this.attr.getPotionEffectsForUser()) {
                player.func_82170_o(p.func_76456_a());
            }
        }
    }

    public void startPassive(EntityPlayer player) {
    }

    public void duringPassive(EntityPlayer player, int passiveTimer) {
    }

    public boolean isPassiveActive() {
        return this.passiveActive;
    }

    public void setPassiveActive(boolean b) {
        this.passiveActive = b;
    }

    public void setChargeActive(boolean b) {
        this.isCharging = b;
    }

    public void setCooldownActive(boolean b) {
        this.isOnCooldown = b;
    }

    public void duringCharging(EntityPlayer player, int currentCharge) {
    }

    public void startCharging(EntityPlayer player) {
        if (!this.isOnCooldown) {
            this.sendShounenScream(player, 1);
            this.isCharging = true;
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
            new Update(player, this.attr).start();
        }
    }

    public void endCharging(EntityPlayer player) {
        this.isCharging = false;
        this.isOnCooldown = true;
        if (player instanceof EntityPlayerMP) {
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
        }
        if (this.projectile != null) {
            if (this.attr.isRepeater()) {
                this.startRepeater(player);
            } else {
                player.field_70170_p.func_72838_d((Entity)this.projectile);
            }
        }
        this.sendShounenScream(player, 2);
        if (this.attr.getAbilityExplosionPower() > 0) {
            player.field_70170_p.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, (float)this.attr.getAbilityExplosionPower(), this.attr.canAbilityExplosionSetFire(), MainConfig.enableGriefing ? this.attr.canAbilityExplosionDestroyBlocks() : false);
        }
        if (!WyHelper.isDevBuild() && !player.field_71075_bZ.field_75098_d) {
            WyTelemetry.addAbilityStat(this.getAttribute().getAbilityTexture(), this.getAttribute().getAttributeName(), 1);
        }
        new Update(player, this.attr).start();
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    public boolean isOnCooldown() {
        return this.isOnCooldown;
    }

    public void duringCooldown(EntityPlayer player, int currentCooldown) {
    }

    public void hitEntity(EntityPlayer player, EntityLivingBase target) {
        if (player == target) {
            return;
        }
        if (this.attr.getPotionEffectsForHit() != null) {
            for (PotionEffect p : this.attr.getPotionEffectsForHit()) {
                target.func_70690_d(new PotionEffect(p.func_76456_a(), p.func_76459_b(), p.func_76458_c(), true));
            }
        }
        if (this.attr.getAbilityExplosionPower() > 0) {
            player.field_70170_p.func_72885_a((Entity)target, target.field_70165_t, target.field_70163_u, target.field_70161_v, (float)this.attr.getAbilityExplosionPower(), this.attr.canAbilityExplosionSetFire(), MainConfig.enableGriefing ? this.attr.canAbilityExplosionDestroyBlocks() : false);
        }
        this.passiveActive = false;
        this.startCooldown();
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.attr.getPunchDamage() * ExtendedEntityData.get((EntityLivingBase)player).getDamageMultiplier());
        new Update(player, this.attr).start();
    }

    protected void startCooldown() {
        this.isOnCooldown = true;
    }

    protected void startExtUpdate(EntityPlayer player) {
        WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
        new Update(player, this.attr).start();
    }

    public void startUpdate(EntityPlayer player) {
        this.setCooldownActive(true);
        if (player instanceof EntityPlayerMP) {
            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(player)), (EntityPlayerMP)player);
        }
        new Update(player, this.attr).start();
    }

    protected void sendShounenScream(EntityPlayer player) {
        this.sendShounenScream(player, 0);
    }

    protected void sendShounenScream(EntityPlayer player, int part) {
        if (MainConfig.enableAnimeScreaming) {
            WyNetworkHelper.sendToAllAround(new PacketShounenScream(player.func_70005_c_(), this.attr.getAbilityDisplayName(), part), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 15.0);
        }
    }

    public void reset() {
        this.isOnCooldown = false;
        this.isCharging = false;
        this.isRepeating = false;
        this.passiveActive = false;
    }

    class Update
    extends Thread {
        private EntityPlayer player;
        private AbilityAttribute attr;

        public Update(EntityPlayer user, AbilityAttribute attribute) {
            this.player = user;
            this.attr = attribute;
            this.setName("Update Thread for " + this.attr.getAttributeName());
            Ability.this.ticksForCooldown = this.attr.getAbilityCooldown();
            Ability.this.ticksForCharge = this.attr.getAbilityCharges();
        }

        @Override
        public void run() {
            block16: {
                block15: {
                    if (Ability.this.passiveActive) {
                        int passiveTimer = 0;
                        while (Ability.this.passiveActive) {
                            Ability.this.duringPassive(this.player, passiveTimer++);
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (!Ability.this.isOnCooldown) break block15;
                    while (Ability.this.isOnCooldown) {
                        if (Ability.this.ticksForCooldown > 0) {
                            Ability.this.ticksForCooldown--;
                            if (Ability.this.isRepeating) {
                                Ability.this.ticksForRepeater--;
                                if (Ability.this.ticksForRepeater <= this.attr.getAbilityCooldown() - this.attr.getAbilityCooldown() / this.attr.getAbilityRepeaterTime() || Ability.this.projectile == null) {
                                    Ability.this.isRepeating = false;
                                    Ability.this.ticksForRepeater = this.attr.getAbilityCooldown();
                                }
                            }
                            Ability.this.duringCooldown(this.player, Ability.this.ticksForCooldown);
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        Ability.this.ticksForCooldown = this.attr.getAbilityCooldown();
                        Ability.this.currentSpawn = 0;
                        Ability.this.isOnCooldown = false;
                        if (this.player instanceof EntityPlayerMP) {
                            WyNetworkHelper.sendTo(new PacketAbilitySync(AbilityProperties.get(this.player)), (EntityPlayerMP)this.player);
                        }
                        return;
                    }
                    break block16;
                }
                if (!Ability.this.isCharging) break block16;
                while (Ability.this.isCharging) {
                    if (Ability.this.ticksForCharge > 0) {
                        Ability.this.ticksForCharge--;
                        Ability.this.duringCharging(this.player, Ability.this.ticksForCharge);
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    Ability.this.ticksForCharge = this.attr.getAbilityCharges();
                    Ability.this.endCharging(this.player);
                }
            }
        }
    }

    class ResetDisable
    extends Thread {
        private EntityPlayer player;
        private ExtendedEntityData props;
        private AbilityAttribute attr;

        public ResetDisable(EntityPlayer user, AbilityAttribute attribute) {
            this.player = user;
            this.props = ExtendedEntityData.get((EntityLivingBase)this.player);
            this.attr = attribute;
            this.setName("ResetThread Thread for " + this.attr.getAttributeName());
        }

        @Override
        public void run() {
            while (Ability.this.isDisabled) {
                if (!DevilFruitsHelper.isNearbyKairoseki(this.player)) {
                    Ability.this.disable(this.player, false);
                    Ability.this.setCooldownActive(false);
                    return;
                }
                try {
                    while (true) {
                        Thread.sleep(24L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean abilityCounterpart(String ablNameForCheck) {
            return WyHelper.getFancyName(this.attr.getAttributeName()).equals(WyHelper.getFancyName(ablNameForCheck));
        }
    }
}

