/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities.extra;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class AbilityExplosion {
    private World worldObj;
    private Entity exploder;
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private double explosionSize;
    private String smokeParticles = "commonExplosion";
    private int explosionGrab = 16;
    public List affectedBlockPositions = new ArrayList();
    private boolean canStartFireAfterExplosion = false;
    private boolean canDestroyBlocks = true;
    private boolean canDropBlocksAfterExplosion = false;
    private boolean canDamageEntities = true;
    private boolean canDamageOwner = true;
    private boolean canProduceExplosionSound = true;

    public AbilityExplosion(Entity entity, double posX, double posY, double posZ, double power) {
        this.worldObj = entity.field_70170_p;
        this.exploder = entity;
        this.explosionSize = power;
        this.explosionX = posX;
        this.explosionY = posY;
        this.explosionZ = posZ;
    }

    public void setDamageOwner(boolean damageOwner) {
        this.canDamageOwner = damageOwner;
    }

    public void setDamageEntities(boolean damageEntities) {
        this.canDamageEntities = damageEntities;
    }

    public void setDropBlocksAfterExplosion(boolean canDrop) {
        this.canDropBlocksAfterExplosion = canDrop;
    }

    public void setFireAfterExplosion(boolean hasFire) {
        this.canStartFireAfterExplosion = hasFire;
    }

    public void setDestroyBlocks(boolean canDestroyBlocks) {
        this.canDestroyBlocks = canDestroyBlocks;
    }

    public void setSmokeParticles(String particle) {
        this.smokeParticles = particle;
    }

    public boolean hasSmokeParticles() {
        return !this.smokeParticles.isEmpty();
    }

    public void setExplosionSound(boolean hasSound) {
        this.canProduceExplosionSound = hasSound;
    }

    public void doExplosion() {
        HashSet<ChunkPosition> blocksData = new HashSet<ChunkPosition>();
        for (int i = 0; i < this.explosionGrab; ++i) {
            for (int j = 0; j < this.explosionGrab; ++j) {
                for (int k = 0; k < this.explosionGrab; ++k) {
                    if (i != 0 && i != this.explosionGrab - 1 && j != 0 && j != this.explosionGrab - 1 && k != 0 && k != this.explosionGrab - 1) continue;
                    double d0 = (float)i / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.explosionGrab - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double newExplosionPosX = this.explosionX;
                    double newExplosionPosY = this.explosionY;
                    double newExplosionPosZ = this.explosionZ;
                    float f2 = 0.3f;
                    for (double f1 = this.explosionSize * ((double)0.7f + this.worldObj.field_73012_v.nextDouble() * (double)0.6f); f1 > 0.0; f1 -= (double)(f2 * 0.75f)) {
                        int l1;
                        int k1;
                        int j1 = MathHelper.func_76128_c((double)newExplosionPosX);
                        Block block = this.worldObj.func_147439_a(j1, k1 = MathHelper.func_76128_c((double)newExplosionPosY), l1 = MathHelper.func_76128_c((double)newExplosionPosZ));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            float f3 = (float)((double)block.getExplosionResistance(this.exploder, this.worldObj, j1, k1, l1, this.explosionX, this.explosionY, this.explosionZ) / 1.25);
                            f1 -= (double)((f3 + 0.1f) * f2);
                        }
                        if (f1 > 0.0) {
                            blocksData.add(new ChunkPosition(j1, k1, l1));
                        }
                        newExplosionPosX += d0 * (double)f2;
                        newExplosionPosY += d1 * (double)f2;
                        newExplosionPosZ += d2 * (double)f2;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(blocksData);
        if (this.canProduceExplosionSound) {
            this.worldObj.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.canDamageEntities) {
            for (EntityLivingBase entity : WyHelper.getEntitiesNear((int)this.explosionX, (int)this.explosionY, (int)this.explosionZ, this.worldObj, this.explosionSize * 1.5, EntityLivingBase.class)) {
                if (!this.canDamageOwner && entity == this.exploder) continue;
                double newExplosionPosX = entity.field_70165_t - this.explosionX;
                double newExplosionPosY = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY;
                double newExplosionPosZ = entity.field_70161_v - this.explosionZ;
                Vec3 vec3 = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
                double d4 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / this.explosionSize;
                double d10 = this.worldObj.func_72842_a(vec3, entity.field_70121_D);
                double d11 = (1.0 - d4) * d10;
                float damage = (int)((d11 * d11 + d11) / 2.0 * 8.0 * this.explosionSize + 1.0);
                float damageMultiplier = 1.0f;
                if (this.exploder instanceof EntityLivingBase) {
                    DamageSource damageSource = DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.exploder));
                    damageMultiplier = ExtendedEntityData.get((EntityLivingBase)this.exploder).getDamageMultiplier();
                } else {
                    DamageSource damageSource = DamageSource.field_76376_m;
                }
                entity.func_70097_a(this.setExplosionSource(this), damage * damageMultiplier);
            }
        }
        if (this.canDestroyBlocks && MainConfig.enableGriefing) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                int posX = chunkposition.field_151329_a;
                int posY = chunkposition.field_151327_b;
                int posZ = chunkposition.field_151328_c;
                Block block = this.worldObj.func_147439_a(posX, posY, posZ);
                if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                block.func_149690_a(this.worldObj, posX, posY, posZ, this.worldObj.func_72805_g(posX, posY, posZ), 0.0f, 0);
                this.worldObj.func_147468_f(posX, posY, posZ);
            }
        }
        if (this.hasSmokeParticles()) {
            WyNetworkHelper.sendToAllAround(new PacketParticles(this.smokeParticles, this.explosionX, this.explosionY, this.explosionZ), this.exploder.field_71093_bK, this.explosionX, this.explosionY, this.explosionZ, 128.0);
        }
        if (this.canStartFireAfterExplosion && MainConfig.enableGriefing) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                int posX = chunkposition.field_151329_a;
                int posY = chunkposition.field_151327_b;
                int posZ = chunkposition.field_151328_c;
                Block block = this.worldObj.func_147439_a(posX, posY, posZ);
                Block blockUnder = this.worldObj.func_147439_a(posX, posY - 1, posZ);
                if (block.func_149688_o() != Material.field_151579_a || !blockUnder.func_149730_j() || this.worldObj.field_73012_v.nextInt(3) != 0) continue;
                this.worldObj.func_147449_b(posX, posY, posZ, (Block)Blocks.field_150480_ab);
            }
        }
    }

    public DamageSource setExplosionSource(AbilityExplosion explosion) {
        return explosion != null && explosion.exploder != null ? new EntityDamageSource("explosion.player", explosion.exploder).func_76351_m().func_94540_d() : new DamageSource("explosion").func_76351_m().func_94540_d();
    }
}

