/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.abilities.extra;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityManager;

public class AbilityProperties
implements IExtendedEntityProperties {
    public static final String EXT_ABILITYPROP_NAME = "mineminenomi_AbilityIEEP";
    private final EntityPlayer thePlayer;
    public Ability[] hotbarAbilities = new Ability[8];
    private Ability[] devilFruitAbilities = new Ability[32];
    private Ability[] racialAbilities = new Ability[32];
    private Ability[] styleAbilities = new Ability[32];
    private Ability[] hakiAbilities = new Ability[16];

    public AbilityProperties(EntityPlayer entity) {
        this.thePlayer = entity;
    }

    public static final void register(EntityPlayer entity) {
        entity.registerExtendedProperties(EXT_ABILITYPROP_NAME, (IExtendedEntityProperties)new AbilityProperties(entity));
    }

    public static final AbilityProperties get(EntityPlayer entity) {
        return (AbilityProperties)entity.getExtendedProperties(EXT_ABILITYPROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        int i;
        NBTTagCompound props = new NBTTagCompound();
        for (i = 0; i < this.hotbarAbilities.length; ++i) {
            if (this.hotbarAbilities[i] == null) continue;
            props.func_74782_a("hotbar_ability_" + i, (NBTBase)this.saveNLOBData(this.hotbarAbilities[i]));
        }
        for (i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null) continue;
            props.func_74782_a("devilfruits_ability_" + i, (NBTBase)this.saveNLOBData(this.devilFruitAbilities[i]));
        }
        for (i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] == null) continue;
            props.func_74782_a("racial_ability_" + i, (NBTBase)this.saveNLOBData(this.racialAbilities[i]));
        }
        for (i = 0; i < this.styleAbilities.length; ++i) {
            if (this.styleAbilities[i] == null) continue;
            props.func_74782_a("style_ability_" + i, (NBTBase)this.saveNLOBData(this.styleAbilities[i]));
        }
        for (i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] == null) continue;
            props.func_74782_a("haki_ability_" + i, (NBTBase)this.saveNLOBData(this.hakiAbilities[i]));
        }
        compound.func_74782_a(EXT_ABILITYPROP_NAME, (NBTBase)props);
    }

    private NBTTagCompound saveNLOBData(Ability abl) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("name", abl.getAttribute().getAttributeName());
        data.func_74757_a("isOnCooldown", abl.isOnCooldown());
        data.func_74757_a("isCharging", abl.isCharging());
        data.func_74757_a("isPassiveActive", abl.isPassiveActive());
        return data;
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(EXT_ABILITYPROP_NAME);
        try {
            int i;
            for (i = 0; i < this.hotbarAbilities.length; ++i) {
                this.hotbarAbilities[i] = this.loadAbilityFromNLOB((NBTTagCompound)props.func_74781_a("hotbar_ability_" + i));
            }
            for (i = 0; i < this.devilFruitAbilities.length; ++i) {
                this.devilFruitAbilities[i] = this.loadAbilityFromNLOB((NBTTagCompound)props.func_74781_a("devilfruits_ability_" + i));
            }
            for (i = 0; i < this.racialAbilities.length; ++i) {
                this.racialAbilities[i] = this.loadAbilityFromNLOB((NBTTagCompound)props.func_74781_a("racial_ability_" + i));
            }
            for (i = 0; i < this.styleAbilities.length; ++i) {
                this.styleAbilities[i] = this.loadAbilityFromNLOB((NBTTagCompound)props.func_74781_a("style_ability_" + i));
            }
            for (i = 0; i < this.hakiAbilities.length; ++i) {
                this.hakiAbilities[i] = this.loadAbilityFromNLOB((NBTTagCompound)props.func_74781_a("haki_ability_" + i));
            }
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "Ability is not registered correctly or could not be found in the master list !");
            e.printStackTrace();
        }
    }

    private Ability loadAbilityFromNLOB(NBTTagCompound props) {
        if (props == null) {
            return null;
        }
        String ablName = props.func_74779_i("name");
        Ability ability = null;
        try {
            if (AbilityManager.instance().getAbilityByName(WyHelper.getFancyName(ablName)) != null) {
                ability = (Ability)AbilityManager.instance().getAbilityByName(WyHelper.getFancyName(ablName)).getClass().newInstance();
                ability.setCooldownActive(props.func_74767_n("isOnCooldown"));
                ability.setChargeActive(props.func_74767_n("isCharging"));
                ability.setPassiveActive(props.func_74767_n("isPassiveActive"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ability;
    }

    public void init(Entity entity, World world) {
    }

    public boolean addDevilFruitAbility(Ability abl) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] != null || this.hasDevilFruitAbility(abl)) continue;
            this.devilFruitAbilities[i] = abl;
            return true;
        }
        return false;
    }

    public void removeDevilFruitAbility(Ability ablTemplate) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null || !this.devilFruitAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())) continue;
            this.devilFruitAbilities[i] = null;
            break;
        }
    }

    public boolean hasDevilFruitAbility(Ability ablTemplate) {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null || !this.devilFruitAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public Ability[] getDevilFruitAbilities() {
        return this.devilFruitAbilities;
    }

    public void clearDevilFruitAbilities() {
        for (int i = 0; i < this.devilFruitAbilities.length; ++i) {
            if (this.devilFruitAbilities[i] == null) continue;
            this.devilFruitAbilities[i] = null;
        }
    }

    public boolean addRacialAbility(Ability abl) {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] != null || this.hasRacialAbility(abl)) continue;
            this.racialAbilities[i] = abl;
            return true;
        }
        return false;
    }

    public void removeRacialAbility(Ability ablTemplate) {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] == null || !this.racialAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())) continue;
            this.racialAbilities[i] = null;
            break;
        }
    }

    public boolean hasRacialAbility(Ability ablTemplate) {
        if (ablTemplate != null) {
            for (int i = 0; i < this.racialAbilities.length; ++i) {
                if (this.racialAbilities[i] == null || !this.racialAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())) continue;
                return true;
            }
        }
        return false;
    }

    public Ability[] getRacialAbilities() {
        return this.racialAbilities;
    }

    public void clearRacialAbilities() {
        for (int i = 0; i < this.racialAbilities.length; ++i) {
            if (this.racialAbilities[i] == null) continue;
            this.racialAbilities[i] = null;
        }
    }

    public boolean addHakiAbility(Ability abl) {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] != null || this.hasHakiAbility(abl)) continue;
            this.hakiAbilities[i] = abl;
            return true;
        }
        return false;
    }

    public void removeHakiAbility(Ability ablTemplate) {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] == null || !this.hakiAbilities[i].getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())) continue;
            this.hakiAbilities[i] = null;
            break;
        }
    }

    public boolean hasHakiAbility(Ability ablTemplate) {
        return Arrays.stream(this.hakiAbilities).filter(x -> x != null && x.getAttribute().getAttributeName().equalsIgnoreCase(ablTemplate.getAttribute().getAttributeName())).findFirst().orElse(null) != null;
    }

    public Ability[] getHakiAbilities() {
        return this.hakiAbilities;
    }

    public void clearHakiAbilities() {
        for (int i = 0; i < this.hakiAbilities.length; ++i) {
            if (this.hakiAbilities[i] == null) continue;
            this.hakiAbilities[i] = null;
        }
    }

    public Ability[] getAbilitiesInHotbar() {
        return this.hotbarAbilities;
    }

    public boolean hasAbilityInHotbar(Ability ability) {
        return this.hasAbilityInHotbar(ability.getAttribute().getAttributeName());
    }

    public boolean hasAbilityInHotbar(String abilityName) {
        return Arrays.stream(this.hotbarAbilities).filter(x -> x != null && x.getAttribute().getAttributeName().equalsIgnoreCase(abilityName)).findFirst().orElse(null) != null;
    }

    public void setAbilityInSlot(int slot, Ability abl) {
        this.hotbarAbilities[slot] = abl;
    }

    public Ability getAbilityFromSlot(int slot) {
        return this.hotbarAbilities[slot];
    }

    public Ability getAbilityFromName(String name) {
        return Arrays.stream(this.getAbilitiesInHotbar()).filter(x -> x != null && x.getAttribute() != null && x.getAttribute().getAttributeName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public int countAbilitiesInHotbar() {
        return this.hotbarAbilities.length;
    }

    public void clearHotbar() {
        for (int i = 0; i < this.hotbarAbilities.length; ++i) {
            if (this.hotbarAbilities[i] == null) continue;
            if (this.hotbarAbilities[i].isPassiveActive()) {
                this.hotbarAbilities[i].endPassive(this.thePlayer);
            }
            this.hotbarAbilities[i] = null;
        }
    }
}

