/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.math;

import xyz.pixelatedw.MineMineNoMi3.api.math.ICircle;

public class Circle {
    public static void generate(int x0, int z0, int radius, ICircle callback) {
        int error = -radius;
        int x = radius;
        int z = 0;
        while (x >= z) {
            Circle.generateBlocks(x0, z0, x, z, callback);
            if (x != z) {
                Circle.generateBlocks(x0, z0, z, x, callback);
            }
            int lastZ = z;
            error += z;
            if ((error += ++z) < 0) continue;
            error -= x;
            error -= --x;
        }
    }

    public static void generateFilled(int x0, int z0, int radius, ICircle callback) {
        int error = -radius;
        int x = radius;
        int z = 0;
        while (x >= z) {
            Circle.generateLines(x0, z0, x, z, callback);
            if (x != z) {
                Circle.generateLines(x0, z0, z, x, callback);
            }
            error += z;
            if ((error += ++z) < 0) continue;
            error -= x;
            error -= --x;
        }
    }

    private static void generateBlocks(int x0, int z0, int x, int z, ICircle callback) {
        callback.call(x0 + x, z0 + z);
        if (x != 0) {
            callback.call(x0 - x, z0 + z);
        }
        if (z != 0) {
            callback.call(x0 + x, z0 - z);
        }
        if (x != 0 && z != 0) {
            callback.call(x0 - x, z0 - z);
        }
    }

    private static void generateLines(int x0, int z0, int x, int z, ICircle callback) {
        Circle.line(x0 - x, z0 + z, x0 + x, callback);
        if (x != 0 && z != 0) {
            Circle.line(x0 - x, z0 - z, x0 + x, callback);
        }
    }

    private static void line(int x0, int z0, int x1, ICircle callback) {
        for (int x = x0; x <= x1; ++x) {
            callback.call(x, z0);
        }
    }
}

