/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.quests;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestManager;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;

public class QuestProperties
implements IExtendedEntityProperties {
    public static final String EXT_QUESTPROP_NAME = "mineminenomi_QuestIEEP";
    private final EntityPlayer thePlayer;
    private boolean hasPrimaryActive = false;
    private Quest[] questsList = new Quest[4];
    private Quest[] completedQuests = new Quest[2048];

    public QuestProperties(EntityPlayer entity) {
        this.thePlayer = entity;
    }

    public static final void register(EntityPlayer entity) {
        entity.registerExtendedProperties(EXT_QUESTPROP_NAME, (IExtendedEntityProperties)new QuestProperties(entity));
    }

    public static final QuestProperties get(EntityPlayer entity) {
        return (QuestProperties)entity.getExtendedProperties(EXT_QUESTPROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        int i;
        NBTTagCompound props = new NBTTagCompound();
        props.func_74757_a("hasPrimaryActive", this.hasPrimaryActive);
        for (i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null) continue;
            props.func_74778_a("inProgressQuest_" + i, this.questsList[i].getQuestID());
            props.func_74780_a("progressForQuest_" + i, this.questsList[i].getProgress());
            if (this.questsList[i].extraData == null) continue;
            props.func_74782_a("extraData_" + i, (NBTBase)this.questsList[i].extraData);
        }
        for (i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] == null) continue;
            props.func_74778_a("completedQuest_" + i, this.completedQuests[i].getQuestID());
        }
        compound.func_74782_a(EXT_QUESTPROP_NAME, (NBTBase)props);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(EXT_QUESTPROP_NAME);
        this.hasPrimaryActive = props.func_74767_n("hasPrimaryActive");
        try {
            for (int j = 0; j < this.questsList.length; ++j) {
                Quest quest = this.questsList[j] = !props.func_74779_i("inProgressQuest_" + j).isEmpty() || QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, props.func_74779_i("inProgressQuest_" + j)) != null ? (Quest)QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, props.func_74779_i("inProgressQuest_" + j)).getClass().newInstance() : null;
                if (this.questsList[j] == null) continue;
                this.questsList[j].setProgress(this.thePlayer, props.func_74769_h("progressForQuest_" + j));
                this.questsList[j].extraData = (NBTTagCompound)props.func_74781_a("extraData_" + j);
            }
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "Quest is not registered correctly or could not be found in the master list !");
            e.printStackTrace();
        }
        for (int i = 0; i < this.completedQuests.length; ++i) {
            this.completedQuests[i] = !props.func_74779_i("completedQuest_" + i).isEmpty() || QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, props.func_74779_i("completedQuest_" + i)) != null ? QuestManager.instance().getQuestByNameFromList(ListQuests.allQuests, props.func_74779_i("completedQuest_" + i)) : null;
        }
    }

    public void init(Entity entity, World world) {
    }

    public boolean addQuestInTracker(Quest quest) {
        if (quest.isPrimary() && !this.hasPrimaryActive || !quest.isPrimary()) {
            for (int i = 0; i < this.questsList.length; ++i) {
                if (this.questsList[i] != null || this.hasQuestInTracker(quest)) continue;
                if (quest.isPrimary()) {
                    this.hasPrimaryActive = true;
                }
                this.questsList[i] = quest;
                return true;
            }
        }
        return false;
    }

    public boolean addCompletedQuest(Quest quest) {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] != null || this.hasQuestCompleted(quest)) continue;
            this.completedQuests[i] = quest;
            return true;
        }
        return false;
    }

    public void removeQuestFromTracker(Quest questTemplate) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(questTemplate.getQuestID().toLowerCase())) continue;
            if (questTemplate.isPrimary()) {
                this.hasPrimaryActive = false;
            }
            this.questsList[i] = null;
            break;
        }
    }

    public boolean hasQuestInTracker(Quest questTemplate) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(questTemplate.getQuestID().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean hasQuestCompleted(Quest questTemplate) {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] == null || !this.completedQuests[i].getQuestID().toLowerCase().equals(questTemplate.getQuestID().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public Quest getQuestFromTracker(Quest questTemplate) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(questTemplate.getQuestID().toLowerCase())) continue;
            return this.questsList[i];
        }
        return null;
    }

    public Quest getQuestIndexFromTracker(int index) {
        if (this.questsList[index] != null) {
            return this.questsList[index];
        }
        return null;
    }

    public Quest getPrimaryQuestFromTracker() {
        if (this.hasPrimaryActive) {
            for (int i = 0; i < this.questsList.length; ++i) {
                if (this.questsList[i] == null || !this.questsList[i].isPrimary()) continue;
                return this.questsList[i];
            }
        }
        return null;
    }

    public void alterQuestProgress(Quest questTemplate, double progress) {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null || !this.questsList[i].getQuestID().toLowerCase().equals(questTemplate.getQuestID().toLowerCase())) continue;
            this.questsList[i].alterProgress(this.thePlayer, progress);
            break;
        }
    }

    public boolean hasPrimary() {
        return this.hasPrimaryActive;
    }

    public int questsInProgress() {
        int inProgress = 0;
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null) continue;
            ++inProgress;
        }
        return inProgress;
    }

    public void clearQuestTracker() {
        for (int i = 0; i < this.questsList.length; ++i) {
            if (this.questsList[i] == null) continue;
            if (this.questsList[i].isPrimary()) {
                this.hasPrimaryActive = false;
            }
            this.questsList[i] = null;
        }
    }

    public void clearCompletedQuests() {
        for (int i = 0; i < this.completedQuests.length; ++i) {
            if (this.completedQuests[i] == null) continue;
            this.completedQuests[i] = null;
        }
    }
}

