/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.api.telemetry;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;

public class WyTelemetry {
    private static StatDataCompound structuresDataCompound = new StatDataCompound();
    private static StatDataCompound killsDataCompound = new StatDataCompound();
    private static StatDataCompound abilitiesDataCompound = new StatDataCompound();
    private static StatDataCompound miscDataCompound = new StatDataCompound();
    private static StatDataCompound devilFruitsDataCompound = new StatDataCompound();

    public static void addStructureStat(String id, String name, int value) {
        structuresDataCompound.put(id, name, value);
    }

    public static void addKillStat(String id, String name, int value) {
        killsDataCompound.put(id, name, value);
    }

    public static void addAbilityStat(String id, String name, int value) {
        abilitiesDataCompound.put(id, name, value);
    }

    public static void addMiscStat(String id, String name, int value) {
        miscDataCompound.put(id, name, value);
    }

    public static void addDevilFruitStat(String id, String name, int value) {
        devilFruitsDataCompound.put(id, name, value);
    }

    public static void sendAllData() {
        Thread httpThread = new Thread(){

            @Override
            public void run() {
                Object[][] paths;
                for (Object[] o : paths = new Object[][]{{"/stats/structure", structuresDataCompound}, {"/stats/kill", killsDataCompound}, {"/stats/ability", abilitiesDataCompound}, {"/stats/misc", miscDataCompound}, {"/stats/devil-fruit", devilFruitsDataCompound}}) {
                    String apiURL = (String)o[0];
                    StatDataCompound compound = (StatDataCompound)o[1];
                    if (compound.data.isEmpty()) continue;
                    String json = Values.gson.toJson((Object)compound);
                    String result = WyTelemetry.sendPOST(apiURL, json);
                    WyDebug.debug("Path: " + apiURL + "Result: " + (result.isEmpty() ? "Success" : result));
                    compound.empty();
                }
            }
        };
        httpThread.setName("Mine Mine no Mi - Stats POST");
        httpThread.start();
    }

    public static void sendAllDataSync() {
        Object[][] paths;
        for (Object[] o : paths = new Object[][]{{"/stats/structure", structuresDataCompound}, {"/stats/kill", killsDataCompound}, {"/stats/ability", abilitiesDataCompound}, {"/stats/misc", miscDataCompound}, {"/stats/devil-fruit", devilFruitsDataCompound}}) {
            String apiURL = (String)o[0];
            StatDataCompound compound = (StatDataCompound)o[1];
            if (compound.data.isEmpty()) continue;
            String json = Values.gson.toJson((Object)compound);
            String result = WyTelemetry.sendPOST(apiURL, json);
            WyDebug.debug("Path: " + apiURL + "Result: " + (result.isEmpty() ? "Success" : result));
            compound.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPOST(String sendUrl, String object) {
        BufferedReader reader = null;
        String result = "";
        try {
            String json = object;
            URL url = new URL(Values.urlConnection + "" + sendUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.connect();
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(json);
            writer.flush();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            result = stringBuilder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String sendGET(String sendUrl) {
        String result = "";
        try {
            URL url = new URL(Values.urlConnection + "" + sendUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                result = response.toString();
            } else {
                WyDebug.error("GET Request failed!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void debugJSON(StatDataCompound compound) {
        String json = Values.gson.toJson((Object)compound);
        String size = WyHelper.formatBytes(json.getBytes().length);
        WyDebug.debug("\n JSON: " + json + "\n Size: " + size);
    }

    private static class StatData {
        private String name;
        private int value;

        public StatData(String name, int value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class StatDataCompound {
        private String mcVersion = "1.7.10";
        private String modVersion = "0.6.1";
        private int source = 0;
        private HashMap<String, StatData> data = new HashMap();

        public void put(String id, String name, int value) {
            if (this.data.containsKey(id)) {
                StatData statData = this.data.get(id);
                statData.value = statData.value + value;
            } else {
                StatData newData = new StatData(name, value);
                this.data.put(id, newData);
            }
        }

        public void empty() {
            this.data = new HashMap();
        }
    }
}

