/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.data;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedEntityData
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "IEEPShared";
    private final EntityLivingBase entity;
    private boolean isInCombatMode = false;
    private int doriki;
    private int dorikiCmd;
    private int belly;
    private int bellyCmd;
    private int extol;
    private int extolCmd;
    private int cola = 100;
    private int maxCola = 100;
    private int hakiTimer = 0;
    private int ultraCola = 0;
    private int gear = 1;
    private long bounty;
    private long bountyCmd;
    private String akumaNoMiUsed = "n/a";
    private String faction = "n/a";
    private String race = "n/a";
    private String fightStyle = "n/a";
    private String crew = "n/a";
    private String zoanPoint = "n/a";
    private boolean isLogia;
    private boolean hasShadow = true;
    private boolean hasHeart = true;
    private boolean firstTime = true;
    private boolean hasHakiActive = false;
    private boolean hasBusoHakiActive = false;
    private boolean hasKenHakiActive = false;
    private boolean kilo = false;
    private boolean hasYamiPower = false;
    private boolean hasColaBackpack = false;
    private boolean isInAirWorld = false;
    private float damageMultiplier = 1.0f;
    private String tempPreviousAbility = "";
    private int punchBusoExp;
    private int itemBusoExp;
    private int kenExp;
    private int haoExp;
    private String[] extraEffects = new String[32];

    public ExtendedEntityData(EntityLivingBase entity) {
        this.entity = entity;
    }

    public static final void register(EntityLivingBase entity) {
        entity.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedEntityData(entity));
    }

    public static final ExtendedEntityData get(EntityLivingBase entity) {
        return (ExtendedEntityData)entity.getExtendedProperties(EXT_PROP_NAME);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound props = new NBTTagCompound();
        props.func_74768_a("Doriki", this.doriki);
        props.func_74768_a("DorikiCmd", this.dorikiCmd);
        props.func_74768_a("Belly", this.belly);
        props.func_74768_a("BellyCmd", this.bellyCmd);
        props.func_74768_a("Extol", this.extol);
        props.func_74768_a("ExtolCmd", this.extolCmd);
        props.func_74768_a("Cola", this.cola);
        props.func_74768_a("MaxCola", this.maxCola);
        props.func_74768_a("UltraCola", this.ultraCola);
        props.func_74768_a("Gear", this.gear);
        props.func_74776_a("DamageMultiplier", this.damageMultiplier);
        props.func_74772_a("Bounty", this.bounty);
        props.func_74772_a("BountyCmd", this.bountyCmd);
        props.func_74778_a("AkumaNoMi", this.akumaNoMiUsed);
        props.func_74778_a("Faction", this.faction);
        props.func_74778_a("Race", this.race);
        props.func_74778_a("FightStyle", this.fightStyle);
        props.func_74778_a("Crew", this.crew);
        props.func_74778_a("ZoanPoint", this.zoanPoint);
        props.func_74757_a("isLogia", this.isLogia);
        props.func_74757_a("hasShadow", this.hasShadow);
        props.func_74757_a("hasHeart", this.hasHeart);
        props.func_74757_a("firstTime", this.firstTime);
        props.func_74757_a("hasKiloActive", this.kilo);
        props.func_74757_a("hasHakiActive", this.hasHakiActive);
        props.func_74757_a("hasBusoHakiActive", this.hasBusoHakiActive);
        props.func_74757_a("hasKenHakiActive", this.hasKenHakiActive);
        props.func_74757_a("hasYamiPower", this.hasYamiPower);
        props.func_74757_a("hasColaBackpack", this.hasColaBackpack);
        props.func_74757_a("isInAirWorld", this.isInAirWorld);
        props.func_74757_a("isInCombatMode", this.isInCombatMode);
        props.func_74768_a("PunchBusoExp", this.punchBusoExp);
        props.func_74768_a("ItemBusoExp", this.itemBusoExp);
        props.func_74768_a("KenExp", this.kenExp);
        props.func_74768_a("HaoExp", this.haoExp);
        for (int i = 0; i < this.extraEffects.length; ++i) {
            if (this.extraEffects[i] == null || this.extraEffects[i].isEmpty()) continue;
            props.func_74778_a("extraEffect_" + i, this.extraEffects[i]);
        }
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)props);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound props = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.doriki = props.func_74762_e("Doriki");
        this.dorikiCmd = props.func_74762_e("DorikiCmd");
        this.belly = props.func_74762_e("Belly");
        this.bellyCmd = props.func_74762_e("BellyCmd");
        this.extol = props.func_74762_e("Extol");
        this.extolCmd = props.func_74762_e("ExtolCmd");
        this.cola = props.func_74762_e("Cola");
        this.maxCola = props.func_74762_e("MaxCola");
        this.ultraCola = props.func_74762_e("UltraCola");
        this.gear = props.func_74762_e("Gear");
        this.damageMultiplier = props.func_74760_g("DamageMultiplier");
        this.bounty = props.func_74763_f("Bounty");
        this.bountyCmd = props.func_74763_f("BountyCmd");
        this.akumaNoMiUsed = props.func_74779_i("AkumaNoMi");
        this.faction = props.func_74779_i("Faction");
        this.race = props.func_74779_i("Race");
        this.fightStyle = props.func_74779_i("FightStyle");
        this.crew = props.func_74779_i("Crew");
        this.zoanPoint = props.func_74779_i("ZoanPoint");
        this.isLogia = props.func_74767_n("isLogia");
        this.hasShadow = props.func_74767_n("hasShadow");
        this.hasHeart = props.func_74767_n("hasHeart");
        this.firstTime = props.func_74767_n("firstTime");
        this.kilo = props.func_74767_n("hasKiloActive");
        this.hasHakiActive = props.func_74767_n("hasHakiActive");
        this.hasBusoHakiActive = props.func_74767_n("hasBusoHakiActive");
        this.hasKenHakiActive = props.func_74767_n("hasKenHakiActive");
        this.hasYamiPower = props.func_74767_n("hasYamiPower");
        this.hasColaBackpack = props.func_74767_n("hasColaBackpack");
        this.isInAirWorld = props.func_74767_n("isInAirWorld");
        this.isInCombatMode = props.func_74767_n("isInCombatMode");
        this.punchBusoExp = props.func_74762_e("PunchBusoExp");
        this.itemBusoExp = props.func_74762_e("ItemBusoExp");
        this.kenExp = props.func_74762_e("KenExp");
        this.haoExp = props.func_74762_e("HaoExp");
        for (int i = 0; i < this.extraEffects.length; ++i) {
            this.extraEffects[i] = props.func_74779_i("extraEffect_" + i);
        }
    }

    public void init(Entity entity, World world) {
    }

    public int getKingHakiExp() {
        return this.haoExp;
    }

    public void addKingHakiExp(int i) {
        if (this.haoExp + i >= 1000) {
            return;
        }
        this.haoExp = this.haoExp + i < 0 ? 0 : (this.haoExp += i);
    }

    public int getObservationHakiExp() {
        return this.kenExp;
    }

    public void addObservationHakiExp(int i) {
        if (this.kenExp + i >= 1000) {
            return;
        }
        this.kenExp = this.kenExp + i < 0 ? 0 : (this.kenExp += i);
    }

    public int getImbuingHakiExp() {
        return this.itemBusoExp;
    }

    public void addImbuingHakiExp(int i) {
        if (this.itemBusoExp + i >= 1000) {
            return;
        }
        this.itemBusoExp = this.itemBusoExp + i < 0 ? 0 : (this.itemBusoExp += i);
    }

    public int getHardeningHakiExp() {
        return this.punchBusoExp;
    }

    public void addHardeningHakiExp(int i) {
        if (this.punchBusoExp + i >= 1000) {
            return;
        }
        this.punchBusoExp = this.punchBusoExp + i < 0 ? 0 : (this.punchBusoExp += i);
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public void setDamageMultiplier(float i) {
        this.damageMultiplier = i;
    }

    public void setCombatMode(boolean value) {
        this.isInCombatMode = value;
    }

    public boolean isInCombatMode() {
        return this.isInCombatMode;
    }

    public int getDoriki() {
        return this.doriki;
    }

    public void alterDoriki(int i) {
        this.doriki = this.doriki + i < 0 ? 0 : (this.doriki += i);
    }

    public void setDoriki(int i) {
        this.doriki = i;
    }

    public int getDorikiFromCommand() {
        return this.dorikiCmd;
    }

    public void alterDorikiFromCommand(int i) {
        this.dorikiCmd = this.dorikiCmd + i < 0 ? 0 : (this.dorikiCmd += i);
    }

    public void setDorikiFromCommand(int i) {
        this.dorikiCmd = i;
    }

    public int getExtol() {
        return this.extol;
    }

    public void alterExtol(int i) {
        this.extol = this.extol + i < 0 ? 0 : (this.extol += i);
    }

    public void setExtol(int i) {
        this.extol = i;
    }

    public int getExtolFromCommand() {
        return this.extolCmd;
    }

    public void alterExtolFromCommand(int i) {
        this.extolCmd = this.extolCmd + i < 0 ? 0 : (this.extolCmd += i);
    }

    public void setExtolFromCommand(int i) {
        this.extolCmd = i;
    }

    public int getBelly() {
        return this.belly;
    }

    public void alterBelly(int i) {
        this.belly = this.belly + i < 0 ? 0 : (this.belly += i);
    }

    public void setBelly(int i) {
        this.belly = i;
    }

    public int getBellyFromCommand() {
        return this.bellyCmd;
    }

    public void alterBellyFromCommand(int i) {
        this.bellyCmd = this.bellyCmd + i < 0 ? 0 : (this.bellyCmd += i);
    }

    public void setBellyFromCommand(int i) {
        this.bellyCmd = i;
    }

    public long getBounty() {
        return this.bounty;
    }

    public void alterBounty(long i) {
        this.bounty = this.bounty + i < 0L ? 0L : (this.bounty += i);
    }

    public void setBounty(long i) {
        this.bounty = i;
    }

    public long getBountyFromCommand() {
        return this.bountyCmd;
    }

    public void alterBountyFromCommand(long i) {
        this.bountyCmd = this.bountyCmd + i < 0L ? 0L : (this.bountyCmd += i);
    }

    public void setBountyFromCommand(long i) {
        this.bountyCmd = i;
    }

    public int getCola() {
        return this.cola;
    }

    public void alterCola(int i) {
        this.cola = this.cola + i < 0 ? 0 : (this.cola + i > this.getMaxCola() ? this.getMaxCola() : (this.cola += i));
    }

    public void setCola(int i) {
        this.cola = i;
    }

    public int getUltraColaConsumed() {
        return this.ultraCola;
    }

    public void setUltraCola(int i) {
        this.ultraCola = i;
    }

    public void addUltraCola() {
        ++this.ultraCola;
    }

    public int getMaxCola() {
        return this.maxCola;
    }

    public void setMaxCola(int maxCola) {
        this.maxCola = maxCola;
    }

    public boolean isLogia() {
        return this.isLogia;
    }

    public void setIsLogia(boolean i) {
        this.isLogia = i;
    }

    public String getUsedFruit() {
        return this.akumaNoMiUsed;
    }

    public boolean hasDevilFruit() {
        return !this.akumaNoMiUsed.isEmpty() && !this.akumaNoMiUsed.equalsIgnoreCase("n/a");
    }

    public void setUsedFruit(String name) {
        this.akumaNoMiUsed = name;
    }

    public boolean hasHeart() {
        return this.hasHeart;
    }

    public void setHasHeart(boolean b) {
        this.hasHeart = b;
    }

    public boolean hasShadow() {
        return this.hasShadow;
    }

    public void setHasShadow(boolean b) {
        this.hasShadow = b;
    }

    public void setGear(int i) {
        this.gear = i;
    }

    public int getGear() {
        return this.gear;
    }

    public String getFightStyle() {
        return this.fightStyle;
    }

    public boolean isSwordsman() {
        return this.fightStyle.equalsIgnoreCase("swordsman");
    }

    public boolean isSniper() {
        return this.fightStyle.equalsIgnoreCase("sniper");
    }

    public boolean isMedic() {
        return this.fightStyle.equalsIgnoreCase("doctor");
    }

    public boolean isWeatherWizard() {
        return this.fightStyle.equalsIgnoreCase("art of weather");
    }

    public boolean hasFightingStyle() {
        return !this.fightStyle.equalsIgnoreCase("n/a");
    }

    public void setFightStyle(String i) {
        this.fightStyle = i;
    }

    public String getRace() {
        return this.race;
    }

    public boolean isHuman() {
        return this.race.equalsIgnoreCase("human");
    }

    public boolean isFishman() {
        return this.race.equalsIgnoreCase("fishman");
    }

    public boolean isCyborg() {
        return this.race.equalsIgnoreCase("cyborg");
    }

    public boolean hasRace() {
        return !this.race.equalsIgnoreCase("n/a");
    }

    public void setRace(String i) {
        this.race = i;
    }

    public String getFaction() {
        return this.faction;
    }

    public boolean isPirate() {
        return this.faction.equalsIgnoreCase("pirate");
    }

    public boolean isMarine() {
        return this.faction.equalsIgnoreCase("marine");
    }

    public boolean isBountyHunter() {
        return this.faction.equalsIgnoreCase("bountyhunter");
    }

    public boolean isRevolutionary() {
        return this.faction.equalsIgnoreCase("revolutionary");
    }

    public boolean hasFaction() {
        return !this.faction.equalsIgnoreCase("n/a");
    }

    public void setFaction(String i) {
        this.faction = i;
    }

    public String getCrew() {
        return this.crew;
    }

    public void setCrew(String crewName) {
        this.crew = crewName;
    }

    public String getZoanPoint() {
        return this.zoanPoint;
    }

    public void setZoanPoint(String i) {
        this.zoanPoint = i;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean firstTime) {
        this.firstTime = firstTime;
    }

    public void firstTimePass() {
        this.firstTime = false;
    }

    public boolean hasBusoHakiActive() {
        return this.hasBusoHakiActive;
    }

    public void triggerBusoHaki(boolean isBusoHakiActive) {
        this.hasBusoHakiActive = isBusoHakiActive;
    }

    public boolean hasKenHakiActive() {
        return this.hasKenHakiActive;
    }

    public void triggerKenHaki(boolean isKenHakiActive) {
        this.hasKenHakiActive = isKenHakiActive;
    }

    public boolean hasHakiActive() {
        return this.hasHakiActive;
    }

    public void triggerActiveHaki(boolean isHakiActive) {
        this.hasHakiActive = isHakiActive;
    }

    public int getHakiTimer() {
        return this.hakiTimer;
    }

    public void addHakiTimer() {
        ++this.hakiTimer;
    }

    public void decHakiTimer() {
        --this.hakiTimer;
    }

    public void resetHakiTimer() {
        this.hakiTimer = 0;
    }

    public void setKilo(boolean kilo) {
        this.kilo = kilo;
    }

    public boolean getKilo() {
        return this.kilo;
    }

    public void setYamiPower(boolean bool) {
        this.hasYamiPower = bool;
    }

    public boolean hasYamiPower() {
        return this.hasYamiPower;
    }

    public void setColaBackpack(boolean bool) {
        this.hasColaBackpack = bool;
    }

    public boolean hasColaBackpack() {
        return this.hasColaBackpack;
    }

    public void setInAirWorld(boolean value) {
        this.isInAirWorld = value;
    }

    public boolean isInAirWorld() {
        return this.isInAirWorld;
    }

    public void setTempPreviousAbility(String temp) {
        this.tempPreviousAbility = temp;
    }

    public String getTempPreviousAbility() {
        return this.tempPreviousAbility;
    }

    public boolean addExtraEffect(String eff) {
        for (int i = 0; i < this.extraEffects.length; ++i) {
            if (this.extraEffects[i] != null && !this.extraEffects[i].isEmpty()) continue;
            this.extraEffects[i] = eff;
            return true;
        }
        return false;
    }

    public void removeExtraEffects(String eff) {
        for (int i = 0; i < this.extraEffects.length; ++i) {
            if (this.extraEffects[i] == null || this.extraEffects[i].isEmpty()) continue;
            this.extraEffects[i] = null;
            break;
        }
    }

    public boolean hasExtraEffects(String eff) {
        for (int i = 0; i < this.extraEffects.length; ++i) {
            if (this.extraEffects[i] == null || this.extraEffects[i].isEmpty() || !this.extraEffects[i].equalsIgnoreCase(eff)) continue;
            return true;
        }
        return false;
    }

    public String[] getExtraEffects() {
        return this.extraEffects;
    }
}

