/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;

public class ExtendedWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi";
    private boolean isSwordsmanDojoSpawned = false;
    private int totalDojosSpawned;
    private HashMap<String, Long> issuedBounties = new HashMap();
    private List<String> devilFruitsInWorld = new ArrayList<String>();
    private List<int[][]> protectedAreas = new ArrayList<int[][]>();

    public ExtendedWorldData() {
        super(IDENTIFIER);
    }

    public ExtendedWorldData(String identifier) {
        super(identifier);
    }

    public static ExtendedWorldData get(World world) {
        ExtendedWorldData data = (ExtendedWorldData)world.func_72943_a(ExtendedWorldData.class, IDENTIFIER);
        if (data == null) {
            data = new ExtendedWorldData();
            world.func_72823_a(IDENTIFIER, (WorldSavedData)data);
        }
        return data;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.isSwordsmanDojoSpawned = nbt.func_74767_n("isSwordsmanDojoSpawned");
        this.totalDojosSpawned = nbt.func_74762_e("totalDojosSpawned");
        NBTTagCompound bounties = nbt.func_74775_l("issuedBounties");
        this.issuedBounties.clear();
        bounties.func_150296_c().stream().forEach(x -> this.issuedBounties.put((String)x, bounties.func_74763_f((String)x)));
        NBTTagCompound devilFruits = nbt.func_74775_l("devilFruits");
        this.devilFruitsInWorld.clear();
        devilFruits.func_150296_c().stream().forEach(x -> this.devilFruitsInWorld.add((String)x));
        NBTTagCompound protectedAreas = nbt.func_74775_l("protectedAreas");
        this.protectedAreas.clear();
        for (int i = 0; i <= protectedAreas.func_150296_c().size(); ++i) {
            int[] minPos = protectedAreas.func_74759_k("minPos_" + i);
            int[] maxPos = protectedAreas.func_74759_k("maxPos_" + i);
            this.protectedAreas.add(new int[][]{minPos, maxPos});
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74757_a("isSwordsmanDojoSpawned", this.isSwordsmanDojoSpawned);
        nbt.func_74768_a("totalDojosSpawned", this.totalDojosSpawned);
        NBTTagCompound bounties = new NBTTagCompound();
        if (this.issuedBounties.size() > 0) {
            this.issuedBounties.entrySet().stream().forEach(x -> bounties.func_74772_a((String)x.getKey(), ((Long)x.getValue()).longValue()));
        }
        nbt.func_74782_a("issuedBounties", (NBTBase)bounties);
        NBTTagCompound devilFruits = new NBTTagCompound();
        if (this.devilFruitsInWorld.size() > 0) {
            this.devilFruitsInWorld.stream().forEach(x -> devilFruits.func_74757_a(x, true));
        }
        nbt.func_74782_a("devilFruits", (NBTBase)devilFruits);
        NBTTagCompound protectedAreas = new NBTTagCompound();
        if (this.protectedAreas.size() > 0) {
            int i = 0;
            for (int[][] area : this.protectedAreas) {
                protectedAreas.func_74783_a("minPos_" + i, area[0]);
                protectedAreas.func_74783_a("maxPos_" + i, area[1]);
                ++i;
            }
        }
        nbt.func_74782_a("protectedAreas", (NBTBase)protectedAreas);
    }

    public boolean isInsideRestrictedArea(int posX, int posY, int posZ) {
        if (this.protectedAreas.size() <= 0) {
            return false;
        }
        for (int[][] area : this.protectedAreas) {
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0 || posX <= minPos[0] || posX >= maxPos[0] || posY <= minPos[1] || posY >= maxPos[1] || posZ <= minPos[2] || posZ >= maxPos[2]) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedArea(int[] minPos, int[] maxPos) {
        this.protectedAreas.add(new int[][]{minPos, maxPos});
        this.func_76185_a();
    }

    public void removeRestrictedArea(int midX, int midY, int midZ) {
        Iterator<int[][]> iterator = this.protectedAreas.iterator();
        while (iterator.hasNext()) {
            int[][] area = iterator.next();
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0) continue;
            int possibleMidX = (minPos[0] + maxPos[0]) / 2;
            int possibleMidY = (minPos[1] + maxPos[1]) / 2;
            int possibleMidZ = (minPos[2] + maxPos[2]) / 2;
            if (midX != possibleMidX || midY != possibleMidY || midZ != possibleMidZ) continue;
            iterator.remove();
        }
        this.func_76185_a();
    }

    public List<int[][]> getAllRestrictions() {
        return this.protectedAreas;
    }

    public HashMap<String, Long> getAllBounties() {
        return this.issuedBounties;
    }

    public long getBounty(String name) {
        if (this.issuedBounties.containsKey(name.toLowerCase())) {
            return this.issuedBounties.get(name.toLowerCase());
        }
        return 0L;
    }

    public void issueBounty(String name, long bounty) {
        if (this.issuedBounties.containsKey(name.toLowerCase())) {
            this.issuedBounties.remove(name.toLowerCase());
            this.issuedBounties.put(name.toLowerCase(), bounty);
        } else {
            this.issuedBounties.put(name.toLowerCase(), bounty);
        }
        this.func_76185_a();
    }

    public int getTotalDojosSpawned() {
        return this.totalDojosSpawned;
    }

    public void countUpDojoSpawned() {
        ++this.totalDojosSpawned;
        if (this.totalDojosSpawned >= MainConfig.maxDojoSpawn) {
            this.setSwordsmanDojoSpawned(true);
        }
        this.func_76185_a();
    }

    public void setDojoSpawned(int value) {
        this.totalDojosSpawned = value;
        if (this.totalDojosSpawned >= MainConfig.maxDojoSpawn) {
            this.setSwordsmanDojoSpawned(true);
        }
        this.func_76185_a();
    }

    public boolean isSwordsmanDojoSpawned() {
        return this.isSwordsmanDojoSpawned;
    }

    public void setSwordsmanDojoSpawned(boolean value) {
        this.isSwordsmanDojoSpawned = value;
        this.func_76185_a();
    }

    public List<String> getDevilFruitsInWorld() {
        return this.devilFruitsInWorld;
    }

    public void removeDevilFruitFromWorld(AkumaNoMi fruit) {
        String name = fruit.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", "");
        if (this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.remove(name);
            this.func_76185_a();
        }
    }

    public void removeDevilFruitFromWorld(String name) {
        if (this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.remove(name);
            this.func_76185_a();
        }
    }

    public void addDevilFruitInWorld(AkumaNoMi fruit) {
        String name = fruit.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", "");
        if (!this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.add(name);
            this.func_76185_a();
        }
    }

    public void addDevilFruitInWorld(String name) {
        if (!this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.add(name);
            this.func_76185_a();
        }
    }

    public boolean isDevilFruitInWorld(String name) {
        return this.devilFruitsInWorld.contains(name);
    }
}

