/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.entities.mobs;

import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.IDynamicRenderer;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.INBTEntity;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.ai.abilities.rokushiki.EntityAIGeppo;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.ai.abilities.rokushiki.EntityAIRankyaku;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.ai.abilities.rokushiki.EntityAISoru;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.ai.abilities.rokushiki.EntityAITekkai;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketEntityNBTSync;

public class EntityNewMob
extends EntityMob
implements IDynamicRenderer,
INBTEntity {
    protected String[] textures;
    private int doriki;
    private int belly;
    private int textureId;
    private int state;
    private boolean hasBusoHaki;
    private EntityAIBase currentAI;
    private EntityAIBase previousAI;
    protected int threat;

    public EntityNewMob(World worldIn) {
        this(worldIn, null);
    }

    public EntityNewMob(World worldIn, String[] textures) {
        super(worldIn);
        this.func_82164_bB();
        this.textures = textures;
    }

    protected void func_82164_bB() {
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        super.func_110161_a(data);
        this.func_82164_bB();
        if (this.textures != null && this.textures.length > 0) {
            this.setTexture(this.field_70146_Z.nextInt(this.textures.length));
        }
        return data;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)this.textureId);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Texture", this.getTextureId());
        nbt.func_74768_a("Doriki", this.doriki);
        nbt.func_74768_a("Belly", this.belly);
        nbt.func_74757_a("HasBusoHaki", this.hasBusoHaki);
    }

    @Override
    public void readEntityFromExtraNBT(NBTTagCompound nbt) {
        this.func_70037_a(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74762_e("Texture"));
        this.doriki = nbt.func_74762_e("Doriki");
        this.belly = nbt.func_74762_e("Belly");
        this.hasBusoHaki = nbt.func_74767_n("HasBusoHaki");
    }

    public void updateNBT() {
        NBTTagCompound nbtClone = new NBTTagCompound();
        this.func_70014_b(nbtClone);
        if (!this.field_70170_p.field_72995_K) {
            WyNetworkHelper.sendToAll(new PacketEntityNBTSync(this.func_145782_y(), nbtClone));
        }
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public String getTexture() {
        return this.textures[this.getTextureId()];
    }

    public int getTextureId() {
        return this.field_70180_af.func_75679_c(15);
    }

    protected void setTexture(int texture) {
        this.field_70180_af.func_75692_b(15, (Object)texture);
    }

    public int getDoriki() {
        return this.doriki;
    }

    public void setDoriki(int value) {
        this.doriki = value;
    }

    public int getBelly() {
        return this.belly;
    }

    public void setBelly(int value) {
        this.belly = value;
    }

    public boolean hasBusoHaki() {
        return this.hasBusoHaki;
    }

    public void setBusoHaki(boolean value) {
        this.hasBusoHaki = value;
    }

    public EntityAIBase getCurrentAI() {
        return this.currentAI;
    }

    public EntityAIBase getPreviousAI() {
        return this.previousAI;
    }

    public void setCurrentAI(EntityAIBase ai) {
        this.currentAI = ai;
    }

    public void setPreviousAI(EntityAIBase ai) {
        this.previousAI = ai;
    }

    public void addRokushikiAbilities(int max) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int rokushikiCount = 0;
        boolean hasSoru = false;
        boolean hasTekkai = false;
        boolean hasRankyaku = false;
        boolean hasGeppo = false;
        while (rokushikiCount < max) {
            if (!hasSoru && WyMathHelper.randomWithRange(1, 10) >= 8.0) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISoru(this));
                this.threat += 2;
                ++rokushikiCount;
                hasSoru = true;
                continue;
            }
            if (!hasTekkai && WyMathHelper.randomWithRange(1, 10) >= 8.0) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITekkai(this));
                this.threat += 5;
                ++rokushikiCount;
                hasTekkai = true;
                continue;
            }
            if (!hasRankyaku && WyMathHelper.randomWithRange(1, 10) >= 5.0) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRankyaku(this));
                this.threat += 20;
                ++rokushikiCount;
                hasRankyaku = true;
                continue;
            }
            if (!hasGeppo && WyMathHelper.randomWithRange(1, 10) >= 5.0) {
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGeppo(this));
                this.threat += 10;
                ++rokushikiCount;
                hasGeppo = true;
                continue;
            }
            ++rokushikiCount;
        }
        if (WyDebug.isDebug()) {
            System.out.println("Soru : " + hasSoru);
            System.out.println("Tekkai : " + hasTekkai);
            System.out.println("Rankyaku : " + hasRankyaku);
            System.out.println("Geppo : " + hasGeppo);
        }
    }

    @Override
    public String getMobTexture() {
        return this.getTexture();
    }

    @Override
    public double[] itemOffset() {
        return new double[]{0.0, 0.0, 0.0};
    }

    @Override
    public double[] itemScale() {
        return new double[]{1.0, 1.0, 1.0};
    }
}

