/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.entities.mobs.animals;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.EnumParticleTypes;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.INBTEntity;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketEntityNBTSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketParticles;

public class EntityKungFuDugong
extends EntityMob
implements INBTEntity,
IEntityOwnable {
    private Item[] food = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_151101_aQ, Items.field_151157_am};
    private boolean isHappy;
    private boolean isTamed;
    private boolean isWaiting;
    private boolean isEnraged;
    private boolean isTraining;
    private EntityPlayer owner;
    private UUID ownerUUID;

    public EntityKungFuDugong(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            boolean flagOwner = this.getOwner() != null && this.func_70032_d((Entity)this.getOwner()) < 10.0f;
            boolean flagTamed = this.isTamed();
            boolean flagHasNoTarget = this.func_70638_az() == null;
            boolean flagWaiting = flagHasNoTarget && this.isWaiting();
            boolean flagHealth = this.func_110143_aJ() > this.func_110138_aP() / 3.0f;
            this.isHappy = flagOwner && flagTamed && flagWaiting && flagHealth;
            if (flagHasNoTarget && this.field_70173_aa % 250 == 0) {
                this.isTraining = !this.isTraining;
                this.updateNBT();
            }
            if (this.field_70173_aa % 100 == 0) {
                this.updateNBT();
            }
            if (flagWaiting || this.isTraining()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70638_az() == this.owner) {
                this.func_70624_b(null);
            }
            if (this.owner != null) {
                if (this.func_70032_d((Entity)this.owner) > 10.0f) {
                    this.func_70661_as().func_75497_a((Entity)this.owner, 1.5);
                }
                if (this.func_70032_d((Entity)this.owner) > 80.0f) {
                    this.func_70634_a(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
                }
            }
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void updateNBT() {
        NBTTagCompound nbtClone = new NBTTagCompound();
        this.func_70014_b(nbtClone);
        if (!this.field_70170_p.field_72995_K) {
            WyNetworkHelper.sendToAll(new PacketEntityNBTSync(this.func_145782_y(), nbtClone));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("IsTamed", this.isTamed);
        nbt.func_74757_a("IsWaiting", this.isWaiting);
        nbt.func_74757_a("IsHappy", this.isHappy);
        nbt.func_74757_a("IsEnraged", this.isEnraged);
        nbt.func_74757_a("IsTraining", this.isTraining);
        nbt.func_74778_a("OwnerUUID", this.ownerUUID != null ? this.ownerUUID.toString() : "");
    }

    @Override
    public void readEntityFromExtraNBT(NBTTagCompound nbt) {
        this.func_70037_a(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.isTamed = nbt.func_74767_n("IsTamed");
        this.isWaiting = nbt.func_74767_n("IsWaiting");
        this.isHappy = nbt.func_74767_n("IsHappy");
        this.isEnraged = nbt.func_74767_n("IsEnraged");
        this.isTraining = nbt.func_74767_n("IsTraining");
        String uuid = nbt.func_74779_i("OwnerUUID");
        if (!WyHelper.isNullOrEmpty(uuid)) {
            this.ownerUUID = UUID.fromString(uuid);
            this.owner = this.field_70170_p.func_152378_a(this.ownerUUID);
            this.isTamed = true;
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        super.func_70097_a(damageSource, amount);
        Entity entity = damageSource.func_76346_g();
        if (this.isTamed()) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            IAttributeInstance attackDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
            UUID rageModeUUID = UUID.fromString("d760dc58-8275-4ef6-ae34-d197a879c099");
            AttributeModifier attributeModifier = new AttributeModifier(rageModeUUID, "Rage Mode", 8.0, 0);
            if (player.func_70694_bm() != null) {
                if (attackDamage.func_111127_a(rageModeUUID) == null) {
                    attackDamage.func_111121_a(attributeModifier);
                    this.isEnraged = true;
                    this.updateNBT();
                }
                WyNetworkHelper.sendToAll(new PacketParticles("aboveHeadAngry", this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v));
            } else if (!this.isEnraged() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                WyNetworkHelper.sendToAll(new PacketParticles("aboveHeadHappy", this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v));
                this.setOwner(player);
                this.updateNBT();
            }
        }
        return true;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack heldStack = player.func_70694_bm();
        if (this.isTamed() && player == this.owner) {
            Optional<Item> foodItem;
            if (heldStack != null && this.func_110143_aJ() < this.func_110138_aP() && (foodItem = Arrays.stream(this.food).filter(x -> heldStack.func_77973_b() == x).findFirst()) != null) {
                --heldStack.field_77994_a;
                this.func_70691_i(4.0f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_72869_a(EnumParticleTypes.HEART.getParticleName(), this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                }
                return true;
            }
            this.isWaiting = !this.isWaiting;
            this.updateNBT();
        }
        return false;
    }

    protected void func_70628_a(boolean flag, int looting) {
        int j = (int)(1.0 + WyMathHelper.randomWithRange(0 + looting, 1 + looting));
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151101_aQ, 1);
                continue;
            }
            this.func_145779_a(Items.field_151115_aP, 1);
        }
    }

    public boolean isHappy() {
        return this.isHappy;
    }

    public boolean isTamed() {
        return this.isTamed;
    }

    public boolean isWaiting() {
        return this.isWaiting;
    }

    public boolean isEnraged() {
        return this.isEnraged;
    }

    public boolean isTraining() {
        return this.isTraining;
    }

    private void setOwner(EntityPlayer player) {
        this.owner = player;
        this.ownerUUID = player.getPersistentID();
        this.isTamed = true;
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    protected boolean func_70692_ba() {
        return !this.isTamed();
    }

    public String func_152113_b() {
        if (this.ownerUUID != null) {
            return this.ownerUUID.toString();
        }
        return "";
    }
}

