/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.entities.mobs.animals;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.EnumParticleTypes;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.EntityNewMob;

public class EntityYagaraBull
extends EntityNewMob
implements IEntityOwnable {
    private Item[] food = new Item[]{Items.field_151101_aQ, Items.field_151115_aP};
    private boolean isTamed;
    private boolean isSaddled;
    private boolean is2ndSeatEmpty;
    private EntityPlayer owner;
    private UUID ownerUUID;
    private int timesFed = 0;
    private double speedMultiplier = 1.0;

    public EntityYagaraBull(World world) {
        super(world, new String[]{"yagarabull1", "yagarabull2", "yagarabull3"});
        this.func_70105_a(1.4f, 1.6f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.01);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        AxisAlignedBB aabb;
        super.func_70071_h_();
        if (this.field_70173_aa < 20) {
            this.updateNBT();
        }
        if (this.field_70170_p.func_72830_b(aabb = AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)(this.field_70121_D.field_72338_b + 0.9), (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)this.field_70121_D.field_72337_e, (double)this.field_70121_D.field_72334_f), Material.field_151586_h)) {
            this.field_70181_x += 0.03;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)this.field_70153_n;
                float f = this.field_70153_n.field_70177_z + -entitylivingbase.field_70702_br * 90.0f;
                this.field_70159_w += -Math.sin(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_70701_bs * (double)0.05f;
                this.field_70179_y += Math.cos(f * (float)Math.PI / 180.0f) * this.speedMultiplier * (double)entitylivingbase.field_70701_bs * (double)0.05f;
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 1.4));
                int j = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 1.4));
                for (int j1 = 0; j1 < 2; ++j1) {
                    int k = MathHelper.func_76128_c((double)this.field_70163_u) + j1;
                    Block block = this.field_70170_p.func_147439_a(i1, k, j);
                    if (block == Blocks.field_150431_aC) {
                        this.field_70170_p.func_147468_f(i1, k, j);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(i1, k, j, true);
                    this.field_70123_F = false;
                }
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack heldStack = player.func_70694_bm();
        if (!this.isTamed()) {
            double d2;
            int i;
            if (heldStack == null) {
                return false;
            }
            ItemStack foodItemStack = null;
            for (Item food : this.food) {
                if (player.func_70694_bm().func_77973_b() != food) continue;
                foodItemStack = new ItemStack(food);
                break;
            }
            if (foodItemStack == null) {
                return false;
            }
            --foodItemStack.field_77994_a;
            for (i = 0; i < 2; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_72869_a(EnumParticleTypes.HEART.getParticleName(), this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
            }
            ++this.timesFed;
            if ((double)this.timesFed >= 5.0 + WyMathHelper.randomWithRange(2, 5)) {
                this.setTamed(true);
                for (i = 0; i < 10; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.03;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.03;
                    d2 = this.field_70146_Z.nextGaussian() * 0.03;
                    this.field_70170_p.func_72869_a(EnumParticleTypes.HEART.getParticleName(), this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
                }
                this.updateNBT();
            }
            return true;
        }
        if (!this.isSaddled()) {
            if (heldStack == null) {
                return false;
            }
            if (heldStack.func_77973_b() == Items.field_151141_av) {
                --heldStack.field_77994_a;
                this.setSaddled(true);
                this.updateNBT();
            }
            return true;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.field_70153_n != player) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_70078_a((Entity)this);
        }
        return true;
    }

    public void func_70612_e(float x, float y) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && this.isSaddled()) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            y = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (y <= 0.0f) {
                y *= 0.25f;
            }
            if (!this.field_70170_p.field_72995_K) {
                super.func_70612_e(x, y);
            }
        } else {
            super.func_70612_e(x, y);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * (float)Math.PI / 180.0f));
        float f2 = -0.5f;
        float f3 = 0.15f;
        this.field_70153_n.func_70107_b(this.field_70165_t + (double)(f2 * f), this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W() + (double)f3, this.field_70161_v - (double)(f2 * f1));
        if (this.field_70153_n instanceof EntityLivingBase) {
            ((EntityLivingBase)this.field_70153_n).field_70761_aq = this.field_70761_aq;
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.5;
    }

    protected void func_70628_a(boolean flag, int looting) {
        int j = (int)(1.0 + WyMathHelper.randomWithRange(1 + looting, 5 + looting));
        for (int k = 0; k < j; ++k) {
            if (this.func_70027_ad()) {
                this.func_145779_a(Items.field_151101_aQ, 1);
                continue;
            }
            this.func_145779_a(Items.field_151115_aP, 1);
        }
        if (this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("IsTamed", this.isTamed);
        nbt.func_74757_a("IsSaddled", this.isSaddled);
        nbt.func_74778_a("OwnerUUID", this.ownerUUID != null ? this.ownerUUID.toString() : "");
    }

    @Override
    public void readEntityFromExtraNBT(NBTTagCompound nbt) {
        this.func_70037_a(nbt);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.isTamed = nbt.func_74767_n("IsTamed");
        this.isSaddled = nbt.func_74767_n("IsSaddled");
        String uuid = nbt.func_74779_i("OwnerUUID");
        if (!WyHelper.isNullOrEmpty(uuid)) {
            this.ownerUUID = UUID.fromString(uuid);
            this.owner = this.field_70170_p.func_152378_a(this.ownerUUID);
            this.isTamed = true;
        }
    }

    @Override
    public boolean func_70650_aV() {
        return true;
    }

    public boolean isTamed() {
        return this.isTamed;
    }

    public void setTamed(boolean value) {
        this.isTamed = value;
    }

    public boolean isSaddled() {
        return this.isSaddled;
    }

    public void setSaddled(boolean value) {
        this.isSaddled = value;
    }

    public EntityPlayer getOwner() {
        return this.owner;
    }

    @Override
    protected boolean func_70692_ba() {
        return !this.isTamed();
    }

    public String func_152113_b() {
        if (this.ownerUUID != null) {
            return this.ownerUUID.toString();
        }
        return "";
    }
}

