/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedWorldData;
import xyz.pixelatedw.MineMineNoMi3.data.HistoryProperties;

public class EventsCore {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityLivingBase && ExtendedEntityData.get((EntityLivingBase)event.entity) == null) {
            ExtendedEntityData.register((EntityLivingBase)event.entity);
        }
        if (event.entity instanceof EntityPlayer) {
            if (QuestProperties.get((EntityPlayer)event.entity) == null) {
                QuestProperties.register((EntityPlayer)event.entity);
            }
            if (AbilityProperties.get((EntityPlayer)event.entity) == null) {
                AbilityProperties.register((EntityPlayer)event.entity);
            }
            if (HistoryProperties.get((EntityPlayer)event.entity) == null) {
                HistoryProperties.register((EntityPlayer)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone e) {
        if (e.wasDeath) {
            ExtendedEntityData oldProps;
            ExtendedWorldData worldProps = ExtendedWorldData.get(e.original.field_70170_p);
            ExtendedEntityData oldPlayerProps = ExtendedEntityData.get((EntityLivingBase)e.original);
            ExtendedEntityData newPlayerProps = ExtendedEntityData.get((EntityLivingBase)e.entityPlayer);
            if (MainConfig.enableKeepIEEPAfterDeath.equals("full")) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                ExtendedEntityData oldProps2 = ExtendedEntityData.get((EntityLivingBase)e.original);
                oldProps2.saveNBTData(nBTTagCompound);
                oldProps2.triggerActiveHaki(false);
                oldProps2.triggerBusoHaki(false);
                oldProps2.triggerKenHaki(false);
                oldProps2.setGear(1);
                oldProps2.setZoanPoint("n/a");
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)e.entityPlayer);
                props.loadNBTData(nBTTagCompound);
                nBTTagCompound = new NBTTagCompound();
                AbilityProperties.get(e.original).saveNBTData(nBTTagCompound);
                AbilityProperties abilityProps = AbilityProperties.get(e.entityPlayer);
                abilityProps.loadNBTData(nBTTagCompound);
                if (e.entityPlayer != null && MainConfig.enableExtraHearts) {
                    IAttributeInstance maxHp = e.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a);
                    if (props.getDoriki() / 100 <= 20) {
                        e.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
                    } else {
                        e.entityPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(props.getDoriki() / 100));
                    }
                }
            } else if (MainConfig.enableKeepIEEPAfterDeath.equals("auto")) {
                oldProps = ExtendedEntityData.get((EntityLivingBase)e.original);
                String faction = oldProps.getFaction();
                String race = oldProps.getRace();
                String fightStyle = oldProps.getFightStyle();
                String crew = oldProps.getCrew();
                int doriki = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.dorikiKeepPercentage, oldProps.getDoriki()));
                int bounty = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.bountyKeepPercentage, oldProps.getBounty()));
                int belly = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.bellyKeepPercentage, oldProps.getBelly()));
                worldProps.removeDevilFruitFromWorld(oldProps.getUsedFruit());
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)e.entityPlayer);
                props.setFaction(faction);
                props.setRace(race);
                props.setFightStyle(fightStyle);
                props.setCrew(crew);
                props.setMaxCola(100);
                props.setCola(oldProps.getMaxCola());
                props.setDoriki(doriki);
                props.setBounty(bounty);
                props.setBelly(belly);
            } else if (MainConfig.enableKeepIEEPAfterDeath.equals("custom")) {
                oldProps = ExtendedEntityData.get((EntityLivingBase)e.original);
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)e.entityPlayer);
                block18: for (String stat : MainConfig.statsToKeep) {
                    switch (WyHelper.getFancyName(stat)) {
                        case "doriki": {
                            int doriki = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.dorikiKeepPercentage, oldProps.getDoriki()));
                            props.setDoriki(doriki);
                            continue block18;
                        }
                        case "bounty": {
                            int bounty = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.bountyKeepPercentage, oldProps.getBounty()));
                            props.setBounty(bounty);
                            continue block18;
                        }
                        case "belly": {
                            int belly = MathHelper.func_76143_f((double)WyMathHelper.percentage(MainConfig.bellyKeepPercentage, oldProps.getBelly()));
                            props.setBelly(belly);
                            continue block18;
                        }
                        case "race": {
                            props.setRace(oldProps.getRace());
                            continue block18;
                        }
                        case "faction": {
                            props.setFaction(oldProps.getFaction());
                            continue block18;
                        }
                        case "fightingstyle": {
                            props.setFightStyle(oldProps.getFightStyle());
                            continue block18;
                        }
                        case "devilfruit": {
                            props.setUsedFruit(oldProps.getUsedFruit());
                        }
                    }
                }
                if (WyHelper.isNullOrEmpty(props.getUsedFruit())) {
                    worldProps.removeDevilFruitFromWorld(oldProps.getUsedFruit());
                }
            }
            NBTTagCompound compound = new NBTTagCompound();
            QuestProperties.get(e.original).saveNBTData(compound);
            QuestProperties questProps = QuestProperties.get(e.entityPlayer);
            questProps.loadNBTData(compound);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                if (!WyHelper.isReleaseBuild() && !WyHelper.hasPatreonAccess(player)) {
                    ((EntityPlayerMP)player).field_71135_a.func_147360_c(EnumChatFormatting.BOLD + "" + EnumChatFormatting.RED + "WARNING! \n\n " + EnumChatFormatting.RESET + "You don't have access to this version yet!");
                    if (!WyDebug.isDebug()) {
                        WyTelemetry.addMiscStat("onlinePlayers", "Online Players", -1);
                        WyTelemetry.sendAllDataSync();
                    }
                    event.setCanceled(true);
                    return;
                }
                if (MainConfig.enableUpdateMsg) {
                    try {
                        int latestZ;
                        int latestY;
                        String[] resultVersion;
                        int latestX;
                        int latestVersion;
                        String[] version = "0.6.1".replaceAll("[^0-9.]", "").split("\\.");
                        int currentX = Integer.parseInt(version[0]) * 100;
                        int currentY = Integer.parseInt(version[1]) * 10;
                        int currentZ = Integer.parseInt(version[2]);
                        int currentVersion = currentX + currentY + currentZ;
                        String apiURL = "/version?minecraft-version=1.7.10";
                        String result = WyTelemetry.sendGET(apiURL);
                        if (!WyHelper.isNullOrEmpty(result) && (latestVersion = (latestX = Integer.parseInt((resultVersion = result.replaceAll("[^0-9.]", "").split("\\."))[0]) * 100) + (latestY = Integer.parseInt(resultVersion[1]) * 10) + (latestZ = Integer.parseInt(resultVersion[2]))) > currentVersion) {
                            ChatStyle updateStyle = new ChatStyle().func_150238_a(EnumChatFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://pixelatedw.xyz/versions"));
                            player.func_146105_b(new ChatComponentText(EnumChatFormatting.RED + "" + EnumChatFormatting.BOLD + "[UPDATE]" + EnumChatFormatting.RED + " Mine Mine no Mi " + result + " is now available !").func_150255_a(updateStyle));
                            player.func_146105_b(new ChatComponentText(EnumChatFormatting.RED + "Download it from the official website : [http://pixelatedw.xyz/versions]").func_150255_a(updateStyle));
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Connection failed !");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!WyDebug.isDebug()) {
            WyTelemetry.addMiscStat("onlinePlayers", "Online Players", 1);
            WyTelemetry.sendAllData();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!WyDebug.isDebug()) {
            WyTelemetry.addMiscStat("onlinePlayers", "Online Players", -1);
            WyTelemetry.sendAllDataSync();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && event.player.field_70170_p.func_72820_D() % 1200L == 0L) {
            WyTelemetry.sendAllData();
        }
    }
}

