/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.CyborgAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.FishKarateAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.RokushikiAbilities;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.telemetry.WyTelemetry;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.EntityNewMob;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.marines.MarineData;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.EventBounty;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.EventDoriki;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;

public class EventsOnGain {
    @SubscribeEvent
    public void onDorikiGained(EventDoriki event) {
        if (event.props.isHuman()) {
            this.gainAbility(event.player, 500, RokushikiAbilities.SORU, false);
            this.gainAbility(event.player, 1500, RokushikiAbilities.TEKKAI, false);
            this.gainAbility(event.player, 3000, RokushikiAbilities.SHIGAN, false);
            this.gainAbility(event.player, 4500, RokushikiAbilities.GEPPO, false);
            this.gainAbility(event.player, 6000, RokushikiAbilities.KAMIE, false);
            this.gainAbility(event.player, 8500, RokushikiAbilities.RANKYAKU, false);
        } else if (event.props.isFishman()) {
            this.gainAbility(event.player, 800, FishKarateAbilities.UCHIMIZU, false);
            this.gainAbility(event.player, 2000, FishKarateAbilities.MURASAME, false);
            this.gainAbility(event.player, 2500, FishKarateAbilities.KACHIAGE_HAISOKU, false);
            this.gainAbility(event.player, 3000, FishKarateAbilities.SAMEHADA_SHOTEI, false);
            this.gainAbility(event.player, 7500, FishKarateAbilities.KARAKUSAGAWARA_SEIKEN, false);
        } else if (event.props.isCyborg()) {
            this.gainAbility(event.player, 0, CyborgAbilities.FRESH_FIRE, false);
            this.gainAbility(event.player, 0, CyborgAbilities.COLA_OVERDRIVE, false);
            this.gainAbility(event.player, 0, CyborgAbilities.STRONG_RIGHT, false);
            this.gainAbility(event.player, 0, CyborgAbilities.RADICAL_BEAM, false);
            this.gainAbility(event.player, 0, CyborgAbilities.COUP_DE_VENT, false);
        }
        if (event.player != null && MainConfig.enableExtraHearts) {
            IAttributeInstance maxHp = event.player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (event.props.getDoriki() / 100 <= 20) {
                event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            } else {
                event.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(event.props.getDoriki() / 100));
            }
        }
    }

    private void gainAbility(EntityPlayer player, int doriki, Ability ability, boolean isHaki) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        AbilityProperties abilityProps = AbilityProperties.get(player);
        if (isHaki) {
            if (props.getDoriki() >= doriki && !abilityProps.hasHakiAbility(ability) && !DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) {
                abilityProps.addHakiAbility(ability);
            }
            if ((props.getDoriki() < doriki || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) && abilityProps.hasHakiAbility(ability)) {
                abilityProps.removeHakiAbility(ability);
            }
        } else {
            if (props.getDoriki() >= doriki && !abilityProps.hasRacialAbility(ability) && !DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) {
                abilityProps.addRacialAbility(ability);
            }
            if ((props.getDoriki() < doriki || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) && abilityProps.hasRacialAbility(ability)) {
                abilityProps.removeRacialAbility(ability);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        ExtendedEntityData props;
        EntityPlayer player;
        if (event.entity instanceof EntityPlayer) {
            player = (EntityPlayer)event.entity;
            props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            for (int i = 0; i < 8; ++i) {
                if (abilityProps.getAbilityFromSlot(i) == null) continue;
                abilityProps.getAbilityFromSlot(i).reset();
            }
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
        }
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.source.func_76346_g();
            props = ExtendedEntityData.get((EntityLivingBase)player);
            EntityLivingBase target = event.entityLiving;
            IAttributeInstance attrAtk = target.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
            IAttributeInstance attrHP = target.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
            int rng = player.field_70170_p.field_73012_v.nextInt(3) + 1;
            int plusBelly = 0;
            long plusBounty = 0L;
            double plusDoriki = 0.0;
            boolean targetPlayer = false;
            if (target instanceof EntityPlayer) {
                ExtendedEntityData targetprops = ExtendedEntityData.get(target);
                plusDoriki = targetprops.getDoriki() / 4 + rng;
                plusBounty = targetprops.getBounty() / 2L + (long)rng;
                plusBelly = targetprops.getBelly();
                targetPlayer = true;
            } else {
                if (props.isMarine() && target instanceof MarineData) {
                    return;
                }
                if (target instanceof EntityNewMob) {
                    EntityNewMob entity = (EntityNewMob)target;
                    if (props.getDoriki() / 100 > entity.getDoriki()) {
                        if (MainConfig.enableMinimumDorikiPerKill) {
                            plusDoriki = 1.0;
                        }
                    } else {
                        plusDoriki = entity.getDoriki();
                    }
                    plusDoriki *= MainConfig.modifierDorikiReward;
                    plusBounty = entity.getDoriki() * 2 + rng;
                    plusBelly = entity.getBelly() + rng;
                    if (!player.field_70170_p.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        WyTelemetry.addKillStat(WyHelper.getFancyName(target.getClass().getSimpleName()).replace("entity", ""), target.getClass().getSimpleName().replace("Entity", ""), 1);
                    }
                } else if (attrAtk != null && attrHP != null) {
                    double i = attrAtk.func_111126_e();
                    double j = attrHP.func_111126_e();
                    plusDoriki = (int)Math.round((i + j) / 10.0 / Math.PI) + rng;
                    plusBounty = (int)Math.round((i + j) / 10.0) + rng;
                    plusBelly = 1;
                    plusDoriki *= MainConfig.modifierDorikiReward;
                } else {
                    plusDoriki = 0.0;
                    plusBounty = 0L;
                    plusBelly = 1;
                }
                if (plusDoriki > 0.0 && (double)props.getDoriki() + plusDoriki <= 12500.0) {
                    props.alterDoriki((int)Math.round(plusDoriki));
                    EventDoriki e = new EventDoriki(player);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                }
                if ((props.isPirate() || props.isRevolutionary()) && plusBounty > 0L && props.getBounty() + plusBounty < 999999999L) {
                    props.alterBounty(plusBounty);
                    EventBounty e = new EventBounty(player, plusBounty);
                    if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                        return;
                    }
                }
                if (props.getBelly() + plusBelly < 999999999) {
                    props.alterBelly(plusBelly);
                }
            }
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
        }
    }
}

