/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.MainMod;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketQuestSync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.IQuestGiver;
import xyz.pixelatedw.MineMineNoMi3.helpers.QuestLogicHelper;
import xyz.pixelatedw.MineMineNoMi3.quests.EnumQuestlines;
import xyz.pixelatedw.MineMineNoMi3.quests.IHitCounterQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IInteractQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IKillQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.ITimedQuest;

public class EventsQuestsProgress {
    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            AbilityProperties abilityProps = AbilityProperties.get(player);
            ItemStack heldItem = player.func_70694_bm();
            QuestProperties questProps = QuestProperties.get(player);
            List<ITimedQuest> timedQuests = QuestLogicHelper.checkForITimedQuests(questProps);
            for (ITimedQuest quest : timedQuests) {
                quest.onTimePassEvent(player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        QuestProperties questProps = QuestProperties.get(player);
        EntityLivingBase target = null;
        if (event.target instanceof EntityLivingBase) {
            target = (EntityLivingBase)event.target;
        }
        if (target != null && MainConfig.enableQuests) {
            if (target instanceof IQuestGiver) {
                Quest currentProgressionQuest;
                EnumQuestlines questline = ((IQuestGiver)target).getQuestline();
                if (questProps.questsInProgress() > 0 && QuestLogicHelper.turnInQuestlineQuest(player, questline.getQuests()) > 0) {
                    return;
                }
                if (questProps.questsInProgress() < 4 && (currentProgressionQuest = QuestLogicHelper.getQuestlineCurrentQuest(questline.getQuests(), questProps)) != null && !questProps.hasQuestInTracker(currentProgressionQuest)) {
                    MainMod.proxy.openQuestYesOrNoWorkaround(player, questline);
                    return;
                }
            }
            if (questProps.questsInProgress() > 0 && !player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    if (questProps.getQuestIndexFromTracker(i) == null || !(questProps.getQuestIndexFromTracker(i) instanceof IInteractQuest) || !((IInteractQuest)((Object)questProps.getQuestIndexFromTracker(i))).isTarget(player, target)) continue;
                    questProps.alterQuestProgress(questProps.getQuestIndexFromTracker(i), 1.0);
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            QuestProperties questProps = QuestProperties.get(player);
            EntityLivingBase target = event.entityLiving;
            if (questProps.questsInProgress() > 0) {
                for (int i = 0; i < 4; ++i) {
                    if (questProps.getQuestIndexFromTracker(i) == null || !(questProps.getQuestIndexFromTracker(i) instanceof IKillQuest) || !((IKillQuest)((Object)questProps.getQuestIndexFromTracker(i))).isTarget(player, target)) continue;
                    questProps.alterQuestProgress(questProps.getQuestIndexFromTracker(i), 1.0);
                }
            }
            WyNetworkHelper.sendTo(new PacketQuestSync(questProps), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onEntityAttackEvent(LivingHurtEvent event) {
        if (event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            QuestProperties questProps = QuestProperties.get(player);
            EntityLivingBase target = event.entityLiving;
            if (questProps.questsInProgress() > 0) {
                for (int i = 0; i < 4; ++i) {
                    if (questProps.getQuestIndexFromTracker(i) == null || !(questProps.getQuestIndexFromTracker(i) instanceof IHitCounterQuest) || !((IHitCounterQuest)((Object)questProps.getQuestIndexFromTracker(i))).checkHit(player, target, event.source)) continue;
                    questProps.alterQuestProgress(questProps.getQuestIndexFromTracker(i), 1.0);
                }
            }
            WyNetworkHelper.sendTo(new PacketQuestSync(questProps), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onToolTip(ItemTooltipEvent event) {
        ItemStack itemStack = event.itemStack;
        if (!itemStack.func_77942_o()) {
            return;
        }
        NBTTagCompound questLore = (NBTTagCompound)itemStack.func_77978_p().func_74781_a("QuestLore");
        if (questLore == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            String loreLine = questLore.func_74779_i("lore" + i);
            if (WyHelper.isNullOrEmpty(loreLine)) continue;
            event.toolTip.add(loreLine);
        }
    }
}

