/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.abilities.CyborgAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.DoctorAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.FishKarateAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.HakiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.RokushikiAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SniperAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.SwordsmanAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.WeatherAbilities;
import xyz.pixelatedw.MineMineNoMi3.abilities.effects.DFEffectHaoHaki;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedWorldData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.EntityNewMob;
import xyz.pixelatedw.MineMineNoMi3.events.customevents.EventDoriki;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketShounenScream;

public class DevilFruitsHelper {
    private static String[][] zoanModels = new String[][]{{"ushiushibison", "bison"}, {"toritoriphoenix", "phoenix"}, {"ushiushigiraffe", "giraffe"}};
    public static String[] flyingFruits = new String[]{"gasugasu", "sunasuna", "mokumoku"};
    private static HashMap<String, List<Block>> blockRules = DevilFruitsHelper.createBlockRulesMap();

    private static HashMap<String, List<Block>> createBlockRulesMap() {
        HashMap<String, List<Block>> map = new HashMap<String, List<Block>>();
        map.put("core", Arrays.asList(Blocks.field_150432_aD, Blocks.field_150403_cj, Blocks.field_150348_b, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150354_m, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_150466_ao, Blocks.field_150376_bx, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150404_cg, Blocks.field_150414_aQ, ListMisc.Poison, ListMisc.DemonPoison, Blocks.field_150478_aa, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150347_e, Blocks.field_150422_aJ, Blocks.field_150458_ak, Blocks.field_150396_be, Blocks.field_150457_bL, Blocks.field_150435_aG, Blocks.field_150351_n, ListMisc.SunaSand, ListMisc.WaxBlock));
        map.put("air", Arrays.asList(Blocks.field_150350_a));
        map.put("foliage", Arrays.asList(Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150392_bi, Blocks.field_150398_cm, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150395_bd, Blocks.field_150338_P, Blocks.field_150420_aW, Blocks.field_150337_Q, Blocks.field_150419_aX, Blocks.field_150329_H, Blocks.field_150469_bN, Blocks.field_150459_bM, Blocks.field_150434_aF, Blocks.field_150330_I));
        map.put("ores", Arrays.asList(Blocks.field_150365_q, Blocks.field_150402_ci, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150451_bX, Blocks.field_150352_o, Blocks.field_150340_R, ListMisc.KairosekiOre, ListMisc.KairosekiBlock));
        map.put("liquids", Arrays.asList(Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150353_l, Blocks.field_150356_k));
        return map;
    }

    public static void haoAttackEntities(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        for (EntityLivingBase target : WyHelper.getEntitiesNear((Entity)player, 100.0)) {
            double userHakiExp = props.getHardeningHakiExp() * 3 + props.getImbuingHakiExp() * 3 + props.getObservationHakiExp() * 3;
            double targetHakiExp = 0.0;
            boolean hasBlindness = false;
            if (target instanceof EntityPlayer) {
                ExtendedEntityData propz = ExtendedEntityData.get(target);
                targetHakiExp = propz.getHardeningHakiExp() * 3 + propz.getImbuingHakiExp() * 3 + propz.getObservationHakiExp() * 3;
            } else if (target instanceof EntityNewMob) {
                targetHakiExp = ((EntityNewMob)target).getDoriki();
            } else if (target.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                targetHakiExp = target.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            }
            if (targetHakiExp < userHakiExp / 1.5) {
                int duration = (int)((userHakiExp / 1.5 - targetHakiExp) * 20.0);
                if (duration > 2000) {
                    duration = 2000;
                }
                target.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, duration, 1));
                target.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, duration, 1));
                target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration, 5));
                target.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration, 1));
                target.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, duration, -5));
                if (targetHakiExp < userHakiExp / 2.0) {
                    target.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, duration, 1));
                    target.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, duration, 1));
                    target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration, 500));
                    hasBlindness = true;
                    new DFEffectHaoHaki(target, duration + 200);
                }
            }
            if (hasBlindness) continue;
            new DFEffectHaoHaki(target, 100);
        }
    }

    public static int getParticleSettingModifier(int defaultAmount) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            return 0;
        }
        int modifier = Math.abs(Minecraft.func_71410_x().field_71474_y.field_74362_aa - 2);
        switch (modifier) {
            case 2: {
                return defaultAmount;
            }
            case 1: {
                return defaultAmount / 2;
            }
            case 0: {
                return 0;
            }
        }
        return defaultAmount;
    }

    public static void sendShounenScream(EntityPlayer player, String ability, int part) {
        if (MainConfig.enableAnimeScreaming) {
            WyNetworkHelper.sendToAllAround(new PacketShounenScream(player.func_70005_c_(), ability, part), player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 15.0);
        }
    }

    public static boolean canUseSwordsmanAbilities(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        Ability sparClaw = AbilityProperties.get(player).getAbilityFromName(ListAttributes.SPAR_CLAW.getAttributeName());
        return props.getUsedFruit().equalsIgnoreCase("supasupa") && sparClaw != null && sparClaw.isPassiveActive();
    }

    public static boolean checkForRestriction(EntityPlayer player) {
        ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
        if (worldData.isInsideRestrictedArea((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) {
            WyHelper.sendMsgToPlayer(player, "Cannot use abilites in a restricted area !");
            return true;
        }
        return false;
    }

    public static boolean isDevilFruitInWorld(World world, String devilFruitName) {
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        return worldData.isDevilFruitInWorld(devilFruitName);
    }

    public static boolean isDevilFruitInWorld(World world, AkumaNoMi devilFruit) {
        String name;
        if (devilFruit == null) {
            return true;
        }
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        return worldData.isDevilFruitInWorld(name = devilFruit.func_77658_a().substring(5).replace("nomi", "").replace(":", "").replace(",", "").replace("model", ""));
    }

    public static boolean isAffectedByWater(EntityLivingBase entity) {
        Block level1Block = entity.field_70170_p.func_147439_a((int)entity.field_70165_t, (int)entity.field_70163_u - 1, (int)entity.field_70161_v);
        Block level2Block = entity.field_70170_p.func_147439_a((int)entity.field_70165_t, (int)entity.field_70163_u - 2, (int)entity.field_70161_v);
        return entity.func_70055_a(Material.field_151586_h) || entity.func_70026_G() && !entity.func_70115_ae() && (level1Block == Blocks.field_150355_j || level1Block == Blocks.field_150358_i) && (level2Block == Blocks.field_150355_j || level2Block == Blocks.field_150358_i);
    }

    public static boolean isNearbyKairoseki(EntityPlayer player) {
        return WyHelper.isBlockNearby((EntityLivingBase)player, 4, ListMisc.KairosekiBlock, ListMisc.KairosekiOre, ListMisc.KairosekiBars) || ItemsHelper.hasKairosekiItem(player) || player.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiBlock)) || player.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiOre)) || player.field_71071_by.func_146028_b(Item.func_150898_a((Block)ListMisc.KairosekiBars)) || DevilFruitsHelper.isAffectedByWater((EntityLivingBase)player);
    }

    public static void verifyAndGiveAbility(Ability a, AbilityProperties abilityProps) {
        if (!DevilFruitsHelper.verifyIfAbilityIsBanned(a)) {
            abilityProps.addRacialAbility(a);
        }
    }

    public static boolean verifyIfAbilityIsBanned(Ability a) {
        for (String str : MainConfig.abilityRestrictions) {
            if (!WyHelper.getFancyName(str).contains(WyHelper.getFancyName(a.getAttribute().getAttributeName()))) continue;
            return true;
        }
        return false;
    }

    public static void validateRacialMoves(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        AbilityProperties abilityProps = AbilityProperties.get(player);
        EventDoriki e = new EventDoriki(player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return;
        }
        ArrayList<Object> tempAblList = new ArrayList<Object>();
        if (props.isHuman()) {
            for (Ability ability : RokushikiAbilities.abilitiesArray) {
                if (!abilityProps.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                tempAblList.add(ability);
            }
        }
        if (props.isFishman()) {
            for (Ability ability : FishKarateAbilities.abilitiesArray) {
                if (!abilityProps.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                tempAblList.add(ability);
            }
        }
        if (props.isCyborg()) {
            for (Ability ability : CyborgAbilities.abilitiesArray) {
                if (!abilityProps.hasRacialAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
                tempAblList.add(ability);
            }
        }
        abilityProps.clearRacialAbilities();
        for (Ability ability : tempAblList) {
            abilityProps.addRacialAbility(ability);
        }
        tempAblList.clear();
        for (Ability ability : HakiAbilities.abilitiesArray) {
            if (!abilityProps.hasHakiAbility(ability) || DevilFruitsHelper.verifyIfAbilityIsBanned(ability)) continue;
            tempAblList.add(ability);
        }
        abilityProps.clearHakiAbilities();
        for (Ability ability : tempAblList) {
            abilityProps.addHakiAbility(ability);
        }
    }

    public static void validateStyleMoves(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        QuestProperties questProps = QuestProperties.get(player);
        AbilityProperties abilityProps = AbilityProperties.get(player);
        if (props.isSwordsman()) {
            DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.SHI_SHISHI_SONSON, abilityProps);
            if (MainConfig.enableQuestProgression) {
                if (questProps.hasQuestCompleted(ListQuests.swordsmanProgression04) && !DevilFruitsHelper.verifyIfAbilityIsBanned(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO)) {
                    abilityProps.addRacialAbility(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO);
                }
            } else {
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.SANBYAKUROKUJU_POUND_HO, abilityProps);
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.YAKKODORI, abilityProps);
                DevilFruitsHelper.verifyAndGiveAbility(SwordsmanAbilities.OTATSUMAKI, abilityProps);
            }
        } else if (props.isSniper()) {
            DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.KAEN_BOSHI, abilityProps);
            if (!MainConfig.enableQuestProgression) {
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.KEMURI_BOSHI, abilityProps);
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.RENPATSU_NAMARI_BOSHI, abilityProps);
                DevilFruitsHelper.verifyAndGiveAbility(SniperAbilities.SAKURETSU_SABOTEN_BOSHI, abilityProps);
            }
        } else if (props.isMedic()) {
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.FIRST_AID, abilityProps);
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.MEDIC_BAG_EXPLOSION, abilityProps);
            DevilFruitsHelper.verifyAndGiveAbility(DoctorAbilities.FAILED_EXPERIMENT, abilityProps);
        } else if (props.isWeatherWizard()) {
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.HEAT_BALL, abilityProps);
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.COOL_BALL, abilityProps);
            DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.THUNDER_BALL, abilityProps);
            if (!MainConfig.enableQuestProgression) {
                DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.GUST_SWORD, abilityProps);
                DevilFruitsHelper.verifyAndGiveAbility(WeatherAbilities.WEATHER_EGG, abilityProps);
            }
        }
    }

    public static boolean isSniperAbility(Ability abl) {
        for (Ability a : SniperAbilities.abilitiesArray) {
            if (!abl.getAttribute().getAttributeName().equalsIgnoreCase(a.getAttribute().getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public static boolean placeBlockIfAllowed(World world, int posX, int posY, int posZ, Block toPlace, int flag, String ... rules) {
        return DevilFruitsHelper.placeBlockIfAllowed(world, posX, posY, posZ, toPlace, 0, flag, rules);
    }

    public static boolean placeBlockIfAllowed(World world, int posX, int posY, int posZ, Block toPlace, String ... rules) {
        return DevilFruitsHelper.placeBlockIfAllowed(world, posX, posY, posZ, toPlace, 0, 3, rules);
    }

    public static boolean placeBlockIfAllowed(World world, int posX, int posY, int posZ, Block toPlace, int meta, int flag, String ... rules) {
        Block b = world.func_147439_a(posX, posY, posZ);
        ArrayList bannedBlocks = new ArrayList();
        boolean noGriefFlag = Arrays.toString(rules).contains("nogrief");
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        if (worldData.isInsideRestrictedArea(posX, posY, posZ)) {
            return false;
        }
        Arrays.stream(rules).forEach(rule -> {
            String formula;
            if (rule.split(" ").length > 1) {
                formula = rule.split(" ")[0];
                rule = rule.split(" ")[1];
            } else {
                formula = "add";
            }
            if (blockRules.containsKey(rule)) {
                if (formula.equalsIgnoreCase("add")) {
                    bannedBlocks.addAll(blockRules.get(rule));
                } else if (formula.equalsIgnoreCase("ignore")) {
                    bannedBlocks.removeAll((Collection)blockRules.get(rule));
                }
            }
            if (rule.equalsIgnoreCase("all")) {
                if (formula.equalsIgnoreCase("add")) {
                    Block.field_149771_c.forEach(block -> bannedBlocks.add((Block)block));
                } else if (formula.equalsIgnoreCase("ignore")) {
                    Block.field_149771_c.forEach(block -> bannedBlocks.remove(block));
                }
            } else if (rule.equalsIgnoreCase("restricted")) {
                bannedBlocks.remove(Blocks.field_150357_h);
                bannedBlocks.remove(ListMisc.Ope);
                bannedBlocks.remove(ListMisc.OpeMid);
                bannedBlocks.remove(ListMisc.StringMid);
                bannedBlocks.remove(ListMisc.StringWall);
                bannedBlocks.remove(ListMisc.Darkness);
            }
        });
        if (MainConfig.enableGriefing || noGriefFlag) {
            for (Block blk : bannedBlocks) {
                if (b != blk) continue;
                world.func_147465_d(posX, posY, posZ, toPlace, meta, flag);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getDevilFruitItem(String fullName) {
        String model = "";
        String fullModel = "";
        for (String[] s : zoanModels) {
            if (!fullName.equals(s[0])) continue;
            model = s[1];
            fullModel = "model" + model;
            break;
        }
        if (fullName.equals("yamidummy")) {
            fullName = "yamiyami";
        }
        return new ItemStack(GameRegistry.findItem((String)"mineminenomi", (String)(fullName.replace(model, "") + "nomi" + fullModel)));
    }

    public static boolean isEntityInRoom(EntityLivingBase entity) {
        for (int i = -20; i < 20; ++i) {
            for (int j = -20; j < 20; ++j) {
                for (int k = -20; k < 20; ++k) {
                    if (entity.field_70170_p.func_147439_a((int)entity.field_70165_t + i, (int)entity.field_70163_u + j, (int)entity.field_70161_v + k) != ListMisc.OpeMid) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getRegenFromPoision(EntityLivingBase entity) {
        return entity.func_70660_b(Potion.field_76436_u).func_76458_c() / 5;
    }
}

