/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.helpers;

import com.google.common.collect.Multimap;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedWorldData;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class ItemsHelper {
    private static String[] wantedPostersBackgrounds = new String[]{"forest1", "forest2", "jungle1", "jungle2", "hills1", "hills2", "hills3", "plains1", "plains2", "plains3", "taiga1", "taiga2"};

    public static void dropWantedPosters(World world, int posX, int posY, int posZ) {
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        ArrayList bountiesInPackage = new ArrayList();
        if (!WyHelper.getEntitiesNear(posX, posY, posZ, world, 10.0).isEmpty()) {
            WyHelper.getEntitiesNear(posX, posY, posZ, world, 10.0).stream().filter(x -> x instanceof EntityPlayer && (ExtendedEntityData.get(x).isPirate() || ExtendedEntityData.get(x).isRevolutionary()) && worldData.getBounty(x.func_70005_c_()) != 0L).forEach(x -> {
                AbstractMap.SimpleEntry<String, Long> se = new AbstractMap.SimpleEntry<String, Long>(x.func_70005_c_(), worldData.getBounty(x.func_70005_c_()));
                bountiesInPackage.add(se);
            });
        }
        if (5 + world.field_73012_v.nextInt(2) - bountiesInPackage.size() > 0) {
            bountiesInPackage.addAll(worldData.getAllBounties().entrySet().stream().filter(x -> !bountiesInPackage.contains(x)).limit(5 + world.field_73012_v.nextInt(2) - bountiesInPackage.size()).collect(Collectors.toList()));
        }
        bountiesInPackage.stream().forEach(x -> {
            ItemStack stack = new ItemStack((Item)ListMisc.WantedPoster);
            stack.func_77982_d(ItemsHelper.setWantedData((String)x.getKey(), (Long)x.getValue()));
            world.func_72838_d((Entity)new EntityItem(world, (double)posX, (double)(posY + 1), (double)posZ, stack));
        });
    }

    public static NBTTagCompound setWantedData(String entityName, long bounty) {
        NBTTagCompound data = null;
        data = new NBTTagCompound();
        data.func_74778_a("Name", entityName);
        data.func_74772_a("Bounty", bounty);
        int randomBg = (int)WyMathHelper.randomWithRange(0, wantedPostersBackgrounds.length - 1);
        data.func_74778_a("Background", wantedPostersBackgrounds[randomBg]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = format.format(new Date());
        data.func_74778_a("Date", dateString);
        return data;
    }

    public static int getClimaTactLevel(Item item) {
        if (item == ListMisc.ClimaTact) {
            return 1;
        }
        if (item == ListMisc.PerfectClimaTact) {
            return 2;
        }
        if (item == ListMisc.SorceryClimaTact) {
            return 3;
        }
        return 0;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77975_n() == EnumAction.bow;
    }

    public static boolean isSword(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77973_b() instanceof ItemSword) {
            return true;
        }
        Multimap multimap = itemStack.func_111283_C();
        return multimap.containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
    }

    public static boolean hasKairosekiItem(EntityPlayer player) {
        for (Item itm : Values.KAIROSEKI_ITEMS) {
            if (!player.field_71071_by.func_146028_b(itm)) continue;
            return true;
        }
        return false;
    }
}

