/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.EnumFruitType;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.AbilityAttribute;
import xyz.pixelatedw.MineMineNoMi3.api.debug.WyDebug;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedWorldData;
import xyz.pixelatedw.MineMineNoMi3.helpers.DevilFruitsHelper;
import xyz.pixelatedw.MineMineNoMi3.items.AkumaNoMi;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public class AkumaNoMiBox
extends Item {
    private int tier;
    private List<AkumaNoMi> tier1Fruits = new ArrayList<AkumaNoMi>();
    private List<AkumaNoMi> tier2Fruits = new ArrayList<AkumaNoMi>();
    private List<AkumaNoMi> tier3Fruits = new ArrayList<AkumaNoMi>();

    public AkumaNoMiBox(int tier) {
        this.tier = tier;
        for (AkumaNoMi df : Values.devilfruits) {
            double score = 0.0;
            double typeModifier = 1.0;
            if (df.getType() == EnumFruitType.PARAMECIA) {
                typeModifier = 0.5;
            } else if (df.getType() == EnumFruitType.LOGIA) {
                typeModifier = 1.4;
            } else if (df.getType() == EnumFruitType.ZOAN) {
                typeModifier = 1.1;
            } else if (df.getType() == EnumFruitType.MYTHICALZOAN || df.getType() == EnumFruitType.ANCIENTZOAN) {
                typeModifier = 1.5;
            }
            double totalDamage = 0.0;
            double totalCooldown = 0.0;
            double totalPower = 0.0;
            for (Ability a : df.abilities) {
                AbilityAttribute attr = a.getAttribute();
                totalPower += ((totalCooldown += (double)(attr.getAbilityCooldown() - attr.getAbilityCharges())) + (totalDamage += (double)((float)attr.getAbilityExplosionPower() + attr.getProjectileDamage() + (float)attr.getProjectileExplosionPower()))) / 2.0;
            }
            totalPower *= typeModifier;
            if (df.getType() == EnumFruitType.ANCIENTZOAN || df.getType() == EnumFruitType.MYTHICALZOAN || df.func_77658_a().equalsIgnoreCase("item.guraguranomi")) {
                this.tier3Fruits.add(df);
                continue;
            }
            if (df.getType() == EnumFruitType.PARAMECIA) {
                if (totalPower < 500.0) {
                    this.tier1Fruits.add(df);
                    continue;
                }
                this.tier2Fruits.add(df);
                continue;
            }
            if (totalPower < 800.0) {
                this.tier2Fruits.add(df);
                continue;
            }
            this.tier3Fruits.add(df);
        }
        if (WyDebug.isDebug()) {
            if (tier == 1) {
                for (AkumaNoMi df : this.tier1Fruits) {
                    System.out.print("\"" + new ItemStack((Item)df).func_82833_r() + "\", ");
                }
                System.out.println();
            } else if (tier == 2) {
                for (AkumaNoMi df : this.tier2Fruits) {
                    System.out.print("\"" + new ItemStack((Item)df).func_82833_r() + "\", ");
                }
                System.out.println();
            } else if (tier == 3) {
                for (AkumaNoMi df : this.tier3Fruits) {
                    System.out.print("\"" + new ItemStack((Item)df).func_82833_r() + "\", ");
                }
                System.out.println();
            }
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).func_77973_b() != ListMisc.Key) continue;
                player.field_71071_by.func_70298_a(i, 1);
                WyHelper.removeStackFromInventory(player, itemStack);
                AkumaNoMi randomFruit = this.roulette();
                boolean isAvailable = true;
                if (MainConfig.enableOneFruitPerWorld) {
                    ExtendedWorldData worldProps = ExtendedWorldData.get(world);
                    int chanceForNewFruit = 0;
                    while (DevilFruitsHelper.isDevilFruitInWorld(world, randomFruit)) {
                        AkumaNoMi inContextFruit = randomFruit;
                        this.tier1Fruits.removeIf(x -> x == inContextFruit);
                        this.tier2Fruits.removeIf(x -> x == inContextFruit);
                        this.tier3Fruits.removeIf(x -> x == inContextFruit);
                        if (chanceForNewFruit >= 10) {
                            isAvailable = false;
                            break;
                        }
                        randomFruit = this.roulette();
                        ++chanceForNewFruit;
                    }
                    if (isAvailable) {
                        worldProps.addDevilFruitInWorld(randomFruit);
                    }
                }
                if (isAvailable) {
                    return new ItemStack((Item)randomFruit);
                }
                WyHelper.removeStackFromInventory(player, itemStack);
                return itemStack;
            }
            WyHelper.sendMsgToPlayer(player, "You need a key !");
        }
        return itemStack;
    }

    private AkumaNoMi roulette() {
        Random rand = new Random();
        if ((double)rand.nextInt(100) + rand.nextDouble() <= 98.0) {
            if (this.tier == 1) {
                if ((double)rand.nextInt(100) + rand.nextDouble() < 10.0) {
                    if (this.tier2Fruits.size() > 0) {
                        return this.tier2Fruits.get(rand.nextInt(this.tier2Fruits.size()));
                    }
                } else if (this.tier1Fruits.size() > 0) {
                    return this.tier1Fruits.get(rand.nextInt(this.tier1Fruits.size()));
                }
            } else if (this.tier == 2) {
                if ((double)rand.nextInt(100) + rand.nextDouble() < 10.0) {
                    if (this.tier3Fruits.size() > 0) {
                        return this.tier3Fruits.get(rand.nextInt(this.tier3Fruits.size()));
                    }
                } else if (this.tier2Fruits.size() > 0) {
                    return this.tier2Fruits.get(rand.nextInt(this.tier2Fruits.size()));
                }
            } else if (this.tier == 3 && this.tier3Fruits.size() > 0) {
                return this.tier3Fruits.get(rand.nextInt(this.tier3Fruits.size()));
            }
        }
        return null;
    }
}

