/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.items.weapons;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.extra.AbilityProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;

public class ItemCoreWeapon
extends Item {
    private double damage = 1.0;
    private double multiplier = 1.0;
    private boolean canUseSpecial = false;
    protected boolean isPoisonous = false;
    protected boolean isFireAspect = false;
    protected boolean isSlownessInducing = false;
    protected boolean isStackable = false;
    protected int poisonTimer = 100;
    protected int fireAspectTimer = 100;
    protected int slownessTimer = 100;
    private IIcon baseIcon;
    private IIcon sheathedIcon;
    private IIcon hakiImbuedIcon;

    public ItemCoreWeapon(int damage) {
        this.damage = damage;
        this.field_77777_bU = 1;
        this.func_77664_n();
    }

    public ItemCoreWeapon(int damage, boolean canUseSpecial) {
        this.damage = damage;
        this.canUseSpecial = canUseSpecial;
        this.field_77777_bU = 1;
        this.func_77664_n();
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74768_a("metadata", 0);
            itemStack.func_77978_p().func_74780_a("multiplier", 1.0);
        }
        if (!world.field_72995_K) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)entity);
            double multiplier = 1.0;
            if (entity instanceof EntityPlayer) {
                AbilityProperties abilityProps = AbilityProperties.get((EntityPlayer)entity);
                Ability imbuingBuso = abilityProps.getAbilityFromName(ListAttributes.BUSOSHOKU_HAKI_IMBUING.getAttributeName());
                if (imbuingBuso != null && imbuingBuso.isPassiveActive()) {
                    multiplier += 1.5;
                }
            } else if (props.hasBusoHakiActive()) {
                multiplier += 1.5;
            }
            if (props.isSwordsman()) {
                multiplier += 0.25;
            }
            itemStack.func_77978_p().func_74780_a("multiplier", multiplier);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack itemStack) {
        return EnumAction.block;
    }

    public int func_77619_b() {
        return 14;
    }

    public ItemCoreWeapon setMaxDamage(int maxDamage) {
        super.func_77656_e(maxDamage);
        return this;
    }

    public ItemCoreWeapon setQuality() {
        return this;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        AbilityProperties abilityProps;
        Ability imbuingBuso;
        ExtendedEntityData props = ExtendedEntityData.get(attacker);
        boolean damageSword = true;
        if (attacker instanceof EntityPlayer && (imbuingBuso = (abilityProps = AbilityProperties.get((EntityPlayer)attacker)).getAbilityFromName(ListAttributes.BUSOSHOKU_HAKI_IMBUING.getAttributeName())) != null && imbuingBuso.isPassiveActive()) {
            damageSword = false;
        }
        if (damageSword) {
            itemStack.func_77972_a(1, attacker);
        }
        if (this.isPoisonous) {
            target.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, this.poisonTimer, 0));
        }
        if (this.isFireAspect) {
            target.func_70015_d(this.fireAspectTimer);
        }
        if (this.isSlownessInducing) {
            if (this.isStackable) {
                if (target.func_70644_a(Potion.field_76421_d)) {
                    int timer = target.func_70660_b(Potion.field_76421_d).func_76459_b();
                    target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, timer + this.slownessTimer, 0));
                } else {
                    target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.slownessTimer, 0));
                }
            } else {
                target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, this.slownessTimer, 0));
            }
        }
        return true;
    }

    public ItemCoreWeapon setIsPoisonous() {
        this.isPoisonous = true;
        this.poisonTimer = 100;
        return this;
    }

    public ItemCoreWeapon setIsPoisonous(int timer) {
        this.isPoisonous = true;
        this.poisonTimer = timer;
        return this;
    }

    public ItemCoreWeapon setIsFireAspect() {
        this.isFireAspect = true;
        return this;
    }

    public ItemCoreWeapon setIsFireAspect(int timer) {
        this.isFireAspect = true;
        this.fireAspectTimer = timer;
        return this;
    }

    public ItemCoreWeapon setIsSlownessInducing() {
        this.isSlownessInducing = true;
        return this;
    }

    public ItemCoreWeapon setIsSlownessInducing(int timer) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        return this;
    }

    public ItemCoreWeapon setIsSlownessInducing(int timer, boolean isStackable) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        this.isStackable = isStackable;
        return this;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        double multiplier = 0.0;
        if (stack.func_77978_p() != null) {
            multiplier += stack.func_77978_p().func_74769_h("multiplier");
            multiplier += stack.func_77978_p().func_74769_h("multiplier_black_metal");
            multiplier += stack.func_77978_p().func_74769_h("multiplier_eisen");
        } else {
            multiplier = 1.0;
        }
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.damage * multiplier, 0));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("mineminenomi:" + this.func_77658_a().substring(5));
        try {
            Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("mineminenomi:textures/items/" + this.func_77658_a().substring(5) + "_1.png"));
        }
        catch (Exception e) {
            this.sheathedIcon = this.field_77791_bV;
        }
        try {
            Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("mineminenomi:textures/items/" + this.func_77658_a().substring(5) + "_haki.png"));
        }
        catch (Exception e) {
            this.hakiImbuedIcon = this.field_77791_bV;
        }
        if (this.sheathedIcon != this.field_77791_bV) {
            this.sheathedIcon = ir.func_94245_a("mineminenomi:" + this.func_77658_a().substring(5) + "_1");
        }
        if (this.hakiImbuedIcon != this.field_77791_bV) {
            this.hakiImbuedIcon = ir.func_94245_a("mineminenomi:" + this.func_77658_a().substring(5) + "_haki");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        AbilityProperties abilityProps = AbilityProperties.get(player);
        Ability imbuingBuso = abilityProps.getAbilityFromName(ListAttributes.BUSOSHOKU_HAKI_IMBUING.getAttributeName());
        if (stack.func_77978_p() != null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().equals(stack)) {
                if (imbuingBuso != null && imbuingBuso.isPassiveActive()) {
                    stack.func_77978_p().func_74768_a("metadata", 2);
                    return this.hakiImbuedIcon;
                }
                stack.func_77978_p().func_74768_a("metadata", 0);
                return this.field_77791_bV;
            }
            stack.func_77978_p().func_74768_a("metadata", 1);
            return this.field_77791_bV;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            if (stack.func_77978_p().func_74762_e("metadata") == 1) {
                return this.sheathedIcon;
            }
            if (stack.func_77978_p().func_74762_e("metadata") == 2) {
                return this.hakiImbuedIcon;
            }
            return this.field_77791_bV;
        }
        return this.field_77791_bV;
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        if (block == Blocks.field_150321_G) {
            return 25.0f;
        }
        Material material = block.func_149688_o();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }
}

