/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;

public class PacketSyncInfo
implements IMessage {
    public NBTTagCompound data;
    public String user = "";
    public int entityId;

    public PacketSyncInfo() {
    }

    public PacketSyncInfo(int id, ExtendedEntityData props) {
        this.data = new NBTTagCompound();
        this.entityId = id;
        props.saveNBTData(this.data);
    }

    public PacketSyncInfo(String user, ExtendedEntityData props) {
        this.data = new NBTTagCompound();
        this.user = user;
        props.saveNBTData(this.data);
    }

    public PacketSyncInfo(ExtendedEntityData props) {
        this.data = new NBTTagCompound();
        props.saveNBTData(this.data);
    }

    public void fromBytes(ByteBuf buffer) {
        this.data = ByteBufUtils.readTag((ByteBuf)buffer);
        this.user = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.entityId = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.data);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.user);
        buffer.writeInt(this.entityId);
    }

    public static class ClientHandler
    implements IMessageHandler<PacketSyncInfo, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketSyncInfo message, MessageContext ctx) {
            EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)entityClientPlayerMP);
            int entityID = message.entityId;
            if (message.user != null && !message.user.isEmpty()) {
                EntityPlayer target = null;
                for (Object o : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
                    EntityPlayer t = (EntityPlayer)o;
                    if (!t.getDisplayName().equalsIgnoreCase(message.user)) continue;
                    target = t;
                    break;
                }
                if (target != null && !target.equals((Object)entityClientPlayerMP)) {
                    ExtendedEntityData propz = ExtendedEntityData.get(target);
                    propz.loadNBTData(message.data);
                }
            } else if (entityID != 0) {
                Entity target = null;
                for (Object e : entityClientPlayerMP.field_70170_p.field_72996_f) {
                    if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_145782_y() != entityID) continue;
                    target = (Entity)e;
                    break;
                }
                if (target != null && target instanceof EntityLivingBase && !target.equals((Object)entityClientPlayerMP)) {
                    ExtendedEntityData propz = ExtendedEntityData.get((EntityLivingBase)target);
                    propz.loadNBTData(message.data);
                }
            }
            return null;
        }
    }
}

