/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.quests.questlines.sniperprogression;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.quest.givers.EntityDojoSensei;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.quest.objectives.EntitySniperTarget;
import xyz.pixelatedw.MineMineNoMi3.helpers.ItemsHelper;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketQuestObjectiveSpawn;
import xyz.pixelatedw.MineMineNoMi3.quests.EnumQuestlines;
import xyz.pixelatedw.MineMineNoMi3.quests.IInteractQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IKillQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IProgressionQuest;

public class QuestSniperProgression01
extends Quest
implements IProgressionQuest,
IInteractQuest,
IKillQuest {
    private int questState = 0;

    @Override
    public String getQuestID() {
        return "sniperprogression01";
    }

    @Override
    public String getQuestName() {
        return "Crack Shot";
    }

    @Override
    public String[] getQuestDescription() {
        return new String[]{"", "", "", "", "", "", ""};
    }

    @Override
    public boolean isFinished(EntityPlayer player) {
        boolean flagQuestFailed;
        boolean flagQuestStateInteract = this.questState == 0;
        boolean flagQuestComplete = this.getProgress() < this.getMaxProgress();
        boolean bl = flagQuestFailed = this.questState == 1 && flagQuestComplete && WyHelper.getEntitiesNear((Entity)player, 50.0, EntitySniperTarget.class).size() <= 0;
        if (flagQuestStateInteract || flagQuestFailed) {
            if (!player.field_70170_p.field_72995_K) {
                WyHelper.sendMsgToPlayer(player, "<Sniper Master> Just watch the sky and destroy the targets !");
            }
            this.setProgress(player, 0.0);
            for (int i = 0; i < 6; ++i) {
                EntitySniperTarget target = new EntitySniperTarget(player.field_70170_p);
                double posX = player.field_70165_t + WyMathHelper.randomWithRange(-10, 10);
                double posY = player.field_70163_u + 30.0;
                double posZ = player.field_70161_v + WyMathHelper.randomWithRange(-10, 10);
                target.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
                target.setOwner(player);
                target.setActive(true);
                if (player.field_70170_p.field_72995_K) continue;
                player.field_70170_p.func_72838_d((Entity)target);
            }
            WyNetworkHelper.sendToAll(new PacketQuestObjectiveSpawn(player.func_145782_y()));
            this.questState = 1;
            return super.isFinished(player);
        }
        return !flagQuestStateInteract && !flagQuestComplete;
    }

    @Override
    public void startQuest(EntityPlayer player) {
        WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".started"), (Object[])new Object[0]));
        super.startQuest(player);
    }

    @Override
    public void finishQuest(EntityPlayer player) {
        WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".completed"), (Object[])new Object[0]));
        super.finishQuest(player);
    }

    @Override
    public boolean canStart(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        QuestProperties questProps = QuestProperties.get(player);
        boolean flagSniper = props.isSniper();
        return flagSniper;
    }

    @Override
    public double getMaxProgress() {
        return 6.0;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public EnumQuestlines getQuestLine() {
        return EnumQuestlines.SNIPER_PROGRESSION;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isTarget(EntityPlayer player, EntityLivingBase target) {
        if (this.questState == 0) {
            boolean flagMob = target instanceof EntityDojoSensei;
            if (flagMob) {
                return true;
            }
        } else {
            ItemStack heldItem = player.func_70694_bm();
            boolean flagMob = target instanceof EntitySniperTarget;
            boolean flagBow = ItemsHelper.isBow(heldItem);
            if (flagMob && flagBow) {
                return true;
            }
        }
        return false;
    }
}

