/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.quests.questlines.swordsmanprogression;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import xyz.pixelatedw.MineMineNoMi3.api.WyHelper;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.PacketQuestSync;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.api.quests.Quest;
import xyz.pixelatedw.MineMineNoMi3.api.quests.QuestProperties;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.bandits.BanditData;
import xyz.pixelatedw.MineMineNoMi3.entities.mobs.bandits.EntityBandit;
import xyz.pixelatedw.MineMineNoMi3.helpers.QuestLogicHelper;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.lists.ListQuests;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketQuestObjectiveSpawn;
import xyz.pixelatedw.MineMineNoMi3.quests.EnumQuestlines;
import xyz.pixelatedw.MineMineNoMi3.quests.IInteractQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IKillQuest;
import xyz.pixelatedw.MineMineNoMi3.quests.IProgressionQuest;

public class QuestSwordsmanProgression05
extends Quest
implements IInteractQuest,
IKillQuest,
IProgressionQuest {
    private int questPhase = 0;
    private String lore1 = "Transport Content :";
    private String lore2 = "* 100 TNT Blocks";
    private String lore3 = "* 50 Gunpowder";
    private String lore4 = "";
    private String lore5 = "Delivered to :";
    private String lore6 = "X:0 Y:0 Z:0";
    private String lore7 = "- Simple Text Name";

    @Override
    public String getQuestID() {
        return "swordsmanprogression05";
    }

    @Override
    public String getQuestName() {
        return "Mysterious Note";
    }

    @Override
    public String[] getQuestDescription() {
        return new String[]{"", "", "", "", "", "", ""};
    }

    @Override
    public void startQuest(EntityPlayer player) {
        WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".started"), (Object[])new Object[0]));
        for (int i = 0; i < 6; ++i) {
            EntityBandit target = new EntityBandit(player.field_70170_p);
            double posX = player.field_70165_t + WyMathHelper.randomWithRange(-20, 20);
            double posZ = player.field_70161_v + WyMathHelper.randomWithRange(-20, 20);
            target.func_70012_b(posX, player.field_70163_u, posZ, 0.0f, 0.0f);
            target.setOwner(player);
            target.setActive(true);
            if (player.field_70170_p.field_72995_K) continue;
            player.field_70170_p.func_72838_d((Entity)target);
        }
        WyNetworkHelper.sendToAll(new PacketQuestObjectiveSpawn(player.func_145782_y()));
        this.extraData = new NBTTagCompound();
        this.extraData.func_74768_a("phase", this.questPhase);
        super.startQuest(player);
    }

    @Override
    public boolean canStart(EntityPlayer player) {
        ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
        QuestProperties questProps = QuestProperties.get(player);
        boolean flagSwordsman = props.isSwordsman();
        boolean flagPrevQuest = questProps.hasQuestCompleted(ListQuests.swordsmanProgression04);
        return flagSwordsman && flagPrevQuest;
    }

    @Override
    public void finishQuest(EntityPlayer player) {
        WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".completed"), (Object[])new Object[0]));
        ItemStack itemStack = QuestLogicHelper.getQuestItemStack(player.field_71071_by, this.getQuestID());
        WyHelper.removeStackFromInventory(player, itemStack);
        super.finishQuest(player);
    }

    @Override
    public boolean isFinished(EntityPlayer player) {
        boolean flagQuestStateInteract;
        this.questPhase = this.extraData.func_74762_e("phase");
        boolean flagQuestStateKill = this.questPhase == 0;
        boolean flagNearbyMobs = WyHelper.getEntitiesNear((Entity)player, 20.0, BanditData.class).size() > 0;
        boolean flagQuestComplete = this.getProgress() >= this.getMaxProgress();
        boolean bl = flagQuestStateInteract = this.questPhase == 1;
        if (flagNearbyMobs) {
            if (!player.field_70170_p.field_72995_K) {
                WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".dialogue.01"), (Object[])new Object[0]));
            }
            return false;
        }
        if (flagQuestStateKill && !flagQuestComplete) {
            if (!player.field_70170_p.field_72995_K) {
                WyHelper.sendMsgToPlayer(player, I18n.func_135052_a((String)("quest." + this.getQuestID() + ".dialogue.02"), (Object[])new Object[0]));
            }
            ItemStack mysteriousNote = new ItemStack(ListMisc.Note);
            mysteriousNote.func_151001_c("Mysterious Note");
            mysteriousNote.func_77978_p().func_74778_a("ForQuest", this.getQuestID());
            NBTTagCompound questLore = new NBTTagCompound();
            questLore.func_74778_a("lore1", WyMathHelper.shuffleArray(this.lore1));
            questLore.func_74778_a("lore2", WyMathHelper.shuffleArray(this.lore2));
            questLore.func_74778_a("lore3", WyMathHelper.shuffleArray(this.lore3));
            questLore.func_74778_a("lore4", this.lore4);
            questLore.func_74778_a("lore5", WyMathHelper.shuffleArray(this.lore5));
            questLore.func_74778_a("lore6", WyMathHelper.shuffleArray(this.lore6));
            questLore.func_74778_a("lore7", WyMathHelper.shuffleArray(this.lore7));
            mysteriousNote.func_77978_p().func_74782_a("QuestLore", (NBTBase)questLore);
            player.field_71071_by.func_70441_a(mysteriousNote);
            this.extraData.func_74768_a("phase", 1);
        } else if (flagQuestStateInteract && flagQuestComplete) {
            ItemStack itemStack;
            if (!player.field_70170_p.field_72995_K && (itemStack = QuestLogicHelper.getQuestItemStack(player.field_71071_by, this.getQuestID())) != null && itemStack.func_77942_o()) {
                NBTTagCompound questLore = (NBTTagCompound)itemStack.func_77978_p().func_74781_a("QuestLore");
                if (questLore == null) {
                    return false;
                }
                itemStack.func_151001_c("Deciphered Note");
                questLore.func_74778_a("lore1", this.lore1);
                questLore.func_74778_a("lore2", this.lore2);
                questLore.func_74778_a("lore3", this.lore3);
                questLore.func_74778_a("lore4", this.lore4);
                questLore.func_74778_a("lore5", this.lore5);
                questLore.func_74778_a("lore6", this.lore6);
                questLore.func_74778_a("lore7", this.lore7);
                itemStack.func_77978_p().func_74782_a("QuestLore", (NBTBase)questLore);
            }
            return true;
        }
        return false;
    }

    @Override
    public double getMaxProgress() {
        return 6.0;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public EnumQuestlines getQuestLine() {
        return EnumQuestlines.SWORDSMAN_PROGRESSION;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isTarget(EntityPlayer player, EntityLivingBase target) {
        this.questPhase = this.extraData.func_74762_e("phase");
        if (this.questPhase == 0) {
            boolean flagCompletion;
            boolean flagMob = target instanceof BanditData;
            boolean bl = flagCompletion = this.getProgress() < this.getMaxProgress() - 1.0;
            if (flagMob && flagCompletion) {
                return true;
            }
        } else if (this.questPhase == 1) {
            boolean flagIncomplete;
            boolean flagMob = target instanceof EntityVillager;
            boolean flagLibrarian = flagMob && ((EntityVillager)target).func_70946_n() == 1;
            boolean bl = flagIncomplete = this.getProgress() < this.getMaxProgress();
            if (flagMob && flagLibrarian && flagIncomplete) {
                this.setProgress(player, this.getMaxProgress());
                WyNetworkHelper.sendTo(new PacketQuestSync(QuestProperties.get(player)), (EntityPlayerMP)player);
                target.func_85030_a("mob.villager.yes", 1.0f, 1.0f);
                this.isFinished(player);
                return true;
            }
        }
        return false;
    }
}

