/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.soros;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import xyz.pixelatedw.MineMineNoMi3.MainConfig;
import xyz.pixelatedw.MineMineNoMi3.Values;
import xyz.pixelatedw.MineMineNoMi3.api.abilities.Ability;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.api.network.WyNetworkHelper;
import xyz.pixelatedw.MineMineNoMi3.data.ExtendedEntityData;
import xyz.pixelatedw.MineMineNoMi3.lists.ListAttributes;
import xyz.pixelatedw.MineMineNoMi3.lists.ListExtraAttributes;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSync;
import xyz.pixelatedw.MineMineNoMi3.packets.PacketSyncInfo;
import xyz.pixelatedw.MineMineNoMi3.soros.MochiMochiNoMiProjectiles;

public class MochiMochiNoMiAbilities {
    public static final Ability MochiBall;
    public static final Ability MochiStream;
    public static final Ability Rocket;
    public static final Ability Gatling;
    public static final Ability Chikara;
    public static final Ability Wheel;
    public static final Ability YakiMochi;
    public static Ability[] abilitiesArray;

    static {
        Values.abilityWebAppExtraParams.put("Mochi Boru", new String[]{"desc", "Give slowness to the target."});
        Values.abilityWebAppExtraParams.put("Mochi San-Boru", new String[]{"desc", "Same as Mochi ball but send 3 balls."});
        Values.abilityWebAppExtraParams.put("Sutorimu Mochi", new String[]{"desc", "sends a continuous line of mochi balls for 4-5 seconds."});
        Values.abilityWebAppExtraParams.put("Kaku Mochi", new String[]{"desc", "Sends 1 large white mochi balls into the opponent."});
        Values.abilityWebAppExtraParams.put("Mochi Gatling", new String[]{"desc", "Sends 1 large white mochi balls into the opponent."});
        Values.abilityWebAppExtraParams.put("Chikara Mochi", new String[]{"desc", "Sends 1 large mochif fist."});
        Values.abilityWebAppExtraParams.put("Wheel Dash", new String[]{"desc", "Turn to a wheel and dash"});
        MochiBall = new MochiBall();
        MochiStream = new MochiStream();
        Rocket = new Rocket();
        Gatling = new MochiNoGatling();
        Chikara = new ChikaraMochi();
        Wheel = new WheelDash();
        YakiMochi = new YakiMochi();
        abilitiesArray = new Ability[]{Wheel, MochiBall, MochiStream, Rocket, Gatling, Chikara, YakiMochi};
    }

    public static class ChikaraMochi
    extends Ability {
        public ChikaraMochi() {
            super(ListAttributes.ChikaraMochi);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.ChikaraMochi(player.field_70170_p, (EntityLivingBase)player, ListAttributes.ChikaraMochi);
            super.use(player);
        }
    }

    public static class WheelDash
    extends Ability {
        public WheelDash() {
            super(ListAttributes.WHEELDASH);
        }

        @Override
        public void passive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (!this.isOnCooldown && (props.getZoanPoint().equalsIgnoreCase("n/a") || props.getZoanPoint().equalsIgnoreCase("wheel"))) {
                super.passive(player);
            }
        }

        @Override
        public void startPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            if (props.getZoanPoint().isEmpty()) {
                props.setZoanPoint("n/a");
            }
            props.setZoanPoint("wheel");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }

        @Override
        public void endPassive(EntityPlayer player) {
            ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
            props.setZoanPoint("n/a");
            WyNetworkHelper.sendTo(new PacketSync(props), (EntityPlayerMP)player);
            WyNetworkHelper.sendToAll(new PacketSyncInfo(player.getDisplayName(), props));
        }
    }

    public static class MochiNoGatling
    extends Ability {
        public MochiNoGatling() {
            super(ListAttributes.MOCHIGATLING);
        }

        @Override
        public void use(EntityPlayer player) {
            if (!this.isOnCooldown) {
                ExtendedEntityData props = ExtendedEntityData.get((EntityLivingBase)player);
                boolean type = true;
                int projectileSpace = 3;
                if (MainConfig.enableAnimeScreaming) {
                    this.attr.setAbilityDisplayName("Mochi Gatling");
                }
                this.attr.setAbilityCooldown(2.0);
                for (int j = 0; j < 25; ++j) {
                    MochiMochiNoMiProjectiles.MochiGatling proj = new MochiMochiNoMiProjectiles.MochiGatling(player.field_70170_p, (EntityLivingBase)player, ListExtraAttributes.MOCHIGATLING);
                    proj.func_70012_b(player.field_70165_t + WyMathHelper.randomWithRange(-projectileSpace, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70163_u + 0.3 + WyMathHelper.randomWithRange(0, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), player.field_70161_v + WyMathHelper.randomWithRange(-projectileSpace, projectileSpace) + player.field_70170_p.field_73012_v.nextDouble(), 0.0f, 0.0f);
                    player.field_70170_p.func_72838_d((Entity)proj);
                }
                super.use(player);
            }
        }
    }

    public static class Rocket
    extends Ability {
        public Rocket() {
            super(ListAttributes.MOCHIROCKET);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.MochiRocket(player.field_70170_p, (EntityLivingBase)player, ListAttributes.MOCHIROCKET);
            super.use(player);
        }
    }

    public static class MochiStream
    extends Ability {
        public MochiStream() {
            super(ListAttributes.BuzzMochi);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.BuzzMochi(player.field_70170_p, (EntityLivingBase)player, ListAttributes.BuzzMochi);
            super.use(player);
        }
    }

    public static class Barrage
    extends Ability {
        public int repeater = 0;

        public Barrage() {
            super(ListAttributes.MOCHIBARAGE);
        }

        @Override
        public void duringRepeater(EntityPlayer player) {
            super.duringRepeater(player);
            player.field_70177_z = this.repeater % 2 == 0 ? (player.field_70177_z += 10.0f) : (player.field_70177_z -= 20.0f);
            ++this.repeater;
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.MochiBall(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            this.projectile = new MochiMochiNoMiProjectiles.MochiBall(player.field_70170_p, player.field_70165_t + 7.0, player.field_70163_u, player.field_70161_v + 7.0);
            this.projectile = new MochiMochiNoMiProjectiles.MochiBall(player.field_70170_p, player.field_70165_t - 7.0, player.field_70163_u, player.field_70161_v - 7.0);
            super.use(player);
        }
    }

    public static class MochiBall
    extends Ability {
        public MochiBall() {
            super(ListAttributes.MOCHIBALL);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.MochiBall(player.field_70170_p, (EntityLivingBase)player, ListAttributes.MOCHIBALL);
            super.use(player);
        }
    }

    public static class YakiMochi
    extends Ability {
        public YakiMochi() {
            super(ListAttributes.YakiMochi);
        }

        @Override
        public void use(EntityPlayer player) {
            this.projectile = new MochiMochiNoMiProjectiles.YAKI(player.field_70170_p, (EntityLivingBase)player, ListAttributes.YakiMochi);
            super.use(player);
        }
    }
}

