/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.world.structures;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import xyz.pixelatedw.MineMineNoMi3.api.math.WyMathHelper;
import xyz.pixelatedw.MineMineNoMi3.blocks.tileentities.TileEntityCustomSpawner;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;

public abstract class Structure {
    protected static void addChestLoot(World world, TileEntityChest te, double rarity, ItemStack loot) {
        if (Structure.getRandomChance(world) <= rarity) {
            te.func_70299_a((int)WyMathHelper.randomWithRange(0, 26), loot);
        }
    }

    protected static void addChestLoot(World world, TileEntityChest te, double rarity, Item loot, int min, int max) {
        Structure.addChestLoot(world, te, rarity, loot, 0, min, max);
    }

    protected static void addChestLoot(World world, TileEntityChest te, double rarity, Item loot, int metadata, int min, int max) {
        if (Structure.getRandomChance(world) <= rarity) {
            int chance;
            int n = chance = max <= 0 ? min : (int)WyMathHelper.randomWithRange(min, max);
            if (chance > 0) {
                te.func_70299_a((int)WyMathHelper.randomWithRange(0, 26), new ItemStack(loot, chance, metadata));
            }
        }
    }

    protected static void addChestTileEntity(World world, int[][] positions, int maxChests, Consumer<TileEntityChest> lootList) {
        try {
            ArrayList<TileEntityChest> chests = new ArrayList<TileEntityChest>();
            for (int[] pos : positions) {
                TileEntityChest chest = new TileEntityChest();
                world.func_147455_a(pos[0], pos[1], pos[2], (TileEntity)chest);
                chests.add(chest);
            }
            WyMathHelper.shuffle(chests);
            int index = 0;
            for (TileEntityChest chest : chests) {
                if (maxChests <= 0 || index <= maxChests) {
                    lootList.accept(chest);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void addSpawnerTileEntity(World world, int[][] positions, String mobName, int min, int max) {
        try {
            ArrayList spawners = new ArrayList();
            String mob = "mineminenomi." + mobName;
            for (int[] pos : positions) {
                int chance = max <= 0 ? min : (int)WyMathHelper.randomWithRange(min, max);
                TileEntityCustomSpawner spawner = new TileEntityCustomSpawner().setSpawnerMob(mob).setSpawnerLimit(chance);
                world.func_147449_b(pos[0], pos[1], pos[2], (Block)ListMisc.CustomSpawner);
                world.func_147455_a(pos[0], pos[1], pos[2], (TileEntity)spawner);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Enchantment getEnchantment() {
        Enchantment ench = null;
        switch ((int)WyMathHelper.randomWithRange(0, 5)) {
            case 0: {
                ench = Enchantment.field_77338_j;
                return ench;
            }
            case 1: {
                ench = Enchantment.field_77336_l;
                return ench;
            }
            case 2: {
                ench = Enchantment.field_77349_p;
                return ench;
            }
            case 3: {
                ench = Enchantment.field_77332_c;
                return ench;
            }
            case 4: {
                ench = Enchantment.field_92091_k;
                return ench;
            }
            case 5: {
                ench = Enchantment.field_77347_r;
                return ench;
            }
        }
        ench = Enchantment.field_77338_j;
        return ench;
    }

    protected static double getRandomChance(World world) {
        return (double)world.field_73012_v.nextInt(100) + world.field_73012_v.nextDouble();
    }
}

