/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.MineMineNoMi3.world.structures;

import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import xyz.pixelatedw.MineMineNoMi3.api.Schematic;
import xyz.pixelatedw.MineMineNoMi3.api.WySchematicHelper;
import xyz.pixelatedw.MineMineNoMi3.items.weapons.ItemCoreWeapon;
import xyz.pixelatedw.MineMineNoMi3.lists.ListMisc;
import xyz.pixelatedw.MineMineNoMi3.world.MainWorldGen;
import xyz.pixelatedw.MineMineNoMi3.world.structures.Structure;

public class StructureLargeShip
extends Structure {
    public static boolean build(Schematic sch, World world, int posX, int posY, int posZ, BiomeGenBase biome) {
        boolean flagSpecialCheck;
        boolean flagBiome = biome != BiomeGenBase.field_76771_b && biome != BiomeGenBase.field_150575_M;
        boolean bl = flagSpecialCheck = !MainWorldGen.checkForWaterSpawn(sch, world, posX, posY, posZ);
        if (flagBiome || flagSpecialCheck) {
            return false;
        }
        WySchematicHelper.build(sch, world, posX, posY, posZ);
        StructureLargeShip.populate(posX, posY, posZ, world, sch.getName());
        return true;
    }

    public static void populate(int posX, int posY, int posZ, World world, String faction) {
        ItemCoreWeapon itemCoreWeapon;
        String boss;
        String trashWithGun;
        String trashWithSword;
        if (faction.equals("marineLargeShip")) {
            trashWithSword = "Marine with Sword";
            trashWithGun = "Marine with Gun";
            boss = "Marine Captain";
            itemCoreWeapon = ListMisc.MarineSword;
        } else {
            trashWithSword = "Pirate with Sword";
            trashWithGun = "Pirate with Gun";
            boss = "Pirate Captain";
            itemCoreWeapon = ListMisc.PirateCutlass;
        }
        int[][] trash01SpawnerPositions = new int[][]{{posX + 10, posY + 6, posZ + 27}, {posX + 10, posY + 12, posZ + 13}, {posX + 8, posY + 12, posZ + 42}};
        StructureLargeShip.addSpawnerTileEntity(world, trash01SpawnerPositions, trashWithSword, 4, 6);
        int[][] trash02SpawnerPositions = new int[][]{{posX + 10, posY + 6, posZ + 20}, {posX + 10, posY + 12, posZ + 10}};
        StructureLargeShip.addSpawnerTileEntity(world, trash02SpawnerPositions, trashWithGun, 3, 5);
        int[][] bossSpawnerPositions = new int[][]{{posX + 12, posY + 12, posZ + 42}};
        StructureLargeShip.addSpawnerTileEntity(world, bossSpawnerPositions, boss, 1, 0);
        TileEntityChest combatChest = new TileEntityChest();
        world.func_147455_a(posX + 6, posY + 6, posZ + 39, (TileEntity)combatChest);
        StructureLargeShip.addChestLoot(world, combatChest, 100.0, ListMisc.Bullets, 5, 10);
        StructureLargeShip.addChestLoot(world, combatChest, 100.0, ListMisc.Bullets, 10, 15);
        StructureLargeShip.addChestLoot(world, combatChest, 80.0, Items.field_151124_az, 1, 0);
        StructureLargeShip.addChestLoot(world, combatChest, 80.0, ListMisc.BellyPouch, 2, 6);
        StructureLargeShip.addChestLoot(world, combatChest, 50.0, ListMisc.BellyPouch, 6, 10);
        StructureLargeShip.addChestLoot(world, combatChest, 50.0, ListMisc.KairosekiBullets, 3, 5);
        StructureLargeShip.addChestLoot(world, combatChest, 45.0, itemCoreWeapon, 0, 1);
        StructureLargeShip.addChestLoot(world, combatChest, 45.0, ListMisc.Flintlock, 0, 1);
        StructureLargeShip.addChestLoot(world, combatChest, 20.0, ListMisc.BellyPouch, 1, 0);
        StructureLargeShip.addChestLoot(world, combatChest, 10.0, ListMisc.Box1, 1, 0);
        TileEntityChest foodChest = new TileEntityChest();
        world.func_147455_a(posX + 13, posY + 6, posZ + 39, (TileEntity)foodChest);
        StructureLargeShip.addChestLoot(world, foodChest, 100.0, Items.field_151025_P, 1, 3);
        StructureLargeShip.addChestLoot(world, foodChest, 100.0, Items.field_151025_P, 1, 2);
        if (StructureLargeShip.getRandomChance(world) <= 10.0) {
            StructureLargeShip.addChestLoot(world, foodChest, 45.0, Items.field_151127_ba, 5, 10);
        }
        StructureLargeShip.addChestLoot(world, foodChest, 45.0, Items.field_151168_bH, 0, 5);
        StructureLargeShip.addChestLoot(world, foodChest, 45.0, Items.field_151034_e, 1, 10);
        if (StructureLargeShip.getRandomChance(world) <= 70.0) {
            StructureLargeShip.addChestLoot(world, foodChest, 45.0, Items.field_151127_ba, 5, 10);
        }
        StructureLargeShip.addChestLoot(world, foodChest, 20.0, ListMisc.Cola, 0, 3);
        if (StructureLargeShip.getRandomChance(world) <= 50.0) {
            StructureLargeShip.addChestLoot(world, foodChest, 10.0, Items.field_151077_bg, 0, 2);
            if (StructureLargeShip.getRandomChance(world) <= 50.0) {
                StructureLargeShip.addChestLoot(world, foodChest, 10.0, Items.field_151101_aQ, 1, 4);
            } else {
                StructureLargeShip.addChestLoot(world, foodChest, 10.0, Items.field_151101_aQ, 1, 1, 4);
            }
        } else {
            StructureLargeShip.addChestLoot(world, foodChest, 10.0, Items.field_151077_bg, 1, 2);
        }
        StructureLargeShip.addChestLoot(world, foodChest, 10.0, ListMisc.Cola, 0, 5);
        TileEntityChest specialChest = new TileEntityChest();
        world.func_147455_a(posX + 9, posY + 6, posZ + 42, (TileEntity)specialChest);
        StructureLargeShip.addChestLoot(world, specialChest, 75.0, ListMisc.BellyPouch, 1, 6);
        StructureLargeShip.addChestLoot(world, specialChest, 70.0, ListMisc.KairosekiBullets, 5, 10);
        StructureLargeShip.addChestLoot(world, specialChest, 65.0, ListMisc.BellyPouch, 3, 8);
        StructureLargeShip.addChestLoot(world, specialChest, 50.0, Items.field_151124_az, 1, 0);
        StructureLargeShip.addChestLoot(world, specialChest, 35.0, ListMisc.BellyPouch, 5, 6);
        StructureLargeShip.addChestLoot(world, specialChest, 35.0, ListMisc.BlackMetal, 1, 2);
        StructureLargeShip.addChestLoot(world, specialChest, 20.0, ListMisc.Box1, 1, 0);
        StructureLargeShip.addChestLoot(world, specialChest, 20.0, ListMisc.UltraCola, 1, 0);
        StructureLargeShip.addChestLoot(world, specialChest, 15.0, ListMisc.Box2, 1, 0);
        StructureLargeShip.addChestLoot(world, specialChest, 10.0, ListMisc.Box3, 1, 0);
    }
}

