/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.client.tabs;

import java.util.ArrayList;
import java.util.function.Consumer;
import micdoodle8.mods.galacticraft.api.client.tabs.AbstractTab;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TabRegistry {
    private static ArrayList<AbstractTab> tabList = new ArrayList();
    private static Class<?> clazzJEIConfig = null;
    public static Class<?> clazzNEIConfig = null;
    private static Minecraft mc;
    private static boolean initWithPotion;
    public static int recipeBookOffset;

    public static void registerEventListeners(IEventBus bus) {
        bus.addListener(TabRegistry::guiPostInit);
    }

    public static void registerTab(AbstractTab tab) {
        tabList.add(tab);
    }

    public static ArrayList<AbstractTab> getTabList() {
        return tabList;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void guiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof InventoryScreen) {
            int guiLeft = (event.getGui().field_230708_k_ - 176) / 2;
            int guiTop = (event.getGui().field_230709_l_ - 166) / 2;
            recipeBookOffset = TabRegistry.getRecipeBookOffset((InventoryScreen)event.getGui());
            TabRegistry.updateTabValues(guiLeft += TabRegistry.getPotionOffset() + recipeBookOffset, guiTop, InventoryTabVanilla.class);
            TabRegistry.addTabsToList(arg_0 -> ((GuiScreenEvent.InitGuiEvent.Post)event).addWidget(arg_0));
        }
    }

    public static void openInventoryGui() {
        TabRegistry.mc.field_71439_g.field_71174_a.func_147297_a((IPacket)new CCloseWindowPacket(TabRegistry.mc.field_71439_g.field_71070_bA.field_75152_c));
        InventoryScreen inventory = new InventoryScreen((PlayerEntity)TabRegistry.mc.field_71439_g);
        mc.func_147108_a((Screen)inventory);
    }

    public static void updateTabValues(int cornerX, int cornerY, Class<?> selectedButton) {
        int count = 2;
        for (int i = 0; i < tabList.size(); ++i) {
            AbstractTab t = tabList.get(i);
            if (!t.shouldAddToList()) continue;
            t.setIndex(count);
            t.field_230690_l_ = cornerX + (count - 2) * 28;
            t.field_230691_m_ = cornerY - 28;
            t.field_230693_o_ = !((Object)((Object)t)).getClass().equals(selectedButton);
            t.potionOffsetLast = TabRegistry.getPotionOffsetNEI();
            ++count;
        }
    }

    public static void addTabsToList(Consumer<Widget> add) {
        for (AbstractTab tab : tabList) {
            if (!tab.shouldAddToList()) continue;
            add.accept((Widget)tab);
        }
    }

    public static int getPotionOffset() {
        initWithPotion = false;
        return 0;
    }

    public static boolean doPotionOffsetVanilla() {
        for (EffectInstance potioneffect : TabRegistry.mc.field_71439_g.func_70651_bq()) {
            if (!potioneffect.func_188419_a().shouldRender(potioneffect)) continue;
            return true;
        }
        return false;
    }

    public static int getPotionOffsetJEI() {
        if (clazzJEIConfig != null) {
            try {
                Object enabled = clazzJEIConfig.getMethod("isOverlayEnabled", new Class[0]).invoke(null, new Object[0]);
                if (enabled instanceof Boolean) {
                    if (!((Boolean)enabled).booleanValue()) {
                        return 0;
                    }
                    return -60;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getPotionOffsetNEI() {
        if (initWithPotion && clazzNEIConfig != null) {
            try {
                Object hidden = clazzNEIConfig.getMethod("isHidden", new Class[0]).invoke(null, new Object[0]);
                Object enabled = clazzNEIConfig.getMethod("isEnabled", new Class[0]).invoke(null, new Object[0]);
                if (hidden instanceof Boolean && enabled instanceof Boolean) {
                    if (((Boolean)hidden).booleanValue() || !((Boolean)enabled).booleanValue()) {
                        return 0;
                    }
                    return -60;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getRecipeBookOffset(InventoryScreen gui) {
        boolean widthTooNarrow = gui.field_230708_k_ < 379;
        gui.func_194310_f().func_201520_a(gui.field_230708_k_, gui.field_230709_l_, mc, widthTooNarrow, (RecipeBookContainer)Minecraft.func_71410_x().field_71439_g.field_71069_bz);
        return gui.func_194310_f().func_193011_a(widthTooNarrow, gui.field_230708_k_, gui.getXSize()) - (gui.field_230708_k_ - 176) / 2;
    }

    static {
        try {
            clazzJEIConfig = Class.forName("mezz.jei.config.Config");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazzJEIConfig == null) {
            try {
                clazzNEIConfig = Class.forName("codechicken.nei.NEIClientConfig");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        mc = Minecraft.func_71410_x();
    }
}

