/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.common.IBlockEntityHandler;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.network.UpdateSkinDocumentPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentExporter;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentImporter;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.exception.TranslatableException;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AdvancedBuilderBlockEntity
extends UpdatableBlockEntity
implements IBlockEntityHandler,
SkinDocumentProvider {
    private AxisAlignedBB renderBoundingBox;
    public final Vector3f carmeOffset = new Vector3f();
    public final Vector3f carmeRot = new Vector3f();
    public final Vector3f carmeScale = new Vector3f(1.0f, 1.0f, 1.0f);
    public Vector3f offset = new Vector3f(0.0f, 12.0f, 0.0f);
    private final SkinDocument document = new SkinDocument();

    public Vector3f getRenderOrigin() {
        BlockPos pos = this.func_174877_v();
        return new Vector3f((float)pos.func_177958_n() + this.offset.getX() + 0.5f, (float)pos.func_177956_o() + this.offset.getY() + 0.5f, (float)pos.func_177952_p() + this.offset.getZ() + 0.5f);
    }

    public AdvancedBuilderBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.document.addListener(new SkinDocumentListeners.Updater(this));
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        this.document.deserializeNBT(tag);
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        this.document.serializeNBT(tag);
    }

    public void importToNode(String identifier, Skin skin, SkinDocumentNode node) {
        SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
        node.setSkin(descriptor);
        CompoundNBT tag = new CompoundNBT();
        OptionalAPI.putOptionalSkinDescriptor(tag, "Skin", descriptor, null);
        UpdateSkinDocumentPacket.UpdateNodeAction action = new UpdateSkinDocumentPacket.UpdateNodeAction(node.getId(), tag);
        NetworkManager.sendToAll(new UpdateSkinDocumentPacket(this, action));
        if (skin.getItemTransforms() != null) {
            this.importToSettings(skin.getItemTransforms(), node);
        }
    }

    private void importToSettings(SkinItemTransforms itemTransforms, SkinDocumentNode node) {
        Collection<String> overrideNames;
        SkinItemTransforms newItemTransforms = new SkinItemTransforms();
        if (this.document.getItemTransforms() != null) {
            newItemTransforms.putAll(this.document.getItemTransforms());
        }
        if (!(overrideNames = SkinUtils.getItemOverrides(node.getType())).isEmpty()) {
            overrideNames.forEach(name -> itemTransforms.forEach((type, transform) -> newItemTransforms.put(name + ";" + type, transform)));
        } else {
            newItemTransforms.putAll(itemTransforms);
        }
        this.document.setItemTransforms(newItemTransforms);
        CompoundNBT tag = new CompoundNBT();
        OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", itemTransforms, null);
        UpdateSkinDocumentPacket.UpdateSettingsAction action = new UpdateSkinDocumentPacket.UpdateSettingsAction(tag);
        NetworkManager.sendToAll(new UpdateSkinDocumentPacket(this, action));
    }

    public void importToDocument(String identifier, Skin skin) {
        BlockUtils.performBatch(() -> {
            SkinDocumentImporter importer = new SkinDocumentImporter(this.document);
            this.document.reset();
            this.document.setItemTransforms(skin.getItemTransforms());
            importer.execute(identifier, skin);
        });
    }

    public void exportFromDocument(ServerPlayerEntity player) {
        SkinDocumentExporter exporter = new SkinDocumentExporter(this.document);
        exporter.setItemTransforms(this.document.getItemTransforms());
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                Skin skin = exporter.execute((PlayerEntity)player);
                player.field_71133_b.execute(() -> {
                    String identifier = SkinLoader.getInstance().saveSkin("", skin);
                    SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.getType());
                    ItemStack itemStack = descriptor.asItemStack();
                    SkinUtils.giveTo(itemStack, (PlayerEntity)player);
                });
            }
            catch (TranslatableException exception) {
                UserNotifications.sendErrorMessage(exception.getComponent(), (PlayerEntity)player);
            }
        });
    }

    @Override
    public SkinDocument getDocument() {
        return this.document;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getCustomRenderBoundingBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        float s = 16.0f;
        Vector3f origin = this.getRenderOrigin();
        Rectangle3f rect = new Rectangle3f(origin.getX() - s / 2.0f, origin.getY() - s / 2.0f, origin.getZ() - s / 2.0f, s, s, s);
        this.renderBoundingBox = rect.asAABB();
        return this.renderBoundingBox;
    }
}

