/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentEditor;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.builder.data.properties.VectorProperty;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSettings;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;

public class DocumentConnector {
    private final DocumentEditor editor;
    private final ArrayList<Consumer<SkinDocumentNode>> nodeListeners = new ArrayList();
    private final ArrayList<Consumer<SkinDocumentSettings>> settingsListeners = new ArrayList();
    private final ArrayList<Consumer<SkinProperties>> propertiesListeners = new ArrayList();
    public final DataProperty<String> name = this.registerNode(DataProperty::new, SkinDocumentNode::getName, SkinDocumentNode::setName);
    public final DataProperty<SkinDescriptor> part = this.registerNode(DataProperty::new, SkinDocumentNode::getSkin, SkinDocumentNode::setSkin);
    public final DataProperty<Boolean> lock = this.registerNode(DataProperty::new, SkinDocumentNode::isLocked, (xva$0, xva$1) -> Objects.hashCode((Object[])new Object[]{xva$0, xva$1}));
    public final VectorProperty location = this.registerNode(VectorProperty::new, SkinDocumentNode::getLocation, SkinDocumentNode::setLocation);
    public final VectorProperty rotation = this.registerNode(VectorProperty::new, SkinDocumentNode::getRotation, SkinDocumentNode::setRotation);
    public final VectorProperty scale = this.registerNode(VectorProperty::new, SkinDocumentNode::getScale, SkinDocumentNode::setScale);
    public final VectorProperty pivot = this.registerNode(VectorProperty::new, SkinDocumentNode::getPivot, SkinDocumentNode::setPivot);
    public final DataProperty<Boolean> enabled = this.registerNode(DataProperty::new, SkinDocumentNode::isEnabled, SkinDocumentNode::setEnabled);
    public final DataProperty<Boolean> mirror = this.registerNode(DataProperty::new, SkinDocumentNode::isMirror, SkinDocumentNode::setMirror);
    public final DataProperty<String> itemName = this.registerProperties(DataProperty::new, SkinProperty.ALL_CUSTOM_NAME);
    public final DataProperty<String> itemFlavour = this.registerProperties(DataProperty::new, SkinProperty.ALL_FLAVOUR_TEXT);
    public final DataProperty<Boolean> showOrigin = this.registerSettings(DataProperty::new, SkinDocumentSettings::showsOrigin, SkinDocumentSettings::setShowsOrigin);
    public final DataProperty<Boolean> showHelperModel = this.registerSettings(DataProperty::new, SkinDocumentSettings::showsHelperModel, SkinDocumentSettings::setShowsHelperModel);
    private SkinDocument document;
    private SkinDocumentNode node;

    public DocumentConnector(SkinDocument document, DocumentEditor editor) {
        this.editor = editor;
        this.document = document;
    }

    public void update(SkinDocumentSettings settings) {
        this.settingsListeners.forEach((Consumer<Consumer<SkinDocumentSettings>>)((Consumer<Consumer>)it -> it.accept(settings)));
    }

    public void update(SkinProperties properties) {
        this.propertiesListeners.forEach((Consumer<Consumer<SkinProperties>>)((Consumer<Consumer>)it -> it.accept(properties)));
    }

    public void update(SkinDocumentNode node) {
        this.node = node;
        this.nodeListeners.forEach((Consumer<Consumer<SkinDocumentNode>>)((Consumer<Consumer>)it -> it.accept(node)));
    }

    public void addListener(Consumer<SkinDocumentNode> consumer) {
        this.nodeListeners.add(consumer);
    }

    public void removeListener(Consumer<SkinDocumentNode> consumer) {
        this.nodeListeners.remove(consumer);
    }

    public SkinDocumentNode getNode() {
        return this.node;
    }

    public DocumentEditor getEditor() {
        return this.editor;
    }

    public <T, P extends DataProperty<T>> P registerProperties(Supplier<P> factory, ISkinProperty<T> key) {
        DataProperty property = (DataProperty)factory.get();
        property.addEditingObserver(flag -> {
            if (flag.booleanValue()) {
                this.editor.beginEditing();
            } else {
                this.editor.endEditing();
            }
        });
        property.addObserver(newValue -> {
            Object oldValue = this.document.get(key);
            if (!Objects.equal(oldValue, (Object)newValue)) {
                this.document.put(key, newValue);
            }
        });
        this.propertiesListeners.add(properties -> {
            Object newValue;
            Object oldValue = property.get();
            if (!Objects.equal(oldValue, newValue = this.document.get(key))) {
                property.set(newValue);
            }
        });
        return (P)property;
    }

    public <T, P extends DataProperty<T>> P registerSettings(Supplier<P> factory, Function<SkinDocumentSettings, T> getter, BiConsumer<SkinDocumentSettings, T> setter) {
        DataProperty property = (DataProperty)factory.get();
        property.addEditingObserver(flag -> {
            if (flag.booleanValue()) {
                this.editor.beginEditing();
            } else {
                this.editor.endEditing();
            }
        });
        property.addObserver(newValue -> {
            Object oldValue = getter.apply(this.document.getSettings());
            if (!Objects.equal(oldValue, (Object)newValue)) {
                setter.accept(this.document.getSettings(), newValue);
            }
        });
        this.settingsListeners.add(node -> {
            Object newValue;
            Object oldValue = property.get();
            if (!Objects.equal(oldValue, newValue = getter.apply(this.document.getSettings()))) {
                property.set(newValue);
            }
        });
        return (P)property;
    }

    public <T, P extends DataProperty<T>> P registerNode(Supplier<P> factory, Function<SkinDocumentNode, T> getter, BiConsumer<SkinDocumentNode, T> setter) {
        DataProperty property = (DataProperty)factory.get();
        property.addEditingObserver(flag -> {
            if (flag.booleanValue()) {
                this.editor.beginEditing();
            } else {
                this.editor.endEditing();
            }
        });
        property.addObserver(newValue -> {
            Object oldValue = getter.apply(this.node);
            if (!Objects.equal(oldValue, (Object)newValue)) {
                setter.accept(this.node, newValue);
            }
        });
        this.nodeListeners.add(node -> {
            Object newValue;
            Object oldValue = property.get();
            if (!Objects.equal(oldValue, newValue = getter.apply((SkinDocumentNode)node))) {
                property.set(newValue);
            }
        });
        return (P)property;
    }
}

