/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document;

import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIMenuItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentConnector;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentMenuBuilder;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.document.DocumentPasteboard;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeView;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentSynchronizer;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;

public class DocumentEditor {
    private final AdvancedBuilderBlockEntity blockEntity;
    private final SkinDocument document;
    private final SkinDocumentSynchronizer synchronizer;
    private final DocumentConnector connector;

    public DocumentEditor(AdvancedBuilderBlockEntity blockEntity) {
        this.document = blockEntity.getDocument();
        this.blockEntity = blockEntity;
        this.connector = new DocumentConnector(this.document, this);
        this.synchronizer = new SkinDocumentSynchronizer(blockEntity);
    }

    public void connect() {
        this.document.addListener(this.synchronizer);
    }

    public void disconnect() {
        this.document.removeListener(this.synchronizer);
    }

    public void changeTypeAction(SkinDocumentType type) {
        this.document.setType(type);
    }

    public void nodeAddAction(SkinDocumentNode node) {
        SkinDocumentNode newValue = new SkinDocumentNode("New Node");
        newValue.setName(this._resolveName(newValue.getName(), node.children()));
        node.insertAtIndex(newValue, 0);
        this.nodeSelectAction(newValue);
    }

    public void nodeAddLocatorAction(SkinDocumentNode node) {
        SkinDocumentNode newValue = new SkinDocumentNode("New Locator");
        newValue.setType(SkinPartTypes.ADVANCED_LOCATOR);
        newValue.setName(this._resolveName(newValue.getName(), node.children()));
        node.insertAtIndex(newValue, 0);
        this.nodeSelectAction(newValue);
    }

    public void nodeMoveUpAction(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        parent.moveTo(node, parent.children().indexOf(node) - 1);
    }

    public void nodeMoveDownAction(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        parent.moveTo(node, parent.children().indexOf(node) + 1);
    }

    public void nodeMoveToTopAction(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        parent.moveTo(node, 0);
    }

    public void nodeMoveToBottomAction(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        parent.moveTo(node, 10000);
    }

    public void nodeRemoveAction(SkinDocumentNode node, TreeView treeView) {
        ConfirmDialog alert = new ConfirmDialog();
        alert.setTitle(NSString.localizedString("advanced-skin-builder.dialog.delete.title", new Object[0]));
        alert.setMessage(NSString.localizedString("advanced-skin-builder.dialog.delete.message", node.getName()));
        alert.showInView(treeView, () -> {
            if (!alert.isCancelled()) {
                node.removeFromParent();
            }
        });
    }

    public void nodeCopyAction(SkinDocumentNode node) {
        DocumentPasteboard.getInstance().setContents(this._duplicateNode(node));
    }

    public void nodePasteAction(SkinDocumentNode node) {
        SkinDocumentNode target = DocumentPasteboard.getInstance().getContents();
        if (target == null) {
            return;
        }
        SkinDocumentNode newValue = this._duplicateNode(target);
        newValue.setName(this._resolveName(newValue.getName() + " copy", node.children()));
        node.insertAtIndex(newValue, 0);
        this.nodeSelectAction(newValue);
    }

    public void nodeDuplicateAction(SkinDocumentNode node) {
        SkinDocumentNode parent = node.parent();
        SkinDocumentNode newValue = this._duplicateNode(node);
        newValue.setName(this._resolveName(node.getName() + " copy", parent.children()));
        parent.insertAtIndex(newValue, 0);
        this.nodeSelectAction(newValue);
    }

    public void nodeSelectAction(SkinDocumentNode node) {
        this.document.getHandler().documentDidSelectNode(node);
    }

    public Collection<UIMenuItem> getNodeMenuItems(SkinDocumentNode node, TreeView treeView) {
        DocumentMenuBuilder builder = new DocumentMenuBuilder(node, treeView);
        ArrayList<SkinDocumentNode> children = node.parent().children();
        boolean isEnabled = !node.isLocked();
        int order = children.indexOf(node);
        builder.add(0, "add").execute(this::nodeAddAction).enable(!node.isLocator());
        builder.add(0, "copy").execute(this::nodeCopyAction).enable(!node.isLocator());
        builder.add(0, "paste").execute(this::nodePasteAction).enable(DocumentPasteboard.getInstance().getContents() != null);
        builder.add(0, "delete").execute(this::nodeRemoveAction).enable(isEnabled);
        if (isEnabled) {
            builder.add(1, "duplicate").execute(this::nodeDuplicateAction).enable(!node.isLocator());
        }
        if (node.getType().getMaximumMarkersNeeded() != 0) {
            builder.add(2, "addLocator").execute(this::nodeAddLocatorAction);
        }
        builder.add(4, "moveUp").execute(this::nodeMoveUpAction).enable(isEnabled && order != 0);
        builder.add(4, "moveToTop").execute(this::nodeMoveToTopAction).enable(isEnabled && order != 0);
        builder.add(4, "moveDown").execute(this::nodeMoveDownAction).enable(isEnabled && order != children.size() - 1);
        builder.add(4, "moveToBottom").execute(this::nodeMoveToBottomAction).enable(isEnabled && order != children.size() - 1);
        return builder.build();
    }

    public void beginEditing() {
        this.synchronizer.beginCapture();
    }

    public void endEditing() {
        this.synchronizer.endCapture();
    }

    public SkinDocument getDocument() {
        return this.document;
    }

    public Collection<SkinDescriptor> getHistory() {
        LinkedHashSet<SkinDescriptor> allSkins = new LinkedHashSet<SkinDescriptor>();
        this._eachNode(this.document.getRoot(), it -> {
            if (!it.getSkin().isEmpty()) {
                allSkins.add(it.getSkin());
            }
        });
        return allSkins;
    }

    public DocumentConnector getConnector() {
        return this.connector;
    }

    public AdvancedBuilderBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    private SkinDocumentNode _duplicateNode(SkinDocumentNode node) {
        SkinDocumentNode newValue = new SkinDocumentNode(node.getName());
        newValue.setSkin(node.getSkin());
        newValue.setLocation(node.getLocation());
        newValue.setRotation(node.getRotation());
        newValue.setScale(node.getScale());
        newValue.setPivot(node.getPivot());
        node.children().forEach(it -> newValue.add(this._duplicateNode((SkinDocumentNode)it)));
        return newValue;
    }

    private String _resolveName(String name, List<SkinDocumentNode> nodes) {
        HashSet names = new HashSet();
        nodes.forEach(it -> names.add(it.getName()));
        String resolvedName = name;
        int i = 1;
        while (names.contains(resolvedName)) {
            resolvedName = name + " " + i;
            ++i;
        }
        return resolvedName;
    }

    private void _eachNode(SkinDocumentNode node, Consumer<SkinDocumentNode> consumer) {
        node.children().forEach(consumer);
        for (SkinDocumentNode child : node.children()) {
            this._eachNode(child, consumer);
        }
    }
}

