/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.vertex.PoseStack.Transform;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AbstractAdvancedGuideRenderer;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.texture.TextureData;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AdvancedEntityGuideRenderer
extends AbstractAdvancedGuideRenderer {
    protected final BakedArmature armature = this.getArmature();
    protected final TextureData texture = this.getTexture();
    protected final RenderType renderType = SkinRenderType.entityCutoutNoCull(new ResourceLocation(this.texture.getName()));

    public abstract TextureData getTexture();

    public abstract BakedArmature getArmature();

    @Override
    public void render(SkinDocument document, MatrixStack poseStack, int light, int overlay, IRenderTypeBuffer buffers) {
        poseStack.func_227860_a_();
        IJointTransform[] transforms = this.armature.getTransforms();
        Armature armature1 = this.armature.getArmature();
        for (IJoint joint : armature1.allJoints()) {
            JointShape shape = armature1.getShape(joint.getId());
            IJointTransform transform = transforms[joint.getId()];
            if (shape == null || transform == null) continue;
            poseStack.func_227860_a_();
            Transform.applyTransform(poseStack, transform);
            this.renderShape(shape, ColorUtils.getPaletteColor(joint.getId()), poseStack, buffers);
            poseStack.func_227865_b_();
        }
        poseStack.func_227865_b_();
    }

    protected void renderShape(JointShape shape, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        poseStack.func_227860_a_();
        Rectangle3f rect = shape.bounds();
        Transform.applyTransform(poseStack, shape.transform());
        this.renderCube(shape, poseStack, buffers);
        this.renderOutline(rect, color, poseStack, buffers);
        poseStack.func_227861_a_((double)rect.getX(), (double)rect.getY(), (double)rect.getZ());
        for (JointShape shape1 : shape.children()) {
            this.renderShape(shape1, color, poseStack, buffers);
        }
        poseStack.func_227865_b_();
    }

    protected void renderOutline(Rectangle3f rect, UIColor color, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        ShapeTesselator.stroke(rect, color, poseStack, buffers);
    }

    protected void renderCube(JointShape shape, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        for (Direction dir : Direction.values()) {
            this.renderCube(shape, dir, poseStack, buffers);
        }
    }

    private void renderCube(JointShape shape, Direction dir, MatrixStack poseStack, IRenderTypeBuffer buffers) {
        Rectangle3f rect = shape.bounds();
        Rectangle2f uv = shape.getUV(dir);
        if (uv == null) {
            return;
        }
        Matrix4f pose = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f normal = poseStack.func_227866_c_().func_227872_b_();
        IVertexBuilder builder = buffers.getBuffer(this.renderType);
        float x = rect.getX();
        float y = rect.getY();
        float z = rect.getZ();
        float w = rect.getWidth();
        float h = rect.getHeight();
        float d = rect.getDepth();
        float u = uv.getX();
        float v = uv.getY();
        float s = uv.getWidth();
        float t = uv.getHeight();
        float n = this.texture.getWidth();
        float m = this.texture.getHeight();
        float[][] uvs = SkinUtils.getRenderUVs(dir);
        float[][] vertexes = SkinUtils.getRenderVertexes(dir);
        for (int i = 0; i < 4; ++i) {
            builder.func_227888_a_(pose, x + w * vertexes[i][0], y + h * vertexes[i][1], z + d * vertexes[i][2]).func_225586_a_(255, 255, 255, 255).func_225583_a_((u + s * uvs[i][0]) / n, (v + t * uvs[i][1]) / m).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(normal, vertexes[4][0], vertexes[4][1], vertexes[4][2]).func_181675_d();
        }
    }
}

