/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import com.mojang.blaze3d.matrix.MatrixStack;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import extensions.com.mojang.blaze3d.vertex.PoseStack.Transform;
import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide.AbstractAdvancedGuideRenderer;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinModelManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.utils.ModelPartBuilder;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedItemGuideRenderer
extends AbstractAdvancedGuideRenderer {
    private final ModelRenderer armSolid = ModelPartBuilder.player().uv(40, 16).cube(-2.0f, -10.0f, -4.0f, 4.0f, 8.0f, 4.0f).offset(0.0f, 0.0f, 0.0f).build();
    private final ModelRenderer armTransparent = ModelPartBuilder.player().uv(40, 24).cube(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f).offset(0.0f, 0.0f, 0.0f).build();

    @Override
    public void render(SkinDocument document, MatrixStack poseStack, int light, int overlay, IRenderTypeBuffer buffers) {
        SkinDocumentNode node = this.findItemNode(document.getRoot());
        if (node == null) {
            return;
        }
        poseStack.func_227860_a_();
        this.applyTransform(poseStack, node, document.getItemTransforms());
        this.applyOffset(poseStack);
        this.renderModel(poseStack, light, overlay, buffers);
        poseStack.func_227865_b_();
    }

    protected void renderModel(MatrixStack poseStack, int light, int overlay, IRenderTypeBuffer buffers) {
        this.armSolid.func_228308_a_(poseStack, buffers.getBuffer(SkinRenderType.PLAYER_CUTOUT), 0xF000F0, overlay);
        this.armTransparent.func_228308_a_(poseStack, buffers.getBuffer(SkinRenderType.PLAYER_CUTOUT), 0xF000F0, overlay);
    }

    protected void applyTransform(MatrixStack poseStack, SkinDocumentNode node, SkinItemTransforms itemTransforms) {
        if (itemTransforms != null) {
            ITransformf itemTransform = itemTransforms.get(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND);
            if (itemTransform != null) {
                Transform.applyTransform(poseStack, itemTransform);
            }
        } else {
            MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
            IBakedModel model = SkinModelManager.getInstance().getModel(node.getType(), null, ItemStack.field_190927_a, (Entity)entity);
            float f1 = 16.0f;
            float f2 = 0.0625f;
            poseStack.func_227862_a_(f1, f1, f1);
            extensions.net.minecraft.client.resources.model.BakedModel.ABI.applyTransform(model, poseStack, false, AbstractItemTransformType.THIRD_PERSON_LEFT_HAND);
            poseStack.func_227862_a_(f2, f2, f2);
        }
    }

    protected void applyOffset(MatrixStack poseStack) {
        poseStack.func_227861_a_(0.0, 0.0, -2.0);
        poseStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        ABI.mulPose(poseStack, Vector3f.XP.rotationDegrees(-90.0f));
    }

    protected SkinDocumentNode findItemNode(SkinDocumentNode node) {
        if (node.getType() instanceof ICanHeld) {
            return node;
        }
        for (SkinDocumentNode child : node.children()) {
            SkinDocumentNode result = this.findItemNode(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

