/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.guide;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import org.jetbrains.annotations.Nullable;

public class AdvancedPartOffset {
    public static final Builder<MannequinEntity> MANNEQUIN_ENTITY = new Builder().put(SkinPartTypes.BIPPED_HAT, 0.0f, 0.0f, 0.0f).put(SkinPartTypes.BIPPED_HEAD, 0.0f, 0.0f, 0.0f).put(SkinPartTypes.BIPPED_CHEST, 0.0f, 0.0f, 0.0f).put(SkinPartTypes.BIPPED_TORSO, 0.0f, 6.0f, 0.0f).put(SkinPartTypes.BIPPED_LEFT_ARM, 5.0f, 2.0f, 0.0f, -10.0f, 0.0f, -10.0f).put(SkinPartTypes.BIPPED_RIGHT_ARM, -5.0f, 2.0f, 0.0f, -15.0f, 0.0f, 10.0f).put(SkinPartTypes.BIPPED_LEFT_HAND, 5.0f, 2.0f, 0.0f, -10.0f, 0.0f, -10.0f, 0.0f, 6.0f, 0.0f).put(SkinPartTypes.BIPPED_RIGHT_HAND, -5.0f, 2.0f, 0.0f, -15.0f, 0.0f, 10.0f, 0.0f, 6.0f, 0.0f).put(SkinPartTypes.BIPPED_SKIRT, 0.0f, 12.0f, 0.0f).put(SkinPartTypes.BIPPED_LEFT_THIGH, 2.0f, 12.0f, 0.0f, -1.0f, 0.0f, -1.0f).put(SkinPartTypes.BIPPED_RIGHT_THIGH, -2.0f, 12.0f, 0.0f, 1.0f, 0.0f, 1.0f).put(SkinPartTypes.BIPPED_LEFT_LEG, 2.0f, 12.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 6.0f, 0.0f).put(SkinPartTypes.BIPPED_RIGHT_LEG, -2.0f, 12.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 6.0f, 0.0f).put(SkinPartTypes.BIPPED_LEFT_FOOT, 2.0f, 12.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 8.0f, 0.0f).put(SkinPartTypes.BIPPED_RIGHT_FOOT, -2.0f, 12.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 8.0f, 0.0f).put(SkinPartTypes.BIPPED_LEFT_WING, 0.0f, 0.0f, 2.0f).put(SkinPartTypes.BIPPED_RIGHT_WING, 0.0f, 0.0f, 2.0f).put(SkinPartTypes.BIPPED_LEFT_PHALANX, 0.0f, 0.0f, 0.0f).put(SkinPartTypes.BIPPED_RIGHT_PHALANX, 0.0f, 0.0f, 0.0f);

    public static class Builder<T> {
        private final HashMap<ISkinPartType, Function<T, ITransformf>> poses = new HashMap();

        public Builder<T> put(ISkinPartType partType, float tx, float ty, float tz) {
            return this.put(partType, tx, ty, tz, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> put(ISkinPartType partType, float tx, float ty, float tz, float xRot, float yRot, float zRot) {
            return this.put(partType, tx, ty, tz, xRot, yRot, zRot, 0.0f, 0.0f, 0.0f);
        }

        public Builder<T> put(ISkinPartType partType, float tx, float ty, float tz, float xRot, float yRot, float zRot, float ax, float ay, float az) {
            Vector3f translate = new Vector3f(tx, ty, tz);
            Vector3f rotation = new Vector3f(xRot, yRot, zRot);
            Vector3f offset = new Vector3f(ax, ay, az);
            SkinTransform transform = SkinTransform.create(translate, rotation, Vector3f.ONE, Vector3f.ZERO, offset);
            return this.add(partType, it -> transform);
        }

        @Nullable
        public ITransformf get(T entity, ISkinPartType partType) {
            Function<T, ITransformf> provider = this.poses.get(partType);
            if (provider != null) {
                return provider.apply(entity);
            }
            return null;
        }

        private Builder<T> add(ISkinPartType partType, Function<T, ITransformf> provider) {
            this.poses.put(partType, provider);
            return this;
        }
    }
}

