/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextFieldDelegate;
import com.apple.library.uikit.UIView;
import com.google.common.base.Objects;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.data.IDataProperty;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinIconView;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModTextures;

public class AdvancedHeaderView
extends UIView
implements UITextFieldDelegate {
    protected SkinDescriptor selectedPart = SkinDescriptor.EMPTY;
    protected final UIButton selectionView = new UIButton(CGRect.ZERO);
    protected final UITextField textView = new UITextField(CGRect.ZERO);
    protected final UIView contentView = new UIView(CGRect.ZERO);
    protected final UIImageView arrowView = new UIImageView(CGRect.ZERO);
    protected final UIImageView partEmptyView = new UIImageView(CGRect.ZERO);
    protected final SkinIconView partPreviewView = new SkinIconView(CGRect.ZERO);
    protected Consumer<UIControl> picker;

    public AdvancedHeaderView(IDataProperty<String> name, IDataProperty<SkinDescriptor> part, CGRect frame) {
        super(frame);
        this.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(24.0f, 24.0f).fixed(24.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 4.0f).build());
        this.setupSelectionView();
        this.setupPartView(part);
        this.setupInputView(name);
    }

    @Override
    public boolean textFieldShouldReturn(UITextField textField) {
        this.textView.resignFirstResponder();
        return true;
    }

    private void setupPartView(IDataProperty<SkinDescriptor> property) {
        this.partEmptyView.setUserInteractionEnabled(false);
        this.partEmptyView.setFrame(this.contentView.bounds());
        this.partEmptyView.layer().setBorderWidth(1.0f);
        this.partEmptyView.layer().setBorderColor(-8388608);
        this.partEmptyView.setImage(UIImage.of(ModTextures.SKIN_PANEL).uv(224.0f, 0.0f).resizable(32.0f, 32.0f).build());
        this.partEmptyView.setAutoresizingMask(18);
        this.contentView.addSubview(this.partEmptyView);
        this.partPreviewView.setUserInteractionEnabled(false);
        this.partPreviewView.setBackgroundColor(UIColor.rgba(0x22AAAAAA));
        this.partPreviewView.setFrame(this.contentView.bounds());
        this.partPreviewView.setAutoresizingMask(18);
        this.partPreviewView.setHidden(true);
        this.contentView.addSubview(this.partPreviewView);
        property.addObserver(this::setSelectedPart);
    }

    private void setupSelectionView() {
        CGRect rect = this.bounds().insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        this.selectionView.setFrame(new CGRect(1.0f, 1.0f, rect.getHeight() + 8.0f + 4.0f, rect.getHeight()));
        this.selectionView.setAutoresizingMask(20);
        this.addSubview(this.selectionView);
        this.contentView.setFrame(new CGRect(6.0f, 4.0f, rect.getHeight() - 8.0f, rect.getHeight() - 8.0f));
        this.contentView.setAutoresizingMask(18);
        this.selectionView.addSubview(this.contentView);
        this.arrowView.setFrame(new CGRect(rect.getHeight() + 2.0f, (rect.getHeight() - 8.0f) / 2.0f, 8.0f, 8.0f));
        this.arrowView.setAutoresizingMask(41);
        this.arrowView.setImage(UIImage.of(ModTextures.LIST).uv(0.0f, 248.0f).fixed(8.0f, 8.0f).build());
        this.selectionView.addSubview(this.arrowView);
        this.selectionView.setBackgroundImage(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(120.0f, 24.0f).fixed(20.0f, 24.0f).clip(4.0f, 4.0f, 4.0f, 0.0f).build(), 0);
        this.selectionView.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, (self, ctrl) -> {
            if (self.picker != null) {
                self.picker.accept((UIControl)ctrl);
            }
        });
    }

    private void setupInputView(IDataProperty<String> property) {
        CGRect rect = this.bounds().insetBy(1.0f, 1.0f, 1.0f, 1.0f);
        this.textView.setBordered(false);
        this.textView.setBackgroundColor(UIColor.CLEAR);
        this.textView.setFont(UIFont.systemFont(11.0f));
        this.textView.setFrame(new CGRect(this.selectionView.frame().getMaxX() + 1.0f, 1.0f, rect.getWidth() - this.selectionView.frame().getMaxX() - 1.0f, rect.getHeight()));
        this.textView.setEditable(false);
        this.textView.setDelegate(this);
        this.textView.setAutoresizingMask(18);
        this.textView.setContents(UIImage.of(ModTextures.ADVANCED_SKIN_BUILDER).uv(124.0f, 24.0f).fixed(20.0f, 24.0f).clip(4.0f, 0.0f, 4.0f, 4.0f).build());
        this.textView.addTarget(property, UIControl.Event.EDITING_DID_BEGIN, (pro, ctr) -> pro.beginEditing());
        this.textView.addTarget(property, UIControl.Event.EDITING_DID_END, (pro, ctr) -> pro.endEditing());
        this.textView.addTarget(property, UIControl.Event.VALUE_CHANGED, (pro, ctr) -> {
            UITextField textView = (UITextField)ctr;
            pro.set(textView.text());
        });
        this.addSubview(this.textView);
        property.addObserver(newValue -> {
            String oldValue = this.textView.text();
            if (!Objects.equal((Object)oldValue, (Object)newValue)) {
                this.textView.setText((String)newValue);
            }
        });
    }

    public void setName(String name) {
        this.textView.setText(name);
    }

    public String getName() {
        return this.textView.text();
    }

    public void setEditable(boolean isEditable) {
        this.textView.setEditable(isEditable);
    }

    public boolean isEditable() {
        return this.textView.isEditable();
    }

    public void setPicker(Consumer<UIControl> picker) {
        this.picker = picker;
    }

    public Consumer<UIControl> getPicker() {
        return this.picker;
    }

    public void setSelectedPart(SkinDescriptor selectedPart) {
        this.selectedPart = selectedPart;
        this.partPreviewView.setSkin(selectedPart);
        this.partPreviewView.setHidden(selectedPart.isEmpty());
        this.partEmptyView.setHidden(!selectedPart.isEmpty());
    }

    public SkinDescriptor getSelectedPart() {
        return this.selectedPart;
    }
}

