/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.guide.IGuideDataProvider;
import moe.plushie.armourers_workshop.api.client.guide.IGuideRenderer;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.api.math.IRectangle3i;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperties;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.armourer.guide.GuideRendererManager;
import moe.plushie.armourers_workshop.builder.other.CubeTransform;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractBlockEntityRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinDynamicTexture;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TextureUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmourerBlockRenderer<T extends ArmourerBlockEntity>
extends AbstractBlockEntityRenderer<T> {
    private final PlayerTextureOverride override = new PlayerTextureOverride();
    private final Rectangle3f originBox = new Rectangle3f(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f);
    private final GuideRendererManager rendererManager = new GuideRendererManager();

    public ArmourerBlockRenderer(AbstractBlockEntityRendererProviderImpl.Context context) {
        super(context);
    }

    public void render(T entity, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer buffers, int light, int overlay) {
        ISkinType skinType = ((ArmourerBlockEntity)entity).getSkinType();
        SkinProperties skinProperties = ((ArmourerBlockEntity)entity).getSkinProperties();
        RenderData renderData = RenderData.of(entity);
        renderData.tick();
        ResourceLocation playerTexture = renderData.displayTextureLocation;
        if (playerTexture != null) {
            this.override.setTexture(playerTexture);
            this.override.setBuffers(buffers);
            buffers = this.override;
        }
        boolean isMultiBlocks = skinProperties.get(SkinProperty.BLOCK_MULTIBLOCK);
        boolean isShowGuides = ((ArmourerBlockEntity)entity).isShowGuides();
        boolean isShowModelGuides = ((ArmourerBlockEntity)entity).isShowModelGuides();
        boolean isShowHelper = ((ArmourerBlockEntity)entity).isShowHelper();
        boolean isUseHelper = ((ArmourerBlockEntity)entity).isUseHelper();
        renderData.shouldRenderOverlay = !isUseHelper;
        renderData.skinProperties = skinProperties;
        poseStack.func_227860_a_();
        this.transform(poseStack, entity);
        poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        float polygonOffset = 0.0f;
        for (ISkinPartType iSkinPartType : skinType.getParts()) {
            IGuideRenderer guideRenderer;
            IVector3i origin = iSkinPartType.getOffset();
            IRectangle3i rect = iSkinPartType.getBuildingSpace();
            IRectangle3i rect2 = iSkinPartType.getGuideSpace();
            float r = 0.5f;
            float g = 0.5f;
            float b = 0.5f;
            float a = 0.25f;
            if (iSkinPartType == SkinPartTypes.BLOCK_MULTI && !isMultiBlocks) continue;
            if (iSkinPartType == SkinPartTypes.BLOCK && isMultiBlocks) {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
                a = 0.2f;
            }
            boolean isModelOverridden = ((ArmourerBlockEntity)entity).isModelOverridden(iSkinPartType);
            if (isUseHelper) {
                isModelOverridden = !isShowHelper;
            }
            poseStack.func_227860_a_();
            poseStack.func_227861_a_((double)origin.getX(), (double)(origin.getY() + rect.getMinY()), (double)origin.getZ());
            poseStack.func_227861_a_((double)polygonOffset, (double)polygonOffset, (double)polygonOffset);
            if (!isModelOverridden && (guideRenderer = this.rendererManager.getRenderer(iSkinPartType)) != null) {
                poseStack.func_227860_a_();
                poseStack.func_227861_a_(0.0, (double)(-rect2.getMinY()), 0.0);
                poseStack.func_227862_a_(16.0f, 16.0f, 16.0f);
                guideRenderer.render(poseStack, renderData, 0xF000F0, OverlayTexture.field_229196_a_, buffers);
                poseStack.func_227865_b_();
            }
            poseStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            if (isShowGuides) {
                RenderSystem.drawCube(poseStack, rect, r, g, b, a, buffers);
                RenderSystem.drawCube(poseStack, (IRectangle3f)this.originBox, 0.0f, 1.0f, 0.0f, 0.5f, buffers);
            }
            if (isShowModelGuides && isModelOverridden) {
                RenderSystem.drawCube(poseStack, rect2, 0.0f, 0.0f, 1.0f, 0.25f, buffers);
            }
            poseStack.func_227865_b_();
            polygonOffset += 0.001f;
        }
        poseStack.func_227865_b_();
        this.override.setBuffers(null);
    }

    public void transform(MatrixStack poseStack, T entity) {
        poseStack.func_227861_a_(0.0, 1.0, 0.0);
        ABI.mulPose(poseStack, CubeTransform.getRotationDegrees(((ArmourerBlockEntity)entity).getFacing()));
    }

    @Override
    public int getViewDistance() {
        return 272;
    }

    public boolean shouldRenderOffScreen(T entity) {
        return true;
    }

    public static class PlayerTextureOverride
    implements IRenderTypeBuffer {
        protected final HashMap<RenderType, Supplier<RenderType>> overrides = new HashMap();
        protected ResourceLocation texture;
        protected IRenderTypeBuffer buffers;

        public void setBuffers(IRenderTypeBuffer buffers) {
            this.buffers = buffers;
        }

        public void setTexture(ResourceLocation texture) {
            if (Objects.equals(this.texture, texture)) {
                return;
            }
            this.overrides.clear();
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT_NO_CULL, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_CUTOUT, () -> SkinRenderType.entityCutoutNoCull(texture));
            this.overrides.put(SkinRenderType.PLAYER_TRANSLUCENT, () -> SkinRenderType.entityTranslucentCull(texture));
        }

        public IVertexBuilder getBuffer(RenderType renderType) {
            Supplier<RenderType> overrideRenderType = this.overrides.get(renderType);
            if (overrideRenderType != null) {
                renderType = overrideRenderType.get();
            }
            return this.buffers.getBuffer(renderType);
        }
    }

    public static class RenderData
    implements IGuideDataProvider {
        protected final ArmourerBlockEntity blockEntity;
        protected final SkinDynamicTexture displayTexture;
        protected final ResourceLocation displayTextureLocation;
        protected int lastVersion;
        protected boolean shouldRenderOverlay = false;
        protected ISkinProperties skinProperties;

        public RenderData(ArmourerBlockEntity blockEntity) {
            this.blockEntity = blockEntity;
            this.displayTexture = new SkinDynamicTexture();
            this.displayTextureLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a(RenderData.identifier(blockEntity), (DynamicTexture)this.displayTexture);
        }

        public static RenderData of(ArmourerBlockEntity blockEntity) {
            Object renderData = blockEntity.getRenderData();
            if (renderData instanceof RenderData) {
                return (RenderData)renderData;
            }
            RenderData renderData1 = new RenderData(blockEntity);
            blockEntity.setRenderData(renderData1);
            return renderData1;
        }

        public static String identifier(ArmourerBlockEntity blockEntity) {
            BlockPos pos = blockEntity.func_174877_v();
            return String.format("aw-armourer-%d-%d-%d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }

        protected void finalize() throws Throwable {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.displayTextureLocation);
            super.finalize();
        }

        public void tick() {
            this.displayTexture.setRefer(TextureUtils.getPlayerTextureLocation(this.blockEntity.getTextureDescriptor()));
            this.displayTexture.setPaintData(this.blockEntity.getPaintData());
        }

        @Override
        public boolean shouldRenderOverlay(ISkinProperty<Boolean> property) {
            if (this.shouldRenderOverlay) {
                return this.skinProperties.get(property) == false;
            }
            return false;
        }
    }
}

