/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.AdvancedBuilderMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class AdvancedExportPacket
extends CustomPacket {
    private final BlockPos pos;

    public AdvancedExportPacket(AdvancedBuilderBlockEntity blockEntity) {
        this.pos = blockEntity.func_174877_v();
    }

    public AdvancedExportPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
        if (!(blockEntity instanceof AdvancedBuilderBlockEntity) || !(player.field_71070_bA instanceof AdvancedBuilderMenu)) {
            this.abort((PlayerEntity)player, "unauthorized", "user status is incorrect");
            return;
        }
        if (!ModPermissions.ADVANCED_SKIN_BUILDER_SKIN_EXPORT.accept((PlayerEntity)player)) {
            this.abort((PlayerEntity)player, "export", "prohibited by the config file");
            return;
        }
        this.accept((PlayerEntity)player, "export");
        AdvancedBuilderBlockEntity blockEntity1 = (AdvancedBuilderBlockEntity)blockEntity;
        blockEntity1.exportFromDocument(player);
    }

    private void accept(PlayerEntity player, String op) {
        String playerName = player.func_195047_I_();
        ModLog.info("accept {} request of the '{}'", op, playerName);
    }

    private void abort(PlayerEntity player, String op, String reason) {
        String playerName = player.func_195047_I_();
        ModLog.info("abort {} request of the '{}', reason: '{}'", op, playerName, reason);
    }
}

