/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import extensions.net.minecraft.core.Registry.ForgeProvider;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.registry.IItemBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.client.AbstractItemStackRendererProvider;
import net.minecraft.item.Item;
import net.minecraft.util.registry.Registry;

public abstract class AbstractForgeItemBuilder<T extends Item>
implements IItemBuilder<T> {
    protected Item.Properties properties = new Item.Properties();
    protected IRegistryKey<IItemGroup> group;
    protected final Function<Item.Properties, T> supplier;

    public AbstractForgeItemBuilder(Function<Item.Properties, T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public IItemBuilder<T> bind(Supplier<AbstractItemStackRendererProvider> provider) {
        this.properties = this.properties.setISTER(() -> ((AbstractItemStackRendererProvider)provider.get())::create);
        return this;
    }

    @Override
    public IRegistryKey<T> build(String name) {
        return ForgeProvider.registerItemFO(Registry.class, name, () -> {
            Item value = (Item)this.supplier.apply(this.properties);
            if (this.group != null) {
                ((IItemGroup)this.group.get()).add(() -> value);
            }
            return value;
        });
    }
}

