/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.Arrays;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;

public class ArmatureTransformer {
    private final Armature armature;
    private final ArmaturePlugin[] plugins;
    private final IJointTransform[] transforms;

    public ArmatureTransformer(Armature armature, Collection<ArmaturePlugin> plugins) {
        this.armature = armature;
        this.plugins = plugins.toArray(new ArmaturePlugin[0]);
        this.transforms = new IJointTransform[armature.size()];
        Arrays.fill(this.transforms, IJointTransform.NONE);
    }

    public void put(IJoint joint, IJointTransform transform) {
        this.transforms[joint.getId()] = transform;
    }

    public Armature getArmature() {
        return this.armature;
    }

    public ArmaturePlugin[] getPlugins() {
        return this.plugins;
    }

    public IJointTransform[] getTransforms() {
        return this.transforms;
    }
}

