/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerBuilder;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;

public abstract class ArmatureTransformerManager {
    private final HashMap<ResourceLocation, ArmatureTransformerBuilder> pendingBuilders = new HashMap();
    private final HashMap<Class<?>, ArrayList<ArmatureTransformerBuilder>> modelBuilders = new HashMap();
    private int version = 0;

    protected abstract ArmatureTransformerBuilder createBuilder(ResourceLocation var1);

    public void clear() {
        this.pendingBuilders.clear();
    }

    public void append(IDataPackObject object, ResourceLocation location) {
        ArmatureTransformerBuilder builder = this.createBuilder(location);
        this.pendingBuilders.put(location, builder);
        builder.load(object);
    }

    public void freeze() {
        HashMap<ResourceLocation, ArmatureTransformerBuilder> builders1 = new HashMap<ResourceLocation, ArmatureTransformerBuilder>();
        this.pendingBuilders.forEach((name, builder) -> {
            ArmatureTransformerBuilder parent;
            ArrayList<ArmatureTransformerBuilder> chain = new ArrayList<ArmatureTransformerBuilder>();
            ArmatureTransformerBuilder nextBuilder = builder;
            while (nextBuilder.getParent() != null && (parent = this.pendingBuilders.get(nextBuilder.getParent())) != null) {
                chain.add(parent);
                nextBuilder = parent;
            }
            if (!chain.isEmpty()) {
                builder.resolve(chain);
            }
            builders1.put((ResourceLocation)name, (ArmatureTransformerBuilder)builder);
        });
        this.pendingBuilders.clear();
        builders1.forEach((name, builder) -> {
            boolean used = false;
            ArrayList<ResourceLocation> models = builder.getModels();
            if (!models.isEmpty()) {
                models.forEach(model -> {
                    Class<?> clazz = SkinRendererManager2.NAMED_CLASSES.get(model);
                    if (clazz != null) {
                        this.modelBuilders.computeIfAbsent(clazz, k -> new ArrayList()).add(builder);
                    }
                });
            }
        });
        ++this.version;
    }

    public ArmatureTransformer getTransformer(EntityType<?> entityType, IModel entityModel) {
        ArrayList classes = new ArrayList();
        ArrayList finalBuilders = new ArrayList();
        this.modelBuilders.forEach((clazz, builders) -> {
            if (clazz.isAssignableFrom(entityModel.getType())) {
                for (Class parent : classes) {
                    if (!clazz.isAssignableFrom(parent)) continue;
                    return;
                }
                classes.add(clazz);
                finalBuilders.addAll(builders);
            }
        });
        if (finalBuilders.size() >= 1) {
            return ((ArmatureTransformerBuilder)finalBuilders.get(finalBuilders.size() - 1)).build(entityModel);
        }
        return null;
    }

    public int getVersion() {
        return this.version;
    }
}

