/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.util.Direction;

public class JointShape {
    private final Rectangle3f rect;
    private final ITransformf transform;
    private final List<JointShape> children;
    private final Map<Direction, Rectangle2f> uvs;

    public JointShape(Vector3f origin, Vector3f size, float inflate, ITransformf transform, Map<Direction, Rectangle2f> uvs, List<JointShape> children) {
        float x = origin.getX() - inflate;
        float y = origin.getY() - inflate;
        float z = origin.getZ() - inflate;
        float w = size.getX() + inflate * 2.0f;
        float h = size.getY() + inflate * 2.0f;
        float d = size.getZ() + inflate * 2.0f;
        this.rect = new Rectangle3f(x, y, z, w, h, d);
        this.transform = transform;
        this.children = children;
        this.uvs = uvs;
    }

    public Rectangle2f getUV(Direction dir) {
        if (this.uvs != null) {
            return this.uvs.get(dir);
        }
        return null;
    }

    public List<JointShape> children() {
        return this.children;
    }

    public ITransformf transform() {
        return this.transform;
    }

    public Rectangle3f bounds() {
        return this.rect;
    }
}

