/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.layer.PlaceholderLayer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.SlimeGelLayer;
import net.minecraft.client.renderer.entity.layers.StayClothingLayer;
import net.minecraft.client.renderer.entity.layers.VillagerLevelPendantLayer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class DefaultLayerArmaturePlugin
extends ArmaturePlugin {
    private final ArrayList<Entry> entries = new ArrayList();
    private final ArrayList<EntryImpl<?, ?>> applying = new ArrayList();

    public static DefaultLayerArmaturePlugin villager() {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(VillagerLevelPendantLayer.class, plugin::whenHeadVisible);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin slime() {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(SlimeGelLayer.class, plugin::whenAnyVisible);
        return plugin;
    }

    public static DefaultLayerArmaturePlugin mob() {
        DefaultLayerArmaturePlugin plugin = new DefaultLayerArmaturePlugin();
        plugin.register(StayClothingLayer.class, plugin::whenBodyVisible);
        plugin.register(DrownedOuterLayer.class, plugin::whenBodyVisible);
        return plugin;
    }

    @Override
    public void activate(Entity entity, SkinRenderContext context) {
        this.entries.forEach(it -> {
            if (!it.tester.get().booleanValue()) {
                ((EntryImpl)it.impl).activate();
                this.applying.add(it.impl);
            }
        });
    }

    @Override
    public void deactivate(Entity entity, SkinRenderContext context) {
        this.applying.forEach((Consumer<EntryImpl<?, ?>>)((Consumer<EntryImpl>)rec$ -> ((EntryImpl)rec$).deactivate()));
        this.applying.clear();
    }

    @Override
    public IModel apply(IModel model) {
        this.entries.forEach(it -> {
            it.tester = it.testFactory.apply(model);
        });
        return model;
    }

    @Override
    public EntityRenderer<?> apply(EntityRenderer<?> entityRenderer) {
        LivingRenderer livingEntityRenderer = ObjectUtils.safeCast(entityRenderer, LivingRenderer.class);
        if (livingEntityRenderer != null) {
            this.apply(livingEntityRenderer);
        }
        return entityRenderer;
    }

    @Override
    public boolean freeze() {
        this.entries.removeIf(it -> it.tester == null || it.impl == null);
        return !this.entries.isEmpty();
    }

    private <T extends LivingEntity, M extends EntityModel<T>> void apply(LivingRenderer<T, M> entityRenderer) {
        List layers = entityRenderer.field_177097_h;
        for (LayerRenderer targetLayer : layers) {
            for (Entry entry : this.entries) {
                if (!entry.layerClass.isInstance(targetLayer)) continue;
                EntryImpl impl = new EntryImpl();
                impl.target = targetLayer;
                impl.placeholder = new PlaceholderLayer<T, M>(entityRenderer);
                impl.layers = () -> entityRenderer.field_177097_h;
                entry.impl = impl;
            }
        }
    }

    private void register(Class<?> clazz, Function<IModel, Supplier<Boolean>> testFactory) {
        Entry entry = new Entry();
        entry.layerClass = clazz;
        entry.testFactory = testFactory;
        this.entries.add(entry);
    }

    private Supplier<Boolean> whenHeadVisible(IModel model) {
        IModelPart modelPart = model.getPart("head");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    private Supplier<Boolean> whenAnyVisible(IModel model) {
        Iterator<IModelPart> iterator = model.getAllParts().iterator();
        if (iterator.hasNext()) {
            IModelPart part = iterator.next();
            return part::isVisible;
        }
        return null;
    }

    private Supplier<Boolean> whenBodyVisible(IModel model) {
        IModelPart modelPart = model.getPart("body");
        if (modelPart != null) {
            return modelPart::isVisible;
        }
        return null;
    }

    private static class Entry {
        Class<?> layerClass;
        Function<IModel, Supplier<Boolean>> testFactory;
        Supplier<Boolean> tester;
        EntryImpl<?, ?> impl;

        private Entry() {
        }
    }

    private static class EntryImpl<T extends Entity, M extends EntityModel<T>> {
        LayerRenderer<T, M> target;
        LayerRenderer<T, M> placeholder;
        Supplier<List<LayerRenderer<T, M>>> layers;
        int lastIndex = 0;

        private EntryImpl() {
        }

        private void activate() {
            this.set(this.target, this.placeholder);
        }

        private void deactivate() {
            this.set(this.placeholder, this.target);
        }

        private void set(LayerRenderer<T, M> from, LayerRenderer<T, M> to) {
            List<LayerRenderer<T, M>> layers = this.layers.get();
            if (this.lastIndex < layers.size() && layers.get(this.lastIndex) == from) {
                layers.set(this.lastIndex, to);
                return;
            }
            for (int index = 0; index < layers.size(); ++index) {
                if (layers.get(index) != from) continue;
                layers.set(index, to);
                this.lastIndex = index;
                break;
            }
        }
    }
}

