/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature.core;

import extensions.net.minecraft.world.entity.LivingEntity.AnimationModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.api.skin.property.ISkinProperty;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.client.other.SkinOverriddenManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class DefaultOverriddenArmaturePlugin
extends ArmaturePlugin {
    private final ArrayList<IModelPart> applying = new ArrayList();
    private final HashMap<ISkinProperty<Boolean>, Collection<IModelPart>> overrides = new HashMap();

    public DefaultOverriddenArmaturePlugin(IModel model, HashMap<String, Collection<String>> overrides) {
        overrides.forEach((key, names) -> {
            SkinProperty<Boolean> property = SkinProperty.normal(key, false);
            Collection<IModelPart> parts = this.buildParts((Collection<String>)names, model);
            this.overrides.put(property, parts);
        });
    }

    @Override
    public void prepare(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        if (entity instanceof LivingEntity && renderData.isLimitLimbs()) {
            AnimationModifier.applyLimitLimbs((LivingEntity)entity);
        }
    }

    @Override
    public void activate(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        SkinOverriddenManager overriddenManager = renderData.getOverriddenManager();
        overriddenManager.willRender(entity);
        this.overrides.forEach((key, value) -> {
            if (overriddenManager.contains((ISkinProperty<Boolean>)key)) {
                value.forEach(this::hidden);
            }
        });
    }

    @Override
    public void deactivate(Entity entity, SkinRenderContext context) {
        SkinRenderData renderData = context.getRenderData();
        SkinOverriddenManager overriddenManager = renderData.getOverriddenManager();
        overriddenManager.didRender(entity);
        this.applying.forEach(it -> it.setVisible(true));
        this.applying.clear();
    }

    private void hidden(IModelPart part) {
        if (ModDebugger.modelOverride) {
            return;
        }
        if (part.isVisible()) {
            part.setVisible(false);
            this.applying.add(part);
        }
    }

    private Collection<IModelPart> buildParts(Collection<String> names, IModel model) {
        if (names.contains("*")) {
            return model.getAllParts();
        }
        LinkedHashMap<String, IModelPart> parts = new LinkedHashMap<String, IModelPart>();
        for (String name : names) {
            IModelPart part = model.getPart(name);
            if (part == null) continue;
            parts.put(name, part);
        }
        return parts.values();
    }
}

