/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import com.google.common.collect.ImmutableMap;
import extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.block.HologramProjectorBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class HologramProjectorBlockEntity
extends RotableContainerBlockEntity {
    private static final ImmutableMap<?, Vector3f> FACING_TO_ROT = new ImmutableMap.Builder().put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.EAST), (Object)new Vector3f(180.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.NORTH), (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.WEST), (Object)new Vector3f(180.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.SOUTH), (Object)new Vector3f(180.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.EAST), (Object)new Vector3f(270.0f, 0.0f, 270.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.SOUTH), (Object)new Vector3f(270.0f, 0.0f, 180.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.WEST), (Object)new Vector3f(270.0f, 0.0f, 90.0f)).put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.NORTH), (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.EAST), (Object)new Vector3f(0.0f, 270.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.SOUTH), (Object)new Vector3f(0.0f, 180.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.WEST), (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.NORTH), (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();
    private final NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private OpenQuaternionf renderRotations;
    private int powerMode = 0;
    private float modelScale = 1.0f;
    private boolean isGlowing = true;
    private boolean isPowered = false;
    private boolean showRotationPoint = false;
    private Vector3f modelAngle = Vector3f.ZERO;
    private Vector3f modelOffset = Vector3f.ZERO;
    private Vector3f rotationSpeed = Vector3f.ZERO;
    private Vector3f rotationOffset = Vector3f.ZERO;

    public HologramProjectorBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
        this.modelAngle = OptionalAPI.getOptionalVector3f(tag, "Angle", Vector3f.ZERO);
        this.modelOffset = OptionalAPI.getOptionalVector3f(tag, "Offset", Vector3f.ZERO);
        this.rotationSpeed = OptionalAPI.getOptionalVector3f(tag, "RotSpeed", Vector3f.ZERO);
        this.rotationOffset = OptionalAPI.getOptionalVector3f(tag, "RotOffset", Vector3f.ZERO);
        this.isGlowing = OptionalAPI.getOptionalBoolean(tag, "Glowing", true);
        this.isPowered = OptionalAPI.getOptionalBoolean(tag, "Powered", false);
        this.modelScale = OptionalAPI.getOptionalFloat(tag, "Scale", 1.0f);
        this.powerMode = OptionalAPI.getOptionalInt(tag, "PowerMode", 0);
        this.setRenderChanged();
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        ItemStackHelper.func_191282_a((CompoundNBT)tag, this.items);
        OptionalAPI.putOptionalVector3f(tag, "Angle", this.modelAngle, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "Offset", this.modelOffset, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "RotSpeed", this.rotationSpeed, Vector3f.ZERO);
        OptionalAPI.putOptionalVector3f(tag, "RotOffset", this.rotationOffset, Vector3f.ZERO);
        OptionalAPI.putOptionalBoolean(tag, "Glowing", this.isGlowing, true);
        OptionalAPI.putOptionalBoolean(tag, "Powered", this.isPowered, false);
        OptionalAPI.putOptionalFloat(tag, "Scale", this.modelScale, 1.0f);
        OptionalAPI.putOptionalInt(tag, "PowerMode", this.powerMode, 0);
    }

    public void updatePowerStats() {
        boolean newValue = this.isRunningForState(this.func_195044_w());
        if (newValue != this.isPowered) {
            this.updateBlockStates();
        }
    }

    public void updateBlockStates() {
        BlockState state = this.func_195044_w();
        this.isPowered = this.isRunningForState(state);
        this.func_70296_d();
        this.setRenderChanged();
        boolean growing = this.isPowered && this.isGlowing;
        World level = this.func_145831_w();
        if (level != null && !level.func_201670_d()) {
            if ((Boolean)state.func_177229_b((Property)HologramProjectorBlock.LIT) != growing) {
                BlockState newState = (BlockState)state.func_206870_a((Property)HologramProjectorBlock.LIT, (Comparable)Boolean.valueOf(growing));
                level.func_180501_a(this.func_174877_v(), newState, 2);
            } else {
                level.func_184138_a(this.func_174877_v(), state, state, 2);
            }
        }
    }

    public int getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(int powerMode) {
        this.powerMode = powerMode;
        this.updateBlockStates();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    protected boolean isRunningForState(BlockState state) {
        World level = this.func_145831_w();
        if (level != null && !SkinDescriptor.of((ItemStack)this.items.get(0)).isEmpty()) {
            switch (this.powerMode) {
                case 1: {
                    return level.func_175640_z(this.func_174877_v());
                }
                case 2: {
                    return !level.func_175640_z(this.func_174877_v());
                }
            }
            return true;
        }
        return false;
    }

    public boolean isOverrideLight() {
        return this.isGlowing;
    }

    public boolean isOverrideOrigin() {
        return true;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void setGlowing(boolean glowing) {
        this.isGlowing = glowing;
        this.updateBlockStates();
    }

    public void setShowRotationPoint(boolean showRotationPoint) {
        this.showRotationPoint = showRotationPoint;
    }

    public boolean shouldShowRotationPoint() {
        return this.showRotationPoint;
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setContainerChanged() {
        super.setContainerChanged();
        this.updateBlockStates();
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return !SkinDescriptor.of(itemStack).isEmpty();
    }

    public int func_70302_i_() {
        return 1;
    }

    public Vector3f getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(Vector3f rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        this.updateBlockStates();
    }

    public Vector3f getRotationOffset() {
        return this.rotationOffset;
    }

    public void setRotationOffset(Vector3f rotationOffset) {
        this.rotationOffset = rotationOffset;
        this.updateBlockStates();
    }

    public Vector3f getModelOffset() {
        return this.modelOffset;
    }

    public void setModelOffset(Vector3f modelOffset) {
        this.modelOffset = modelOffset;
        this.updateBlockStates();
    }

    public Vector3f getModelAngle() {
        return this.modelAngle;
    }

    public void setModelAngle(Vector3f modelAngle) {
        this.modelAngle = modelAngle;
        this.updateBlockStates();
    }

    public float getModelScale() {
        return this.modelScale;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        AttachFace face = blockState.func_235903_d_((Property)HologramProjectorBlock.FACE).orElse(AttachFace.FLOOR);
        Direction facing = blockState.func_235903_d_((Property)HologramProjectorBlock.field_185512_D).orElse(Direction.NORTH);
        Vector3f rot = (Vector3f)FACING_TO_ROT.getOrDefault((Object)Pair.of((Object)face, (Object)facing), (Object)Vector3f.ZERO);
        this.renderRotations = new OpenQuaternionf(rot.getX(), rot.getY(), rot.getZ(), true);
        return this.renderRotations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Rectangle3f getRenderBoundingBox(BlockState blockState) {
        if (!this.isPowered()) {
            return null;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(this.func_70301_a(0));
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.TEST);
        if (bakedSkin == null) {
            return null;
        }
        Rectangle3f rect = bakedSkin.getRenderBounds(SkinItemSource.EMPTY);
        float f = 0.0625f;
        float scale = this.getModelScale() * f;
        float modelRadius = 0.0f;
        float rotationRadius = 0.0f;
        if (!rect.equals(Rectangle3f.ZERO)) {
            double x = MathUtils.absMax(rect.getMinX(), rect.getMaxX());
            double y = MathUtils.absMax(rect.getMinY(), rect.getMaxY());
            double z = MathUtils.absMax(rect.getMinZ(), rect.getMaxZ());
            modelRadius = MathUtils.sqrt(x * x + y * y + z * z);
        }
        if (!this.rotationOffset.equals(Vector3f.ZERO)) {
            float x = Math.abs(this.rotationOffset.getX());
            float y = Math.abs(this.rotationOffset.getY());
            float z = Math.abs(this.rotationOffset.getZ());
            rotationRadius = MathUtils.sqrt(x * x + y * y + z * z);
        }
        float tr = (rotationRadius + modelRadius) * scale;
        float tx = this.modelOffset.getX() * scale;
        float ty = this.modelOffset.getY() * scale + 0.5f;
        float tz = this.modelOffset.getZ() * scale;
        if (this.isOverrideOrigin()) {
            ty += rect.getMaxY() * scale;
        }
        return new Rectangle3f(tx - tr, ty - tr, tz - tr, tr * 2.0f, tr * 2.0f, tr * 2.0f);
    }
}

