/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.capability;

import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.ITagRepresentable;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeStorage;
import moe.plushie.armourers_workshop.core.data.SkinDataStorage;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.core.network.UpdateWardrobePacket;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class SkinWardrobe
implements ITagRepresentable<CompoundNBT> {
    private final BitSet flags = new BitSet(6);
    private final HashMap<SkinSlotType, Integer> skinSlots = new HashMap();
    private final Inventory inventory = new Inventory(SkinSlotType.getTotalSize());
    private final WeakReference<Entity> entity;
    private int id;
    private EntityProfile profile;

    public SkinWardrobe(Entity entity, EntityProfile profile) {
        this.id = entity.func_145782_y();
        this.entity = new WeakReference<Entity>(entity);
        this.profile = profile;
    }

    @Nullable
    public static SkinWardrobe of(@Nullable Entity entity) {
        if (entity != null) {
            return SkinDataStorage.getWardrobe(entity).orElse(null);
        }
        return null;
    }

    public static Optional<SkinWardrobe> create(Entity entity) {
        EntityProfile profile = ModEntityProfiles.getProfile(entity);
        if (profile != null) {
            return Optional.of(new SkinWardrobe(entity, profile));
        }
        return Optional.empty();
    }

    public void setProfile(EntityProfile profile) {
        this.profile = profile;
    }

    public EntityProfile getProfile() {
        return this.profile;
    }

    public int getFreeSlot(SkinSlotType slotType) {
        int unlockedSize = this.getUnlockedSize(slotType);
        for (int i = 0; i < unlockedSize; ++i) {
            if (!this.inventory.func_70301_a(slotType.getIndex() + i).func_190926_b()) continue;
            return i;
        }
        return unlockedSize - 1;
    }

    public ItemStack getItem(SkinSlotType slotType, int slot) {
        if (slot >= this.getUnlockedSize(slotType)) {
            return ItemStack.field_190927_a;
        }
        return this.inventory.func_70301_a(slotType.getIndex() + slot);
    }

    public void setItem(SkinSlotType slotType, int slot, ItemStack itemStack) {
        if (slot >= this.getUnlockedSize(slotType)) {
            return;
        }
        this.inventory.func_70299_a(slotType.getIndex() + slot, itemStack);
    }

    public void dropAll(@Nullable Consumer<ItemStack> consumer) {
        int containerSize = this.inventory.func_70302_i_();
        int ignoredStart = SkinSlotType.DYE.getIndex() + 8;
        int ignoredEnd = SkinSlotType.DYE.getIndex() + SkinSlotType.DYE.getMaxSize();
        for (int i = 0; i < containerSize; ++i) {
            ItemStack itemStack;
            if (i >= ignoredStart && i < ignoredEnd || (itemStack = this.inventory.func_70301_a(i)).func_190926_b()) continue;
            if (consumer != null) {
                consumer.accept(itemStack);
            }
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public void clear() {
        this.inventory.func_174888_l();
    }

    public void sendToServer() {
        NetworkManager.sendToServer(UpdateWardrobePacket.sync(this));
    }

    public void broadcast() {
        NetworkManager.sendToTracking(UpdateWardrobePacket.sync(this), this.getEntity());
    }

    public void broadcast(ServerPlayerEntity player) {
        NetworkManager.sendTo(UpdateWardrobePacket.sync(this), player);
    }

    public boolean shouldRenderEquipment(EquipmentSlotType slotType) {
        return !this.flags.get(slotType.func_188452_c());
    }

    public void setRenderEquipment(EquipmentSlotType slotType, boolean enable) {
        if (enable) {
            this.flags.clear(slotType.func_188452_c());
        } else {
            this.flags.set(slotType.func_188452_c());
        }
    }

    public boolean shouldRenderExtra() {
        return !this.flags.get(6);
    }

    public void setRenderExtra(boolean value) {
        if (value) {
            this.flags.clear(6);
        } else {
            this.flags.set(6);
        }
    }

    public BitSet getFlags() {
        return this.flags;
    }

    public void setUnlockedSize(SkinSlotType slotType, int size) {
        if (slotType != SkinSlotType.DYE) {
            this.skinSlots.put(slotType, size);
        }
    }

    public int getUnlockedSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        Integer modifiedSize = this.skinSlots.get((Object)slotType);
        if (modifiedSize != null) {
            return Math.min(slotType.getMaxSize(), modifiedSize);
        }
        return Math.min(slotType.getMaxSize(), this.profile.getMaxCount(slotType));
    }

    public int getMaximumSize(SkinSlotType slotType) {
        if (slotType == SkinSlotType.DYE) {
            return 8;
        }
        return slotType.getMaxSize();
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public Entity getEntity() {
        return (Entity)this.entity.get();
    }

    public int getId() {
        Entity entity = this.getEntity();
        if (entity != null) {
            this.id = entity.func_145782_y();
        }
        return this.id;
    }

    public boolean isEditable(PlayerEntity player) {
        if (!ModPermissions.OPEN.accept(ModMenuTypes.WARDROBE, this.getEntity(), player)) {
            return false;
        }
        Entity entity = this.getEntity();
        if (entity instanceof PlayerEntity && entity.func_145782_y() != player.func_145782_y()) {
            return false;
        }
        if (!ModConfig.Common.canOpenWardrobe(entity, player)) {
            return false;
        }
        return !this.getProfile().isLocked();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        SkinWardrobeStorage.saveSkinSlots(this.skinSlots, nbt);
        SkinWardrobeStorage.saveFlags(this.flags, nbt);
        SkinWardrobeStorage.saveInventoryItems((IInventory)this.inventory, nbt);
        SkinWardrobeStorage.saveDataFixer(this, nbt);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        SkinWardrobeStorage.loadSkinSlots(this.skinSlots, nbt);
        SkinWardrobeStorage.loadFlags(this.flags, nbt);
        SkinWardrobeStorage.loadInventoryItems((IInventory)this.inventory, nbt);
        SkinWardrobeStorage.loadDataFixer(this, nbt);
    }
}

