/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointFilter;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.Armatures;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;

public class BakedArmature {
    private static final HashMap<Armature, BakedArmature> DEFAULT_ARMATURES = new HashMap();
    private final Armature armature;
    private final IJointTransform[] defaultTransforms;
    private IJointFilter filter;
    private IJointTransform[] finalTransforms;

    public BakedArmature(Armature armature) {
        this.armature = armature;
        this.defaultTransforms = new IJointTransform[armature.size()];
        this.finalTransforms = this.defaultTransforms;
        for (int i = 0; i < this.defaultTransforms.length; ++i) {
            this.defaultTransforms[i] = armature.getGlobalTransform(i);
        }
    }

    public static BakedArmature defaultBy(Armature armature) {
        return DEFAULT_ARMATURES.computeIfAbsent(armature, BakedArmature::new);
    }

    public static BakedArmature defaultBy(ISkinType skinType) {
        return BakedArmature.defaultBy(Armatures.byType(skinType));
    }

    public void setFilter(IJointFilter filter) {
        this.filter = filter;
    }

    public IJointFilter getFilter() {
        return this.filter;
    }

    public void seTransforms(IJointTransform[] transforms) {
        this.finalTransforms = transforms != null ? transforms : this.defaultTransforms;
    }

    public IJointTransform[] getTransforms() {
        return this.finalTransforms;
    }

    public IJointTransform getTransform(ISkinPartType partType) {
        IJoint joint = this.getJoint(partType);
        if (joint != null) {
            return this.finalTransforms[joint.getId()];
        }
        return null;
    }

    public IJoint getJoint(ISkinPartType partType) {
        IJoint joint = this.armature.getJoint(partType);
        if (joint != null && this.filter != null && !this.filter.test(joint)) {
            return null;
        }
        return joint;
    }

    public Armature getArmature() {
        return this.armature;
    }

    public IJointTransform getTransform(BakedSkinPart bakedPart) {
        ISkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.BIPPED_LEFT_WING && bakedPart.getProperties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.getTransform(SkinPartTypes.BIPPED_LEFT_PHALANX);
        }
        if (partType == SkinPartTypes.BIPPED_RIGHT_WING && bakedPart.getProperties().get(SkinProperty.WINGS_MATCHING_POSE).booleanValue()) {
            return this.getTransform(SkinPartTypes.BIPPED_RIGHT_PHALANX);
        }
        return this.getTransform(partType);
    }
}

