/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import extensions.net.minecraft.client.renderer.block.model.ItemTransform.Constructor;
import extensions.net.minecraft.client.renderer.item.ItemPropertyFunction.ABI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedItemModel
extends BuiltInModel {
    public static final BakedItemModel DEFAULT = BakedItemModel.from(new DefaultItemTransforms(), false);
    private final Variant[] variants;

    public BakedItemModel(ItemCameraTransforms itemTransforms, Variant[] variants, boolean usesBlockLight) {
        super(itemTransforms, ItemOverrideList.field_188022_a, null, usesBlockLight);
        this.variants = variants;
    }

    public IBakedModel resolve(IBakedModel bakedModel, ItemStack itemStack, @Nullable ClientWorld level, @Nullable LivingEntity entity, int i) {
        for (Variant variant : this.variants) {
            if (!variant.test(itemStack, level, entity, i)) continue;
            return variant.model;
        }
        return bakedModel;
    }

    public static BakedItemModel from(SkinItemTransforms itemTransforms, boolean usesBlockLight) {
        return BakedItemModel.from(Collections.emptyList(), itemTransforms, usesBlockLight);
    }

    public static BakedItemModel from(Collection<String> overrideNames, SkinItemTransforms itemTransforms, boolean usesBlockLight) {
        Baker baker = new Baker(itemTransforms, usesBlockLight);
        ArrayList<Variant> entries = new ArrayList<Variant>();
        for (String name : overrideNames) {
            ResourceLocation registryName = new ResourceLocation(name);
            BakedItemModel model = baker.bake(name, new Variant[0]);
            entries.add(new Variant(registryName, (IBakedModel)model));
        }
        return baker.bake("", entries.toArray(new Variant[0]));
    }

    public static class Variant {
        private final ResourceLocation name;
        private final IBakedModel model;

        public Variant(ResourceLocation name, IBakedModel model) {
            this.name = name;
            this.model = model;
        }

        public boolean test(ItemStack itemStack, @Nullable ClientWorld level, @Nullable LivingEntity entity, int i) {
            Item item = itemStack.func_77973_b();
            IItemPropertyGetter func = ItemModelsProperties.func_239417_a_((Item)item, (ResourceLocation)this.name);
            if (func != null) {
                return ABI.call(func, itemStack, level, entity, i) >= 1.0f;
            }
            return false;
        }
    }

    public static class Baker {
        private String prefix = "";
        private final boolean usesBlockLight;
        private final SkinItemTransforms itemTransforms;

        public Baker(SkinItemTransforms itemTransforms, boolean usesBlockLight) {
            this.itemTransforms = itemTransforms;
            this.usesBlockLight = usesBlockLight;
        }

        public BakedItemModel bake(String prefix, Variant[] entries) {
            this.prefix = prefix;
            return new BakedItemModel(this.getTransforms(), entries, this.usesBlockLight);
        }

        private ItemCameraTransforms getTransforms() {
            ItemTransformVec3f thirdPersonLeftHand = this.getTransform(AbstractItemTransformType.THIRD_PERSON_LEFT_HAND);
            ItemTransformVec3f thirdPersonRightHand = this.getTransform(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND);
            ItemTransformVec3f firstPersonLeftHand = this.getTransform(AbstractItemTransformType.FIRST_PERSON_LEFT_HAND);
            ItemTransformVec3f firstPersonRightHand = this.getTransform(AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND);
            ItemTransformVec3f head = this.getTransform(AbstractItemTransformType.HEAD);
            ItemTransformVec3f gui = this.getTransform(AbstractItemTransformType.GUI);
            ItemTransformVec3f ground = this.getTransform(AbstractItemTransformType.GROUND);
            ItemTransformVec3f fixed = this.getTransform(AbstractItemTransformType.FIXED);
            return new ItemCameraTransforms(thirdPersonLeftHand, thirdPersonRightHand, firstPersonLeftHand, firstPersonRightHand, head, gui, ground, fixed);
        }

        private ItemTransformVec3f getTransform(AbstractItemTransformType key) {
            ITransformf transform = (ITransformf)this.itemTransforms.get(this.prefix + ";" + key.getName());
            if (transform == null) {
                transform = this.itemTransforms.get(key);
            }
            return Constructor.from(ItemTransformVec3f.class, transform);
        }
    }

    public static class DefaultItemTransforms
    extends SkinItemTransforms {
        public DefaultItemTransforms() {
            this.put(AbstractItemTransformType.GUI, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(30.0f, 135.0f, 0.0f), DefaultItemTransforms.scale(1.0f, 1.0f, 1.0f));
            this.put(AbstractItemTransformType.FIXED, DefaultItemTransforms.translate(0.0f, 0.0f, -2.0f), DefaultItemTransforms.rotation(0.0f, 0.0f, 0.0f), DefaultItemTransforms.scale(1.0f, 1.0f, 1.0f));
            this.put(AbstractItemTransformType.GROUND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 0.0f, 0.0f), DefaultItemTransforms.scale(0.5f, 0.5f, 0.5f));
            this.put(AbstractItemTransformType.THIRD_PERSON_RIGHT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.THIRD_PERSON_LEFT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.FIRST_PERSON_RIGHT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
            this.put(AbstractItemTransformType.FIRST_PERSON_LEFT_HAND, DefaultItemTransforms.translate(0.0f, 0.0f, 0.0f), DefaultItemTransforms.rotation(0.0f, 90.0f, -5.0f), DefaultItemTransforms.scale(0.8f, 0.8f, 0.8f));
        }

        private void put(AbstractItemTransformType key, Vector3f translate, Vector3f rotation, Vector3f scale) {
            this.put(key, SkinTransform.create(translate, rotation, scale));
        }

        private static Vector3f translate(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }

        private static Vector3f rotation(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }

        private static Vector3f scale(float x, float y, float z) {
            return new Vector3f(x, y, z);
        }
    }
}

